/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.passwordreset;

import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.OneTimeLinkVerificationRequired;
import com.pingidentity.sdk.api.authn.model.state.Resume;
import com.pingidentity.sdk.api.authn.model.state.SuccessfulPasswordReset;
import com.pingidentity.sdk.api.authn.spec.AuthnActionSpec;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class ApiPasswordResetSuccessHandler
extends PasswordResetHandler {
    @Override
    public AuthnState<?> getAuthnState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AuthnState state;
        PasswordResetSessionState sessionState = ApiPasswordResetSuccessHandler.getSessionState(request, response);
        String messageKey = sessionState.getSuccessMessageKey();
        if (this.isResetSuccessMessage(messageKey)) {
            state = CommonStateSpec.SUCCESSFUL_PASSWORD_RESET.makeInstance(request, (Object)((SuccessfulPasswordReset)this.getApiModel(request, response, templateParams)));
            boolean isDirectLink = !sessionState.isFromHtmlFormAdapter();
            String targetResource = sessionState.getTargetResource();
            if (isDirectLink && targetResource != null) {
                Resume model = new Resume();
                model.setResumeUrl(targetResource);
                state = CommonStateSpec.RESUME.makeInstance(request, (Object)model);
            } else if (isDirectLink || targetResource == null) {
                state.removeAction("continueAuthentication");
            }
        } else if ("forgot-password-success.onetimeLinkSent".equals(messageKey)) {
            state = CommonStateSpec.ACCOUNT_RECOVERY_OTL_VERIFICATION_REQUIRED.makeInstance(request, (Object)((OneTimeLinkVerificationRequired)this.getApiModel(request, response, templateParams)));
        } else {
            throw new ProcessRuntimeException("Unable to locate valid message key.");
        }
        return state;
    }

    @Override
    public Object getApiModel(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        String messageKey = ApiPasswordResetSuccessHandler.getSessionState(request, response).getSuccessMessageKey();
        if (this.isResetSuccessMessage(messageKey)) {
            return new SuccessfulPasswordReset();
        }
        if ("forgot-password-success.onetimeLinkSent".equals(messageKey)) {
            return new OneTimeLinkVerificationRequired();
        }
        throw new ProcessRuntimeException("Unable to locate valid message key.");
    }

    @Override
    public AuthnError getApiError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        return null;
    }

    @Override
    public Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        String messageKey = ApiPasswordResetSuccessHandler.getSessionState(request, response).getSuccessMessageKey();
        if (this.isResetSuccessMessage(messageKey)) {
            return ApiPasswordResetSuccessHandler.getActionIdToModelMapping(CommonStateSpec.SUCCESSFUL_PASSWORD_RESET);
        }
        if ("forgot-password-success.onetimeLinkSent".equals(messageKey)) {
            return ApiPasswordResetSuccessHandler.getActionIdToModelMapping(CommonStateSpec.ACCOUNT_RECOVERY_OTL_VERIFICATION_REQUIRED);
        }
        throw new ProcessRuntimeException("Unable to locate valid message key.");
    }

    private static Map<String, Class<?>> getActionIdToModelMapping(AuthnStateSpec<?> authnStateSpec) {
        HashMap actionIdToModelMapping = new HashMap();
        for (AuthnActionSpec actionSpec : authnStateSpec.getActions()) {
            actionIdToModelMapping.put(actionSpec.getId(), actionSpec.getModelClass());
        }
        return actionIdToModelMapping;
    }

    protected boolean isResetSuccessMessage(String messageKey) {
        return "forgot-password-success.passwordChangeSuccessful".equals(messageKey) || "forgot-password-success.passwordChangeSuccessfulNoContinue".equals(messageKey);
    }
}

