/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.passwordreset;

import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.adapters.htmlform.render.util.CaptchaProviderRenderUtil;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.AccountRecoveryUsernameRequired;
import com.pingidentity.sdk.api.authn.model.state.interfaces.CaptchaProviderEnabledState;
import com.pingidentity.sdk.api.authn.spec.AuthnActionSpec;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApiPasswordResetUsernameRequiredHandler
extends PasswordResetHandler {
    private boolean supportUsernameRecovery;

    public ApiPasswordResetUsernameRequiredHandler(boolean supportUsernameRecovery) {
        this.supportUsernameRecovery = supportUsernameRecovery;
    }

    @Override
    public AuthnState<?> getAuthnState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AuthnState state = CommonStateSpec.ACCOUNT_RECOVERY_USERNAME_REQUIRED.makeInstance(request, (Object)((AccountRecoveryUsernameRequired)this.getApiModel(request, response, templateParams)));
        if (!this.supportUsernameRecovery) {
            state.removeAction(CommonActionSpec.RECOVER_USERNAME.getId());
        }
        return state;
    }

    @Override
    public Object getApiModel(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AccountRecoveryUsernameRequired model = new AccountRecoveryUsernameRequired();
        CaptchaProviderRenderUtil.addCaptchaProviderParametersToModels((CaptchaProviderEnabledState)model, templateParams);
        return model;
    }

    @Override
    public AuthnError getApiError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        return null;
    }

    @Override
    public Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        HashMap actionIdToModelMapping = new HashMap();
        for (AuthnActionSpec actionSpec : CommonStateSpec.ACCOUNT_RECOVERY_USERNAME_REQUIRED.getActions()) {
            actionIdToModelMapping.put(actionSpec.getId(), actionSpec.getModelClass());
        }
        if (!this.supportUsernameRecovery) {
            actionIdToModelMapping.remove(CommonActionSpec.RECOVER_USERNAME.getId());
        }
        return actionIdToModelMapping;
    }
}

