/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.access.CaptchaProviderAccessor;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.sdk.api.authn.model.state.interfaces.CaptchaEnabledState;
import com.pingidentity.sdk.api.authn.model.state.interfaces.CaptchaProviderEnabledState;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.util.ObjectMapperFactory;

public final class CaptchaProviderRenderUtil {
    private static final ObjectMapper mapper = ObjectMapperFactory.buildObjectMapper();

    private CaptchaProviderRenderUtil() {
    }

    public static void addCaptchaProviderParametersToTemplateParameters(HttpServletRequest request, HttpServletResponse response, String captchaProviderId, String action, String legacySiteKeyParam, Map<String, Object> templateParams) throws IOException {
        CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)captchaProviderId);
        templateParams.put(TemplateKey.CAPTCHA_PROVIDER_TYPE.getKey(), captchaProvider.getPluginDescriptor().getType());
        templateParams.put(TemplateKey.CAPTCHA_SCRIPT_NAME.getKey(), captchaProvider.getJavaScriptFileName());
        CaptchaContext captchaContext = new CaptchaContext.Builder().setRequest(request).setResponse(response).setAction(action).build();
        Map captchaAttributes = captchaProvider.getCaptchaAttributes(captchaContext);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            templateParams.put(TemplateKey.CAPTCHA_ATTRIBUTES.getKey(), captchaAttributes);
        } else {
            templateParams.put(TemplateKey.CAPTCHA_ATTRIBUTES.getKey(), mapper.writeValueAsString((Object)captchaAttributes));
        }
        if ("reCAPTCHA v2 Invisible".equals(captchaProvider.getPluginDescriptor().getType())) {
            templateParams.put(legacySiteKeyParam, captchaAttributes.get("siteKey"));
        }
    }

    public static void addCaptchaProviderParametersToModels(CaptchaProviderEnabledState model, Map<String, Object> templateParams) {
        Boolean captchaFeatureAvailable = TemplateKey.CAPTCHA_ENABLED.getBooleanValue(templateParams);
        boolean showCaptcha = captchaFeatureAvailable != null && captchaFeatureAvailable != false;
        model.setShowCaptcha(showCaptcha);
        if (showCaptcha) {
            model.setCaptchaProviderType(TemplateKey.CAPTCHA_PROVIDER_TYPE.getStringValue(templateParams));
            model.setCaptchaAttributes((Map)TemplateKey.CAPTCHA_ATTRIBUTES.getObjectValue(templateParams));
            if (model instanceof CaptchaEnabledState) {
                ((CaptchaEnabledState)model).setCaptchaSiteKey(TemplateKey.SITE_KEY.getStringValue(templateParams));
            }
        }
    }
}

