/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.state.SessionStateSupport;

public class HtmlFormSessionStateSupport
extends SessionStateSupport {
    public void refreshSession(String key, HttpServletRequest req, HttpServletResponse resp) {
        this.setAttribute(key, System.currentTimeMillis(), req, resp, false);
    }

    public void setInactivityTimeout(String key, int timeout, HttpServletRequest req, HttpServletResponse resp) {
        this.setAttribute(key, timeout, req, resp, false);
    }

    public Integer getInactivityTimeout(String key, HttpServletRequest req, HttpServletResponse resp) {
        return (Integer)this.getAttribute(key, req, resp);
    }

    public boolean isSessionExpired(String lastActivityKey, Integer inactivityTimeout, HttpServletRequest req, HttpServletResponse resp) {
        if (inactivityTimeout == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        Long lastActivity = (Long)this.getAttribute(lastActivityKey, req, resp);
        if (lastActivity == null) {
            return true;
        }
        return lastActivity + (long)(inactivityTimeout * 1000 * 60) <= currentTime;
    }
}

