/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.httpbasic.config;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.PasswordCredentialValidatorFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class HttpBasicGuiConfiguration {
    public static final String FIELD_REALM = "Realm";
    public static final String DESC_REALM = "Authentication Realm: a name associated with the protected area.";
    public static final String FIELD_RETRIES = "Challenge Retries";
    public static final String DESC_RETRIES = "Number of allowed login attempts";
    public static final String ATTR_NAME_USERID = "username";
    public static final String MAX_CHALLENGE_DEFAULT = "3";

    public AdapterConfigurationGuiDescriptor getGuiDescriptor() {
        AdapterConfigurationGuiDescriptor guiDescriptor = new AdapterConfigurationGuiDescriptor();
        TextFieldDescriptor headerField = new TextFieldDescriptor(FIELD_REALM, DESC_REALM);
        headerField.addValidator((FieldValidator)new RequiredFieldValidator());
        guiDescriptor.addField((FieldDescriptor)headerField);
        TableDescriptor pcvTable = new TableDescriptor("Credential Validators", "A list of Password Credential Validators to be used for authentication.");
        guiDescriptor.addTable(pcvTable);
        PasswordCredentialValidatorFieldDescriptor pcvField = new PasswordCredentialValidatorFieldDescriptor("Password Credential Validator Instance", "");
        pcvField.addValidator((FieldValidator)new RequiredFieldValidator());
        pcvTable.addRowField((FieldDescriptor)pcvField);
        TextFieldDescriptor retries = new TextFieldDescriptor(FIELD_RETRIES, DESC_RETRIES);
        retries.addValidator((FieldValidator)new RequiredFieldValidator());
        retries.addValidator((FieldValidator)new IntegerValidator(1, 100));
        retries.setDefaultValue(MAX_CHALLENGE_DEFAULT);
        guiDescriptor.addField((FieldDescriptor)retries);
        guiDescriptor.addValidator(new ConfigurationValidator(){

            public void validate(Configuration configuration) throws ValidationException {
                HashSet<String> pcvs = new HashSet<String>();
                ArrayList<CallSite> errors = new ArrayList<CallSite>();
                Table table = configuration.getTable("Credential Validators");
                List rows = table.getRows();
                if (rows.isEmpty()) {
                    throw new ValidationException("Please add at least one password credential validator.");
                }
                for (Row row : rows) {
                    String pcv = row.getFieldValue("Password Credential Validator Instance");
                    if (pcvs.add(pcv)) continue;
                    errors.add((CallSite)((Object)("Duplicate validator added: " + pcv)));
                }
                if (!errors.isEmpty()) {
                    throw new ValidationException(errors);
                }
            }
        });
        return guiDescriptor;
    }

    public Set<String> createAttributeContract() {
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add(ATTR_NAME_USERID);
        return attrNames;
    }
}

