/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.identifierfirst.config;

import com.pingidentity.adapters.identifierfirst.validators.IdentifierFirstConfigurationValidator;
import java.util.concurrent.TimeUnit;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CaptchaProviderFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class IdentifierFirstConfiguration {
    private static final CookieLifeTimeField COOKIE_LIFE_TIME_FIELD = new CookieLifeTimeField();
    private static final AllowCancelIdentifierSelectionField ENABLE_CANCEL_IDENTIFIER_SELECTION_FIELD = new AllowCancelIdentifierSelectionField();
    private static final TemplateFileField TEMPLATE_FIELD = new TemplateFileField();
    private static final MaximumIdentifierCountField MAXIMUM_IDENTIFIER_COUNT_FIELD = new MaximumIdentifierCountField();
    private static final RiskProviderSelectionField RISK_PROVIDER_SELECTION_FIELD = new RiskProviderSelectionField();
    private static final RiskProviderCheckBox RISK_PROVIDER_CHECK_BOX = new RiskProviderCheckBox();

    public static AdapterConfigurationGuiDescriptor makeAdapterConfigurationGuiDescriptor() {
        AdapterConfigurationGuiDescriptor guiDescriptor = new AdapterConfigurationGuiDescriptor();
        guiDescriptor.addField((FieldDescriptor)COOKIE_LIFE_TIME_FIELD);
        guiDescriptor.addField((FieldDescriptor)ENABLE_CANCEL_IDENTIFIER_SELECTION_FIELD);
        guiDescriptor.addAdvancedField((FieldDescriptor)MAXIMUM_IDENTIFIER_COUNT_FIELD);
        guiDescriptor.addAdvancedField((FieldDescriptor)TEMPLATE_FIELD);
        guiDescriptor.addAdvancedField((FieldDescriptor)RISK_PROVIDER_CHECK_BOX);
        guiDescriptor.addAdvancedField((FieldDescriptor)RISK_PROVIDER_SELECTION_FIELD);
        guiDescriptor.addValidator((ConfigurationValidator)new IdentifierFirstConfigurationValidator());
        return guiDescriptor;
    }

    public static class RiskProviderSelectionField
    extends CaptchaProviderFieldDescriptor {
        private static final String NAME = "Risk Provider";
        private static final String DESCRIPTION = "If Risk Provider is enabled, the provider configured here is used by this instance.";

        private RiskProviderSelectionField() {
            super(NAME, DESCRIPTION);
            this.setDefaultValue(DEFAULT.getValue());
            this.setDefaultForLegacyConfig(DEFAULT.getValue());
        }

        public static String getRiskProvider(Configuration configuration) {
            if (configuration == null) {
                return DEFAULT.getValue();
            }
            String configured = configuration.getFieldValue(NAME);
            return configured == null ? DEFAULT.getValue() : configured;
        }
    }

    public static class RiskProviderCheckBox
    extends CheckBoxFieldDescriptor {
        private static final String NAME = "Enable Risk Provider";
        private static final String DESCRIPTION = "Optionally enable the usage of a Risk Provider service.";

        public RiskProviderCheckBox() {
            super(NAME, DESCRIPTION);
            this.setDefaultValue(false);
            this.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        }

        public static boolean isUseRiskProvider(Configuration configuration) {
            if (configuration == null) {
                return false;
            }
            return configuration.getBooleanFieldValue(NAME);
        }
    }

    public static class MaximumIdentifierCountField
    extends TextFieldDescriptor {
        private static final String NAME = "Maximum Identifiers Count";
        private static final String DESCRIPTION = "Maximum number of recent authentication identifiers to be stored in the cookie. Set to zero to disable the Identifier Cookie.";
        private static final int DEFAULT_VALUE = 5;
        private static final int MIN_VALUE = 0;
        private static final int MAX_VALUE = 10;

        private MaximumIdentifierCountField() {
            super(NAME, DESCRIPTION);
            this.setDefaultValue(String.valueOf(5));
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.addValidator((FieldValidator)new IntegerValidator(0, 10), true);
        }

        public static int getMaximumIdentifierCount(Configuration configuration) {
            if (configuration == null) {
                return 5;
            }
            return configuration.getIntFieldValue(NAME);
        }
    }

    public static class TemplateFileField
    extends TextFieldDescriptor {
        private static final String DEFAULT_VALUE = "identifier.first.template.html";
        private static final String NAME = "Identifier Selection Template";
        private static final String DESCRIPTION = "HTML template (in <pf_home>/server/default/conf/template) rendered to prompt a user for their authentication identifier. The default value is identifier.first.template.html.";

        private TemplateFileField() {
            super(NAME, DESCRIPTION);
            this.setDefaultValue(DEFAULT_VALUE);
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getTemplateFile(Configuration configuration) {
            if (configuration == null) {
                return DEFAULT_VALUE;
            }
            String configured = configuration.getFieldValue(NAME);
            return configured == null ? DEFAULT_VALUE : configured;
        }
    }

    public static class AllowCancelIdentifierSelectionField
    extends CheckBoxFieldDescriptor {
        private static final String NAME = "Allow Cancelling Identifier Selection";
        private static final String DESCRIPTION = "When enabled, the user is allowed to cancel the identifier selection. When selection is cancelled, the authentication result for this adapter will be FAIL.";
        private static final boolean DEFAULT_VALUE = false;

        private AllowCancelIdentifierSelectionField() {
            super(NAME, DESCRIPTION);
            this.setDefaultValue(false);
        }

        public static boolean isCancellingIdentifierSelectionAllowed(Configuration configuration) {
            if (configuration == null) {
                return false;
            }
            return configuration.getBooleanFieldValue(NAME);
        }
    }

    public static class CookieLifeTimeField
    extends TextFieldDescriptor {
        private static final String NAME = "Identifier Cookie Lifetime";
        private static final String DESCRIPTION = "Identifier Cookie Lifetime (in days). Set to zero to disable the Identifier Cookie.";
        private static final int DEFAULT_VALUE = 30;
        private static final int MIN_VALUE = 0;
        private static final int MAX_VALUE = 3650;

        private CookieLifeTimeField() {
            super(NAME, DESCRIPTION);
            this.setDefaultValue(String.valueOf(30));
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.addValidator((FieldValidator)new IntegerValidator(0, 3650), true);
        }

        public static int getConfiguredCookieLifeTimeInSecond(Configuration configuration) {
            if (configuration == null) {
                return 30;
            }
            return (int)TimeUnit.DAYS.toSeconds(configuration.getIntFieldValue(NAME));
        }
    }
}

