/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.identifierfirst.utils;

import com.pingidentity.adapters.identifierfirst.config.IdentifierFirstConfiguration;
import com.pingidentity.adapters.identifierfirst.utils.PFField;
import com.pingidentity.common.util.CookieMonster;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.model.action.SubmitIdentifier;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.conf.Configuration;

public class IdentifierFirstHelper {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[^@]+@[^@]+\\.[a-zA-Z]+$");
    private static final ParamMapping<SubmitIdentifier, String> USER_IDENTIFIER_MAPPING = new ParamMapping(PFField.SUBJECT.getKey(), SubmitIdentifier.class, SubmitIdentifier::getIdentifier, Function.identity());
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig((String)"com.pingidentity.adapters.identifierfirst.idp.IdentifierFirstAdapter");

    public static String getPreviouslySelectedIdentifierToBeCleared(HttpServletRequest request) {
        String param = request.getParameter(PFField.CLEAR_PREVIOUS_SELECTED_SUBJECT.getKey());
        return param == null ? "" : param;
    }

    public static boolean isCancelIdentifierSelection(HttpServletRequest request) {
        return request.getParameter(PFField.CANCEL_IDENTIFIER_SELECTION.getKey()) != null && Boolean.valueOf(request.getParameter(PFField.CANCEL_IDENTIFIER_SELECTION.getKey())) != false || CommonActionSpec.CANCEL_IDENTIFIER_SUBMISSION.isRequested(request);
    }

    public static boolean isClearPreviouslySelectedIdentifier(HttpServletRequest request) {
        return CommonActionSpec.CLEAR_IDENTIFIER.isRequested(request) || StringUtils.isNotBlank((String)request.getParameter(PFField.CLEAR_PREVIOUS_SELECTED_SUBJECT.getKey()));
    }

    public static LinkedHashSet<String> getExistingIdentifiers(HttpServletRequest request, Configuration configuration, boolean decoded) {
        String adapterInstanceId = configuration.getId();
        int mostRecentCount = IdentifierFirstConfiguration.MaximumIdentifierCountField.getMaximumIdentifierCount(configuration);
        LinkedHashSet<String> existingIdentifiersSet = new LinkedHashSet<String>();
        String cookieValue = CookieMonster.getCookieValue((String)IdentifierFirstHelper.getIdentifierFirstAdapterCookieKey(adapterInstanceId), (HttpServletRequest)request);
        if (cookieValue != null) {
            if (IdentifierFirstHelper.isUrlEncoded(cookieValue)) {
                cookieValue = URLDecoder.decode(cookieValue, StandardCharsets.UTF_8);
            }
            existingIdentifiersSet.addAll(Arrays.stream(cookieValue.split(",")).filter(StringUtils::isNotBlank).map(identifier -> decoded ? new String(Base64.getDecoder().decode(identifier.getBytes())) : identifier).limit(mostRecentCount).collect(Collectors.toList()));
        }
        return existingIdentifiersSet;
    }

    private static boolean isUrlEncoded(String input) {
        String decoded = URLDecoder.decode(input, StandardCharsets.UTF_8);
        return !input.equals(decoded);
    }

    public static String getIdentifier(HttpServletRequest request, Map<String, Object> inParameters) throws IOException {
        String identifier = (String)USER_IDENTIFIER_MAPPING.getValue(request);
        if (identifier == null) {
            identifier = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        }
        return identifier;
    }

    public static String getDomainFromIdentifier(String identifier) {
        return EMAIL_PATTERN.matcher(identifier).matches() ? identifier.substring(identifier.indexOf("@") + 1) : "";
    }

    public static List<String> getRecentlySelectedIdentifiers(HttpServletRequest request, Map<String, Object> authnIdentifiersMap, Configuration configuration, boolean decoded) {
        int mostRecentCount = IdentifierFirstConfiguration.MaximumIdentifierCountField.getMaximumIdentifierCount(configuration);
        ArrayList<String> mostRecentlySelected = new ArrayList<String>();
        LinkedHashSet<String> existingIdentifierSet = IdentifierFirstHelper.getExistingIdentifiers(request, configuration, decoded);
        String selectedIdentifier = (String)authnIdentifiersMap.get(PFField.SUBJECT.getKey());
        if (StringUtils.isNotBlank((String)selectedIdentifier)) {
            String encodedSelectedIdentifier = new String(Base64.getEncoder().encode(selectedIdentifier.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            existingIdentifierSet.remove(encodedSelectedIdentifier);
            mostRecentlySelected.add(encodedSelectedIdentifier);
            --mostRecentCount;
        }
        for (String previouslySelected : existingIdentifierSet) {
            if (mostRecentCount <= 0) continue;
            mostRecentlySelected.add(previouslySelected);
            --mostRecentCount;
        }
        return mostRecentlySelected;
    }

    public static String getIdentifierFirstAdapterCookieKey(String instanceId) {
        return instanceId + "." + PFField.PREVIOUS_SUBJECTS.getKey();
    }

    public static Cookie createIdentifierCookie(List<String> identifiers, Configuration configuration) {
        String recentIdentifiers = String.join((CharSequence)",", identifiers);
        if (!configStore.getBooleanValue("UseCommasAsDelimiter", false)) {
            recentIdentifiers = URLEncoder.encode(recentIdentifiers, StandardCharsets.UTF_8);
        }
        Cookie cookie = new Cookie(IdentifierFirstHelper.getIdentifierFirstAdapterCookieKey(configuration.getId()), recentIdentifiers);
        cookie.setPath("/");
        cookie.setMaxAge(IdentifierFirstConfiguration.CookieLifeTimeField.getConfiguredCookieLifeTimeInSecond(configuration));
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        return cookie;
    }
}

