/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.identifierfirst.validators;

import com.pingidentity.adapters.identifierfirst.config.IdentifierFirstConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.CaptchaProviderInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdentifierFirstConfigurationValidator
implements ConfigurationValidator {
    public void validate(Configuration configuration) throws ValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        this.validateCaptchaEnabledActions(configuration, errors);
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    private void validateCaptchaEnabledActions(Configuration configuration, List<String> errors) {
        if (IdentifierFirstConfiguration.RiskProviderCheckBox.isUseRiskProvider(configuration)) {
            CaptchaProviderInstance captchaProviderInstance = (CaptchaProviderInstance)MgmtFactory.getCaptchaProviderPluginManager().getDefaultInstance();
            String riskProviderId = IdentifierFirstConfiguration.RiskProviderSelectionField.getRiskProvider(configuration);
            if (StringUtils.isBlank((String)riskProviderId) && captchaProviderInstance == null) {
                errors.add("A Risk provider must be selected or a default Risk provider must be defined if Risk is enabled for any action.");
            }
        }
    }
}

