/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.kerberos.idp;

import com.pingidentity.access.KerberosRealmAccessor;
import com.pingidentity.adapters.kerberos.exception.KerberosException;
import com.pingidentity.adapters.kerberos.idp.KerberosSubject;
import com.pingidentity.adapters.kerberos.idp.SpnegoParser;
import com.pingidentity.common.util.KerberosResult;
import com.pingidentity.common.util.KerberosUtil;
import com.pingidentity.common.util.KerberosUtilFactory;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.domain.KerberosRealm;

public class KerberosValidator {
    private static final Logger log = LogManager.getLogger(KerberosValidator.class);
    private String kerberosRealmId = null;
    private static final Object locker = new Object();

    public void setKerberosRealmId(String kerberosRealmId) {
        this.kerberosRealmId = kerberosRealmId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KerberosSubject validateTGS(byte[] tgs) throws KerberosException {
        SpnegoParser spnegoParser = new SpnegoParser();
        String userNameWithDomain = null;
        String domainName = null;
        HashSet<String> sids = new HashSet();
        try {
            String objectSid;
            spnegoParser.parse(tgs);
            byte[] token = spnegoParser.getMechanismToken();
            KerberosRealmAccessor kerberosRealmAccessor = new KerberosRealmAccessor();
            KerberosRealm kerberosRealm = kerberosRealmAccessor.getKerberosRealm(this.kerberosRealmId);
            try (TimerScope ignored = Meters.getTimerScope((String)"kerberos.kdc.request", (String[])new String[]{"kerberos.realm", kerberosRealm.getKerberosRealmName()});){
                Object object = locker;
                synchronized (object) {
                    KerberosUtil kerberosUtil = KerberosUtilFactory.getKerberosUtil((KerberosRealm)kerberosRealm);
                    KerberosResult kerberosResult = kerberosUtil.validateTicketAndExtractSids(token);
                    userNameWithDomain = kerberosResult.getPrincipal();
                    objectSid = kerberosResult.getObjectSid();
                    if (kerberosResult.getSids() != null) {
                        sids = kerberosResult.getSids();
                    }
                }
            }
            catch (com.pingidentity.common.security.KerberosException e) {
                if (kerberosRealm.isDirectConnection()) {
                    String message = String.format("Unable to login to KDC, Domain/Realm=%s Username=%s", kerberosRealm.getKerberosRealmName(), kerberosRealm.getKerberosUsername());
                    log.debug(message, (Throwable)e);
                    log.error("{}: {}", (Object)message, (Object)e.getMessage());
                } else if (kerberosRealm.isLdapGatewayConnection()) {
                    String message = String.format("Unable to login to KDC, Domain/Realm=%s Ldap Gateway=%s", kerberosRealm.getKerberosRealmName(), kerberosRealm.getLdapGatewayDatastoreId());
                    log.debug(message, (Throwable)e);
                    log.error("{}: {}", (Object)message, (Object)e.getMessage());
                }
                throw new KerberosException(e, true, false);
            }
            String userName = userNameWithDomain;
            log.debug("userNameWithDomain retrieved successfully.");
            if (userNameWithDomain != null) {
                int idx = userNameWithDomain.lastIndexOf("@");
                if (idx != -1) {
                    while (userNameWithDomain.lastIndexOf("\\", idx) == idx - 1) {
                        idx = userNameWithDomain.lastIndexOf("@", idx - 1);
                    }
                    if (idx != -1) {
                        userName = userNameWithDomain.substring(0, idx);
                        domainName = this.removePrincipleNameEscapes(userNameWithDomain.substring(idx + 1));
                        if (StringUtils.isNotEmpty((String)domainName) && !domainName.equalsIgnoreCase(kerberosRealm.getKerberosRealmName()) && kerberosRealm.isDirectConnection()) {
                            if (kerberosRealmAccessor.getKerberosRealmByName(domainName) != null) {
                                throw new KerberosException("A Domain/Realm mismatch occurred, ensure you're using the correct adapter instance", false, false);
                            }
                            log.debug("Using inter-domain trust relationship for Domain/Realm: {}", (Object)domainName);
                        }
                    }
                }
                userName = this.removePrincipleNameEscapes(userName);
            }
            log.debug("KerberosSubject created successfully.");
            return new KerberosSubject(userName, domainName, objectSid, sids);
        }
        catch (IOException e) {
            throw new KerberosException(e, true, false);
        }
        catch (IndexOutOfBoundsException e) {
            log.error("IndexException: Unable to retrieve UserName/Domain from userId={}", userNameWithDomain);
            throw new KerberosException(e, true, false);
        }
    }

    public String removePrincipleNameEscapes(String username) {
        username = username.replace("\\@", "@").replace("\\/", "/").replace("\\\\", "\\");
        return username;
    }
}

