/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.captcha.recaptchaEnterprise;

import com.pingidentity.captcha.CaptchaServerSideRequestHelper;
import com.pingidentity.captcha.ReCaptchaPlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProviderDescriptor;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.DoubleValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.util.log.AttributeMap;

public class ReCaptchaEnterprisePlugin
extends ReCaptchaPlugin {
    public static final String TYPE = "reCAPTCHA Enterprise";
    private static final String DESCRIPTION = "Configure the server to use reCAPTCHA Enterprise.";
    private static final String PROJECT_ID_NAME = "Project ID";
    private static final String PROJECT_ID_DESC = "The project ID assigned to your account by Google.";
    private static final String API_KEY_SECRET_NAME = "API Key Secret";
    private static final String API_KEY_SECRET_DESC = "The API Key Secret assigned to your account by Google for communication between PingFederate and reCAPTCHA.";
    private static final String DEFAULT_JAVASCRIPT_FILENAME = "recaptcha-enterprise.js";
    private static final String JAVASCRIPT_FILE_NAME_DESC = "The JavaScript file name to be loaded for reCAPTCHA Enterprise. The default value is: recaptcha-enterprise.js";
    private static final String FAILURE_MODE_NAME = "Failure Mode";
    private static final String FAILURE_MODE_DESC = "When ReCAPTCHA Enterprise is unavailable or an error occurs, this setting determines whether the user's sign-on attempt should fail or continue with a pre-determined policy decision.";
    private static final String FAILURE_MODE_CONTINUE = "Continue with fallback policy decision";
    private static final String FAILURE_MODE_FAIL = "Fail";
    private static final String FALLBACK_POLICY_DECISION_DEFAULT_VALUE = "0.1";
    private static final String FALLBACK_POLICY_DECISION_NAME = "Fallback Policy Decision Value";
    private static final String FALLBACK_POLICY_DECISION_DESC = "The score result (for example, 0.0 - 1.0) to use in the authentication policy when the ReCAPTCHA Enterprise service is unavailable or an error occurs, and 'Failure Mode' is set to 'Continue with fallback policy decision'. If no value is provided, the default value is 0.1.";
    private static final String CAPTCHA_REASONS_CONTRACT_ATTRIBUTE = "captchaReasons";
    private static final String VALID_STATUS_RESPONSE = "valid";
    private static final String INVALID_REASON_RESPONSE = "invalidReason";
    private static final String EXPECTED_ACTION_RESPONSE = "expectedAction";
    private static final String REASONS_RESPONSE = "reasons";
    private static final String CREATE_TIME_TS_RESPONSE = "createTime";
    private static final String RISK_ANALYSIS_RESPONSE = "riskAnalysis";
    private static final String EVENT_RESPONSE = "event";
    private static final String TOKEN_PROPERTIES_RESPONSE = "tokenProperties";
    private static final String FAILURE_MODE = "failureMode";
    private final Log log = LogFactory.getLog(this.getClass());
    private final PluginDescriptor pluginDescriptor;
    private Configuration configuration;

    public ReCaptchaEnterprisePlugin() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor(DESCRIPTION);
        TextFieldDescriptor projectId = new TextFieldDescriptor(PROJECT_ID_NAME, PROJECT_ID_DESC);
        projectId.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)projectId);
        TextFieldDescriptor siteKey = new TextFieldDescriptor("Site Key", "The site key assigned to your account by Google.");
        siteKey.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)siteKey);
        TextFieldDescriptor apiKey = new TextFieldDescriptor(API_KEY_SECRET_NAME, API_KEY_SECRET_DESC, true);
        apiKey.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)apiKey);
        TextFieldDescriptor scoreThresholdToPass = new TextFieldDescriptor("Pass Score Threshold", "The minimum score that is returned by Google for the request to be valid. The score range returned is between 0.0 - 1.0, where 1.0 is likely a good interaction.");
        scoreThresholdToPass.addValidator((FieldValidator)new RequiredFieldValidator());
        scoreThresholdToPass.addValidator((FieldValidator)new DoubleValidator(0.0, 1.0));
        guiConfigDescriptor.addField((FieldDescriptor)scoreThresholdToPass);
        String[] options = new String[]{FAILURE_MODE_CONTINUE, FAILURE_MODE_FAIL};
        RadioGroupFieldDescriptor failureMode = new RadioGroupFieldDescriptor(FAILURE_MODE_NAME, FAILURE_MODE_DESC, options);
        failureMode.setDefaultValue(FAILURE_MODE_FAIL);
        guiConfigDescriptor.addField((FieldDescriptor)failureMode);
        TextFieldDescriptor fallbackPolicyDecision = new TextFieldDescriptor(FALLBACK_POLICY_DECISION_NAME, FALLBACK_POLICY_DECISION_DESC);
        guiConfigDescriptor.addField((FieldDescriptor)fallbackPolicyDecision);
        TextFieldDescriptor javaScriptFileName = new TextFieldDescriptor("JavaScript File Name", JAVASCRIPT_FILE_NAME_DESC);
        javaScriptFileName.setDefaultValue(DEFAULT_JAVASCRIPT_FILENAME);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)javaScriptFileName);
        HashSet<String> attributeContract = new HashSet<String>(Arrays.asList("captchaScore", "captchaChallengeTime", CAPTCHA_REASONS_CONTRACT_ATTRIBUTE));
        this.pluginDescriptor = new CaptchaProviderDescriptor(TYPE, (Plugin)this, attributeContract, guiConfigDescriptor, VersionUtil.getVersion());
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getJavaScriptFileName() {
        return StringUtils.defaultIfEmpty((String)this.configuration.getFieldValue("JavaScript File Name"), (String)DEFAULT_JAVASCRIPT_FILENAME);
    }

    @Override
    public Map<String, Object> getCaptchaAttributes(CaptchaContext captchaContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("siteKey", this.configuration.getFieldValue("Site Key"));
        attributes.put("action", this.getAction(captchaContext.getAction()));
        return attributes;
    }

    @Override
    public CaptchaResult validateCaptcha(CaptchaContext captchaContext) {
        String captchaResponse = this.getCaptchaResponse(captchaContext);
        if (StringUtils.isBlank((String)captchaResponse)) {
            this.log.debug((Object)"No CAPTCHA response returned.");
            return CaptchaResult.createInvalidResult(null);
        }
        try {
            CaptchaServerSideRequestHelper captchaServerSideRequestHelper = new CaptchaServerSideRequestHelper(captchaResponse, this.configuration.getFieldValue(API_KEY_SECRET_NAME));
            String fallbackPolicyDecisionValue = StringUtils.isNotBlank((String)this.configuration.getFieldValue(FALLBACK_POLICY_DECISION_NAME)) ? this.configuration.getFieldValue(FALLBACK_POLICY_DECISION_NAME) : FALLBACK_POLICY_DECISION_DEFAULT_VALUE;
            Map response = captchaServerSideRequestHelper.makeEnterpriseValidationRequest(this.configuration.getFieldValue(PROJECT_ID_NAME), captchaResponse, this.configuration.getFieldValue("Site Key"), captchaContext.getRequest().getHeader("User-Agent"), captchaContext.getRequest().getRemoteAddr(), this.getAction(captchaContext.getAction()), this.configuration.getFieldValue(FAILURE_MODE_NAME).equals(FAILURE_MODE_CONTINUE), fallbackPolicyDecisionValue);
            if (response == null) {
                return CaptchaResult.createInvalidResult(null);
            }
            if (response.containsKey(FAILURE_MODE)) {
                if (response.get(FAILURE_MODE).equals(FAILURE_MODE_CONTINUE)) {
                    AttributeMap captchaResult = new AttributeMap();
                    captchaResult.put("captchaScore", AttrValueSupport.make(response.get("score")));
                    captchaResult.put(CAPTCHA_REASONS_CONTRACT_ATTRIBUTE, AttrValueSupport.make((Object)"CONTINUE_WITH_FALLBACK_POLICY_DECISION"));
                    captchaResult.put("captchaChallengeTime", AttrValueSupport.make((Object)System.currentTimeMillis()));
                    return CaptchaResult.createValidResult((AttributeMap)captchaResult);
                }
                return CaptchaResult.createInvalidResult(null);
            }
            AttributeMap captchaResult = new AttributeMap();
            Map<String, Object> eventMap = this.getMapFromResponse(response, EVENT_RESPONSE);
            if (eventMap == null) {
                return CaptchaResult.createInvalidResult(null);
            }
            Map<String, Object> riskAnalysisMap = this.getMapFromResponse(response, RISK_ANALYSIS_RESPONSE);
            if (riskAnalysisMap == null) {
                return CaptchaResult.createInvalidResult(null);
            }
            captchaResult.put("captchaScore", AttrValueSupport.make((Object)riskAnalysisMap.get("score")));
            captchaResult.put(CAPTCHA_REASONS_CONTRACT_ATTRIBUTE, AttrValueSupport.make((Object)riskAnalysisMap.get(REASONS_RESPONSE)));
            Map<String, Object> tokenPropertiesMap = this.getMapFromResponse(response, TOKEN_PROPERTIES_RESPONSE);
            if (tokenPropertiesMap == null) {
                return CaptchaResult.createInvalidResult(null);
            }
            captchaResult.put("captchaChallengeTime", AttrValueSupport.make((Object)tokenPropertiesMap.get(CREATE_TIME_TS_RESPONSE)));
            boolean success = false;
            if (Boolean.TRUE.equals(tokenPropertiesMap.get(VALID_STATUS_RESPONSE))) {
                if (riskAnalysisMap.get("score") != null && this.getScoreFromResponse(riskAnalysisMap) >= this.configuration.getDoubleFieldValue("Pass Score Threshold")) {
                    if (StringUtils.equals((String)((String)eventMap.get(EXPECTED_ACTION_RESPONSE)), (String)((String)tokenPropertiesMap.get("action")))) {
                        success = true;
                    } else {
                        this.log.info((Object)("The expectedAction:" + eventMap.get(EXPECTED_ACTION_RESPONSE) + " does not match the action:" + tokenPropertiesMap.get("action") + "."));
                    }
                } else {
                    this.log.info((Object)"The CAPTCHA score did not meet the minimum Pass Score Threshold.");
                }
            } else {
                this.log.info((Object)("The provided CAPTCHA user response token is invalid due to invalidReason:" + tokenPropertiesMap.get(INVALID_REASON_RESPONSE) + ". It can also indicate that a user has failed to solve a challenge or there is a siteKey mismatch."));
            }
            if (!success) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("reCAPTCHA response: " + response));
                }
                return CaptchaResult.createInvalidResult((AttributeMap)captchaResult);
            }
            return CaptchaResult.createValidResult((AttributeMap)captchaResult);
        }
        catch (IOException e) {
            this.log.debug((Object)"Error validating CAPTCHA", (Throwable)e);
            return CaptchaResult.createInvalidResult(null);
        }
    }

    private Map<String, Object> getMapFromResponse(Map<String, Object> response, String key) {
        Object object = response.get(key);
        if (object instanceof Map) {
            return (Map)object;
        }
        this.log.debug((Object)("Invalid CAPTCHA response. Missing " + key + " field."));
        return null;
    }

    private double getScoreFromResponse(Map<String, Object> response) {
        Object score = response.get("score");
        if (score instanceof Double) {
            return (Double)score;
        }
        if (score instanceof Integer) {
            return ((Integer)score).doubleValue();
        }
        this.log.debug((Object)"CAPTCHA response score is not an instance of Double or Integer.");
        return 0.0;
    }
}

