/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.captcha.recaptchaV3;

import com.pingidentity.captcha.CaptchaServerSideRequestHelper;
import com.pingidentity.captcha.ReCaptchaPlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProviderDescriptor;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.DoubleValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.util.log.AttributeMap;

public class ReCaptchaV3Plugin
extends ReCaptchaPlugin {
    public static final String TYPE = "reCAPTCHA v3";
    private static final String DESCRIPTION = "Configure the server to use reCAPTCHA v3.";
    private static final String SECRET_KEY_NAME = "Secret Key";
    private static final String SECRET_KEY_DESC = "The secret key assigned to your account by Google for communication between PingFederate and reCAPTCHA.";
    private static final String DEFAULT_JAVASCRIPT_FILENAME = "recaptcha-v3.js";
    private static final String JAVASCRIPT_FILE_NAME_DESC = "The JavaScript file name to be loaded for reCAPTCHA. The default value is: recaptcha-v3.js";
    private static final String SUCCESS_STATUS_RESPONSE = "success";
    private static final String CHALLENGE_TS_RESPONSE = "challenge_ts";
    private final Log log = LogFactory.getLog(this.getClass());
    private final PluginDescriptor pluginDescriptor;
    private Configuration configuration;

    public ReCaptchaV3Plugin() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor(DESCRIPTION);
        TextFieldDescriptor siteKey = new TextFieldDescriptor("Site Key", "The site key assigned to your account by Google.");
        siteKey.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)siteKey);
        TextFieldDescriptor secretKey = new TextFieldDescriptor(SECRET_KEY_NAME, SECRET_KEY_DESC, true);
        secretKey.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)secretKey);
        TextFieldDescriptor scoreThresholdToPass = new TextFieldDescriptor("Pass Score Threshold", "The minimum score that is returned by Google for the request to be valid. The score range returned is between 0.0 - 1.0, where 1.0 is likely a good interaction.");
        scoreThresholdToPass.addValidator((FieldValidator)new RequiredFieldValidator());
        scoreThresholdToPass.addValidator((FieldValidator)new DoubleValidator(0.0, 1.0));
        guiConfigDescriptor.addField((FieldDescriptor)scoreThresholdToPass);
        TextFieldDescriptor javaScriptFileName = new TextFieldDescriptor("JavaScript File Name", JAVASCRIPT_FILE_NAME_DESC);
        javaScriptFileName.setDefaultValue(DEFAULT_JAVASCRIPT_FILENAME);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)javaScriptFileName);
        HashSet<String> attributeContract = new HashSet<String>(Arrays.asList("captchaScore", "captchaChallengeTime"));
        this.pluginDescriptor = new CaptchaProviderDescriptor(TYPE, (Plugin)this, attributeContract, guiConfigDescriptor, VersionUtil.getVersion());
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getJavaScriptFileName() {
        return StringUtils.defaultIfEmpty((String)this.configuration.getFieldValue("JavaScript File Name"), (String)DEFAULT_JAVASCRIPT_FILENAME);
    }

    @Override
    public Map<String, Object> getCaptchaAttributes(CaptchaContext captchaContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("siteKey", this.configuration.getFieldValue("Site Key"));
        attributes.put("action", this.getAction(captchaContext.getAction()));
        return attributes;
    }

    @Override
    public CaptchaResult validateCaptcha(CaptchaContext captchaContext) {
        String captchaResponse = this.getCaptchaResponse(captchaContext);
        if (StringUtils.isBlank((String)captchaResponse)) {
            this.log.debug((Object)"No CAPTCHA response returned.");
            return CaptchaResult.createInvalidResult(null);
        }
        try {
            CaptchaServerSideRequestHelper captchaServerSideRequestHelper = new CaptchaServerSideRequestHelper(captchaResponse, this.configuration.getFieldValue(SECRET_KEY_NAME));
            Map response = captchaServerSideRequestHelper.makeValidationRequest();
            AttributeMap captchaResult = new AttributeMap();
            captchaResult.put("captchaScore", AttrValueSupport.make(response.get("score")));
            captchaResult.put("captchaChallengeTime", AttrValueSupport.make(response.get(CHALLENGE_TS_RESPONSE)));
            boolean success = false;
            if (Boolean.TRUE.equals(response.get(SUCCESS_STATUS_RESPONSE))) {
                if (response.get("score") != null && (Double)response.get("score") >= this.configuration.getDoubleFieldValue("Pass Score Threshold")) {
                    if (StringUtils.equals((String)((String)response.get("action")), (String)this.getAction(captchaContext.getAction()))) {
                        success = true;
                    } else {
                        this.log.info((Object)("The action of the request:" + this.getAction(captchaContext.getAction()) + " does not match the action:" + response.get("action") + "."));
                    }
                } else {
                    this.log.info((Object)"The CAPTCHA score did not meet the minimum Pass Score Threshold.");
                }
            } else {
                this.log.info((Object)("The provided CAPTCHA success response is " + response.get(SUCCESS_STATUS_RESPONSE) + "."));
            }
            if (!success) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("reCAPTCHA response: " + response));
                }
                return CaptchaResult.createInvalidResult((AttributeMap)captchaResult);
            }
            return CaptchaResult.createValidResult((AttributeMap)captchaResult);
        }
        catch (IOException e) {
            this.log.debug((Object)"Error validating captcha", (Throwable)e);
            return CaptchaResult.createInvalidResult(null);
        }
    }
}

