/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.access.token.management.plugins;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.PkCert;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.DsigKeypairFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CertificateSupport {
    static final int MIN_RSA_KEY_LENGTH = 2048;
    private final Log log = LogFactory.getLog(this.getClass());

    boolean meetsCriteria(X500PrivateCredential x500PrivateCredential) {
        PublicKey pubKey = x500PrivateCredential.getCertificate().getPublicKey();
        return pubKey instanceof ECPublicKey || pubKey instanceof RSAPublicKey && ((RSAPublicKey)pubKey).getModulus().bitLength() >= 2048;
    }

    private List<AbstractSelectionFieldDescriptor.OptionValue> getOptions() {
        LinkedList<AbstractSelectionFieldDescriptor.OptionValue> options = new LinkedList<AbstractSelectionFieldDescriptor.OptionValue>();
        options.add(SelectFieldDescriptor.SELECT_ONE);
        for (X500PrivateCredential x5 : this.getAvailableCredentials()) {
            Cert cert = new Cert(x5.getAlias(), x5.getCertificate());
            String name = cert.getDescriptionForDisplay(35);
            String value = cert.getAlias();
            AbstractSelectionFieldDescriptor.OptionValue op = new AbstractSelectionFieldDescriptor.OptionValue(name, value);
            options.add(op);
        }
        return options;
    }

    public SelectFieldDescriptor getCertsDesc(String name, String desc) {
        return new FilteredKeypairFieldDescriptor(name, desc);
    }

    Collection<X500PrivateCredential> getAvailableCredentials() {
        ArrayList<X500PrivateCredential> credentials = new ArrayList<X500PrivateCredential>();
        for (X500PrivateCredential cred : this.getAllCredentials()) {
            if (!this.meetsCriteria(cred)) continue;
            credentials.add(cred);
        }
        return credentials;
    }

    Collection<X500PrivateCredential> getAllCredentials() {
        ArrayList<X500PrivateCredential> credentials = new ArrayList<X500PrivateCredential>();
        for (PkCert pkCert : MgmtFactory.getDsigPkCertManager().getPkCerts()) {
            credentials.add(this.makeX500PrivateCredential(pkCert));
        }
        return credentials;
    }

    public X500PrivateCredential getDsigKeypair(String alias) {
        PkCert pkCert = MgmtFactory.getDsigPkCertManager().getPkCert(alias);
        if (pkCert == null) {
            return null;
        }
        return new X500PrivateCredential(pkCert.getX509Certificate(), pkCert.getPrivateKey(), pkCert.getAlias());
    }

    public void gatherCerts(Configuration configuration, Map<String, X509Certificate> kidToCertMap, Map<String, X509Certificate> thumbToCertMap, Map<String, X500PrivateCredential> signingKeysMap) {
        Table certs = configuration.getTable("Certificates");
        List rows = certs.getRows();
        for (Row row : rows) {
            String kid = row.getFieldValue("Key ID");
            String alias = row.getFieldValue("Certificate");
            X500PrivateCredential x500 = this.getDsigKeypair(alias);
            if (x500 != null) {
                signingKeysMap.put(kid, x500);
                X509Certificate x509Certificate = x500.getCertificate();
                String thumb = CertificateHelper.calculateThumb((X509Certificate)x509Certificate);
                thumbToCertMap.put(thumb, x509Certificate);
                kidToCertMap.put(kid, x509Certificate);
                continue;
            }
            this.log.warn((Object)("Unable to find certificate and keypair for alias " + alias));
        }
    }

    public void gatherKidCerts(Configuration configuration, Map<String, X509Certificate> kidToCertMap) {
        Table certs = configuration.getTable("Certificates");
        List rows = certs.getRows();
        for (Row row : rows) {
            String kid = row.getFieldValue("Key ID");
            String alias = row.getFieldValue("Certificate");
            X500PrivateCredential x500 = this.getDsigKeypair(alias);
            if (x500 != null) {
                X509Certificate x509Certificate = x500.getCertificate();
                kidToCertMap.put(kid, x509Certificate);
                continue;
            }
            this.log.warn((Object)("Unable to find certificate and keypair for alias " + alias));
        }
    }

    private X500PrivateCredential makeX500PrivateCredential(PkCert pkCert) {
        return new X500PrivateCredential(pkCert.getX509Certificate(), pkCert.getPrivateKey(), pkCert.getAlias());
    }

    class FilteredKeypairFieldDescriptor
    extends DsigKeypairFieldDescriptor {
        public FilteredKeypairFieldDescriptor(String name, String description) {
            super(name, description);
        }

        public List<AbstractSelectionFieldDescriptor.OptionValue> getOptionValues() {
            return CertificateSupport.this.getOptions();
        }
    }
}

