/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.access.token.management.plugins;

import com.pingidentity.pf.access.token.management.plugins.CertificateSupport;
import com.pingidentity.pf.access.token.management.plugins.JwtBearerAccessTokenManagementPlugin;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class JwtAtmCertMaps {
    private static final Log log = LogFactory.getLog(JwtAtmCertMaps.class);
    private final CertificateSupport certSupport = new CertificateSupport();
    private final Map<String, X509Certificate> kidToCertMap;
    private final Map<String, X509Certificate> x5tToCertMap;

    public JwtAtmCertMaps() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating certificate maps for endpoints");
        }
        this.kidToCertMap = new HashMap<String, X509Certificate>();
        this.x5tToCertMap = new HashMap<String, X509Certificate>();
        for (BearerAccessTokenMgmtPluginInstance instance : MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances()) {
            if (!this.isJwtAtmPluginInstance(instance)) continue;
            this.checkPublishCerts(instance.getRuntimeCompositeConfiguration(), this.kidToCertMap, this.x5tToCertMap);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished creating certificate maps for endpoints, publishing " + this.kidToCertMap.size() + " certs by kid and " + this.x5tToCertMap.size() + " certs by thumbprint"));
        }
    }

    public Map<String, X509Certificate> getKidToCertMap() {
        return this.kidToCertMap;
    }

    public Map<String, X509Certificate> getX5tToCertMap() {
        return this.x5tToCertMap;
    }

    private boolean isJwtAtmPluginInstance(BearerAccessTokenMgmtPluginInstance instance) {
        String className = instance.getDescriptor().getPluginClassName();
        return StringUtils.equals((String)className, (String)JwtBearerAccessTokenManagementPlugin.class.getName());
    }

    private void checkPublishCerts(Configuration configuration, Map<String, X509Certificate> publishKidToCertMap, Map<String, X509Certificate> publishThumbToCertMap) {
        boolean registerKid = configuration.getBooleanFieldValue("Publish Key ID X.509 URL");
        boolean registerThumb = configuration.getBooleanFieldValue("Publish Thumbprint X.509 URL");
        HashMap<String, X509Certificate> tempKidToCertMap = new HashMap<String, X509Certificate>();
        HashMap<String, X509Certificate> tempX5tToCertMap = new HashMap<String, X509Certificate>();
        HashMap<String, X500PrivateCredential> tempSigningKeysMap = new HashMap<String, X500PrivateCredential>();
        if (registerKid || registerThumb) {
            this.certSupport.gatherCerts(configuration, tempKidToCertMap, tempX5tToCertMap, tempSigningKeysMap);
        }
        if (registerKid) {
            for (Map.Entry entry : tempKidToCertMap.entrySet()) {
                if (publishKidToCertMap.containsKey(entry.getKey()) && !((X509Certificate)entry.getValue()).equals(publishKidToCertMap.get(entry.getKey()))) {
                    log.error((Object)("Different certificates are published with the same key ID '" + (String)entry.getKey() + "', please ensure instances of the JSON Web Tokens access token manager use distinct IDs for their certificates"));
                    continue;
                }
                publishKidToCertMap.put((String)entry.getKey(), (X509Certificate)entry.getValue());
            }
        }
        if (registerThumb) {
            publishThumbToCertMap.putAll(tempX5tToCertMap);
        }
    }
}

