/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.access.token.management.plugins;

import com.pingidentity.common.util.Base64URL;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class SymmetricKeySupport
implements RowValidator {
    private static final Log log = LogFactory.getLog(SymmetricKeySupport.class);
    static final int MIN_LENGTH = 16;

    public void validate(FieldList fieldsInRow) throws ValidationException {
        SymmetricKeySupport.getKeyChecked(fieldsInRow);
    }

    static Key getKey(FieldList fieldsInRow) {
        try {
            return SymmetricKeySupport.getKeyChecked(fieldsInRow);
        }
        catch (ValidationException e) {
            log.error((Object)"Unable to decode symmetric key.", (Throwable)e);
            return null;
        }
    }

    static Key getKeyChecked(FieldList fieldsInRow) throws ValidationException {
        byte[] rawKeyValue;
        String encoding = fieldsInRow.getFieldValue("Encoding");
        String kid = fieldsInRow.getFieldValue("Key ID");
        String keyName = "Key";
        String encodedKeyValue = fieldsInRow.getFieldValue(keyName);
        if ("".equals(encoding) || StringUtils.isBlank((String)encoding)) {
            try {
                rawKeyValue = Hex.decodeHex((char[])encodedKeyValue.toCharArray());
            }
            catch (DecoderException e) {
                String errorMessage = keyName + " with key id '" + kid + "' is not valid hex: " + e.getMessage();
                if (!errorMessage.endsWith(".")) {
                    errorMessage = errorMessage + ".";
                }
                throw new ValidationException(errorMessage);
            }
        } else if ("b64u".equals(encoding)) {
            rawKeyValue = Base64URL.decode((String)encodedKeyValue);
        } else {
            throw new ValidationException("Unrecognized encoding for symmetric key: " + encoding);
        }
        if (rawKeyValue.length < 16) {
            throw new ValidationException(keyName + " with key id '" + kid + "' is " + rawKeyValue.length * 8 + " bits but needs to be" + SymmetricKeySupport.getAtLeastBitsMessagePart(128) + ".");
        }
        return new SecretKeySpec(rawKeyValue, "AES");
    }

    static String getAtLeastBitsMessagePart(int bits) {
        return String.format(" at least %d bits %s", bits, SymmetricKeySupport.getBitSizeExampleMessage(bits));
    }

    static String getExactBitsMessagePart(int bits) {
        return String.format(" exactly %d bits %s", bits, SymmetricKeySupport.getBitSizeExampleMessage(bits));
    }

    private static String getBitSizeExampleMessage(int bits) {
        return String.format("(e.g. %d hex or %d base64url characters)", bits / 8 * 2, (int)Math.ceil(21.33333396911621));
    }
}

