/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.composite;

import com.pingidentity.common.util.AdapterUtils;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import com.pingidentity.pf.adapters.composite.state.AllAttributesState;
import com.pingidentity.pf.adapters.composite.state.LoginState;
import com.pingidentity.pf.adapters.composite.state.LogoutState;
import com.pingidentity.pf.adapters.composite.validators.CompositeAdapterConfigurationValidator;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.event.PreRenderUtil;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.EnhancedRowValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdapterUser;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupport;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;

public class CompositeAdapter
implements IdpAuthenticationAdapterV2,
AdapterUser {
    Log log = LogFactory.getLog(this.getClass());
    private static final String ADAPTER_NAME = "Composite Adapter";
    public static final String TABLE_ADAPTERS = "Adapters";
    public static final String FIELD_ADAPTER_INSTANCE = "Adapter Instance";
    private static final String DESC_CONFIG = "A Composite Adapter allows existing adapter instances to be chained together to execute in sequence. Each configured instance of a Composite Adapter is treated as a single logical adapter instance.";
    private static final String TABLE_SYNONYMS = "Attribute Name Synonyms";
    private static final String FIELD_NAME = "Name";
    private static final String LOGGED_IN_ADAPTERS = "loggedInAdapters";
    private static final String POLICY = "Policy";
    private static final String TABLE_TWO_FACTOR = "Input User Id Mapping";
    private static final String TABLE_TWO_FACTOR_LABEL = "Input User ID Mapping";
    private static final String FIELD_TWO_FACTOR_ADAPTERS = "Target Adapter";
    private static final String FIELD_TWO_FACTOR_USER_ID = "User Id Selection";
    private static final String FIELD_TWO_FACTOR_USER_ID_LABEL = "User ID Selection";
    private static final String FIELD_AUTHN_CTX_WEIGHT = "AuthN Context Weight";
    private static final String FIELD_AUTHN_CTX_OVERRIDE = "AuthN Context Override";
    private static final String FIELD_ATTR_INSERTION = "Attribute Insertion";
    private static final String DESC_TWO_FACTOR = "Create mappings";
    private static final String DESC_SYNONYMS = "Create synonyms between adapter attributes";
    private static final String DESC_ADAPTERS = "Chained adapters";
    private static final String FIELD_SYNONYM = "Synonym";
    private static final String ERR_TWO_FACTOR_MAPPING = "Target Adapter mapping exists but there is no Target Adaptor added";
    private static final String addToFrontOption = "Add To Front";
    private static final String addToBackOption = "Add To Back";
    private static final String DESC_ATTR_INSERTION = "Defines the order in which different values are returned for the same attribute name.";
    private static final String KEY_ENABLE_TARGET_ADAPTER = "pf.server.enable.target.adapter";
    private final Map<String, String> synonyms = new HashMap<String, String>();
    private final Map<String, String> twoFactorMapping = new HashMap<String, String>();
    private final Map<String, Integer> authnCtxWeights = new HashMap<String, Integer>();
    private final Map<String, String> authnCtxOverrides = new HashMap<String, String>();
    private boolean addToBackAttributeInsertion = true;
    private StateSupport stateSupport;
    private Configuration c;
    private static final String ALL_ATTRIBUTES_STATE_NAME = "allAttributesState";
    private static final String LOGOUT_STATE_NAME = "logoutState";

    public CompositeAdapter() {
        this(new StateSupport(MetaDataFactory.getLocalMetaData()));
    }

    protected CompositeAdapter(StateSupport stateSupport) {
        this.stateSupport = stateSupport;
    }

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException, AuthnAdapterException {
        AuthnAdapterResponse adapterResponse;
        AllAttributesState allAttributesState;
        String resumePath = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
        String instanceId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.instanceid");
        TransactionalStateSupport txStateSupport = new TransactionalStateSupport(resumePath);
        LoginState loginState = (LoginState)txStateSupport.getAttribute((String)inParameters.get("com.pingidentity.adapter.input.parameter.instanceid"), req, resp);
        if (loginState == null) {
            loginState = new LoginState();
        }
        if ((allAttributesState = (AllAttributesState)txStateSupport.getAttribute(this.generateAllAttributesStateId(instanceId), req, resp)) == null) {
            allAttributesState = new AllAttributesState();
            String deviceSharingType = (String)inParameters.get("com.pingidentity.adapter.input.parameter.device.sharing.type");
            if (deviceSharingType != null) {
                allAttributesState.deviceSharingType = DeviceSharingType.valueOf((String)deviceSharingType);
            }
        }
        List rows = this.c.getTable(TABLE_ADAPTERS).getRows();
        Row row = (Row)rows.get(loginState.adapterIdx);
        String currentAdapterid = row.getFieldValue(FIELD_ADAPTER_INSTANCE);
        IdpAuthenticationAdapter authenticationAdapter = MgmtFactory.getAdapterManager().getIdpAuthnAdapter(currentAdapterid);
        IdpAuthnAdapterInstance currentAdapterInstance = MgmtFactory.getAdapterManager().getIdpAuthnAdapterInstance(currentAdapterid);
        boolean isCompositeAdapter = false;
        if (authenticationAdapter instanceof IdpAuthenticationAdapterV2) {
            IdpAuthenticationAdapterV2 adapterV2 = (IdpAuthenticationAdapterV2)authenticationAdapter;
            isCompositeAdapter = this.isCompositeAdapter(currentAdapterInstance);
            String userIdAttributeKey = this.twoFactorMapping.get(currentAdapterInstance.getName());
            boolean overrideInputUserId = userIdAttributeKey != null;
            userIdAttributeKey = this.getSynonym(userIdAttributeKey);
            String userIdAttribute = null;
            if (allAttributesState.attributes.get(userIdAttributeKey) != null) {
                userIdAttribute = ((AttributeValue)allAttributesState.attributes.get(userIdAttributeKey)).getValue();
            }
            txStateSupport.setAttribute((String)inParameters.get("com.pingidentity.adapter.input.parameter.instanceid"), (Object)loginState, req, resp);
            txStateSupport.setAttribute(this.generateAllAttributesStateId(instanceId), (Object)allAttributesState, req, resp);
            HashMap<String, Object> inParametersCopy = new HashMap<String, Object>(inParameters);
            if (!isCompositeAdapter && overrideInputUserId) {
                inParametersCopy.put("com.pingidentity.adapter.input.parameter.userid", userIdAttribute);
            }
            inParametersCopy.put("com.pingidentity.adapter.input.parameter.instanceid", currentAdapterid);
            inParametersCopy.put("com.pingidentity.adapter.input.parameter.device.sharing.type", allAttributesState.deviceSharingType.name());
            allAttributesState.attributes.put(ALL_ATTRIBUTES_STATE_NAME, userIdAttribute);
            inParametersCopy.put("com.pingidentity.adapter.input.parameter.chained.attributes", allAttributesState.attributes);
            this.log.info((Object)(loginState.adapterIdx + " calling lookupAuthN on adapterId=" + currentAdapterid));
            try (TimerScope ignored = Meters.getTimerScope((String)"adapter.lookup.authn", (String[])new String[]{"adapter.id", currentAdapterid});){
                req.setAttribute("defaultTemplateParams", (Object)TemplateParamUtil.populateDefaultTemplateParams(inParametersCopy));
                adapterResponse = adapterV2.lookupAuthN(req, resp, inParametersCopy);
            }
            catch (Exception e) {
                this.log.error((Object)("adapter: '" + currentAdapterid + "' exception during authentication: "), (Throwable)e);
                Meters.getCounter((String)"adapter.lookup.authn.errors", (String[])new String[]{"adapter.id", currentAdapterid}).increment();
                adapterResponse = new AuthnAdapterResponse();
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            }
        } else {
            String entityId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.partner.entityid");
            AuthnPolicy authnPolicy = (AuthnPolicy)inParameters.get("com.pingidentity.adapter.input.parameter.authn.policy");
            Map map = null;
            this.log.info((Object)(loginState.adapterIdx + " calling lookupAuthN on adapterId=" + currentAdapterid));
            try (TimerScope ignored = Meters.getTimerScope((String)"adapter.lookup.authn", (String[])new String[]{"adapter.id", currentAdapterid});){
                map = authenticationAdapter.lookupAuthN(req, resp, entityId, authnPolicy, resumePath);
            }
            catch (Exception e) {
                this.log.error((Object)("adapter: '" + currentAdapterid + "' exception during authentication: "), (Throwable)e);
                Meters.getCounter((String)"adapter.lookup.authn.errors", (String[])new String[]{"adapter.id", currentAdapterid}).increment();
                adapterResponse = new AuthnAdapterResponse();
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            }
            adapterResponse = new AuthnAdapterResponse();
            adapterResponse.setAttributeMap(map);
            if (resp.isCommitted()) {
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            } else {
                adapterResponse.setAuthnStatus(map == null || map.isEmpty() ? AuthnAdapterResponse.AUTHN_STATUS.FAILURE : AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
            }
        }
        this.auditAuthnAttempt(adapterResponse, currentAdapterid, resp);
        if (adapterResponse.getAuthnStatus() != AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS && AdapterUtils.adapterNeedsPathRandomization((IdpAuthnAdapterInstance)currentAdapterInstance)) {
            resumePath = this.stateSupport.insertNonce(resumePath);
        }
        AttributeMap adapterResultMap = null;
        if (adapterResponse.getAttributeMap() != null) {
            try {
                adapterResultMap = this.getAdapterResultMap(adapterResponse.getAttributeMap(), currentAdapterid, req);
            }
            catch (AuthorizationException e) {
                this.log.info((Object)("adapter: '" + currentAdapterid + "' failed issuance criteria: " + e.getMessage()));
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            }
            DeviceSharingType returnedSharingType = IdpSessionRegistrySupport.getDeviceSharingType((AttributeMap)adapterResultMap);
            if (returnedSharingType != DeviceSharingType.UNSPECIFIED) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Adapter " + currentAdapterid + " set org.sourceid.saml20.adapter.idp.authn.deviceSharingType to " + returnedSharingType));
                }
                allAttributesState.deviceSharingType = returnedSharingType;
            }
        }
        if (adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.SUCCESS) {
            try {
                ++loginState.adapterIdx;
                adapterResultMap = this.addAuthnCtxOverride(adapterResultMap, currentAdapterid);
                allAttributesState.attributes.put(currentAdapterid, adapterResponse.getAttributeMap());
                allAttributesState.attributes = this.mergeAttributes(allAttributesState, adapterResultMap);
                this.sortAuthnCtxByWeight(allAttributesState, currentAdapterid, adapterResultMap);
            }
            catch (NullPointerException e) {
                throw new AuthnAdapterException("Resulting AttributeMap with a SUCCESS status should not be null.");
            }
            inParameters.put("com.pingidentity.adapter.input.parameter.chained.attributes", allAttributesState.attributes);
            txStateSupport.setAttribute(this.generateAllAttributesStateId(instanceId), (Object)allAttributesState, req, resp);
            if (!isCompositeAdapter) {
                if (allAttributesState.attributes.get(LOGGED_IN_ADAPTERS) == null) {
                    allAttributesState.attributes.put(LOGGED_IN_ADAPTERS, new AttributeValue(currentAdapterid));
                } else {
                    ArrayList<String> loggedInAdapters = new ArrayList<String>(((AttributeValue)allAttributesState.attributes.get(LOGGED_IN_ADAPTERS)).getValuesAsCollection());
                    loggedInAdapters.add(currentAdapterid);
                    allAttributesState.attributes.put(LOGGED_IN_ADAPTERS, new AttributeValue(loggedInAdapters));
                }
            }
            if (row.getField(POLICY).getValue().equals(Policy.Sufficient.toString()) || loginState.adapterIdx >= rows.size()) {
                HashMap<String, Object> objectHashMap = new HashMap<String, Object>();
                objectHashMap.putAll(allAttributesState.attributes);
                objectHashMap.put("org.sourceid.saml20.adapter.idp.authn.deviceSharingType", allAttributesState.deviceSharingType.name());
                adapterResponse.setAttributeMap(objectHashMap);
                txStateSupport.removeAttribute(this.generateAllAttributesStateId(instanceId), req, resp);
                txStateSupport.removeAttribute((String)inParameters.get("com.pingidentity.adapter.input.parameter.instanceid"), req, resp);
            } else {
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                txStateSupport.setAttribute((String)inParameters.get("com.pingidentity.adapter.input.parameter.instanceid"), (Object)loginState, req, resp);
                txStateSupport.setAttribute(this.generateAllAttributesStateId(instanceId), (Object)allAttributesState, req, resp);
                resp.sendRedirect(resumePath);
            }
        } else if (adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.FAILURE) {
            if (row.getField(POLICY).getValue().equals(Policy.Required.toString())) {
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                txStateSupport.removeAttribute(this.generateAllAttributesStateId(instanceId), req, resp);
                txStateSupport.removeAttribute((String)inParameters.get("com.pingidentity.adapter.input.parameter.instanceid"), req, resp);
                return adapterResponse;
            }
            ++loginState.adapterIdx;
            if (loginState.adapterIdx < rows.size()) {
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                txStateSupport.setAttribute((String)inParameters.get("com.pingidentity.adapter.input.parameter.instanceid"), (Object)loginState, req, resp);
                txStateSupport.setAttribute(this.generateAllAttributesStateId(instanceId), (Object)allAttributesState, req, resp);
                if (!resp.isCommitted()) {
                    resp.sendRedirect(resumePath);
                }
            }
        }
        return adapterResponse;
    }

    private void auditAuthnAttempt(AuthnAdapterResponse adapterResponse, String currentAdapterid, HttpServletResponse resp) {
        AuditLogger.setAuthnSourceId((AuthnSourceKey)new AdapterAuthnSourceKey(currentAdapterid));
        if (adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.FAILURE) {
            AuditLogger.put((String)AuditLogger.MDC_KEY.DESCRIPTION.toString(), (String)adapterResponse.getErrorMessage());
        }
        AuditLogger.setUserName((String)adapterResponse.getUsername());
        IdpAuditLogger.logAuthnAttempt((String)"Attempted authentication with adapter", (AuthnAdapterResponse.AUTHN_STATUS)adapterResponse.getAuthnStatus());
        IdpAuditLogger.cleanupAuthnAttempt();
    }

    private AttributeMap getAdapterResultMap(Map<String, Object> incommingMap, String adapterId, HttpServletRequest request) throws AuthnAdapterException, AuthorizationException {
        AdapterAuthnSourceKey authnSourceKey = new AdapterAuthnSourceKey(adapterId);
        return new AuthnSourceSupport().executeAdditionalMapping((AuthnSourceKey)authnSourceKey, incommingMap, request, null, null);
    }

    private String generateAllAttributesStateId(String adapterInstanceId) {
        return adapterInstanceId + "-allAttributesState";
    }

    private void sortAuthnCtxByWeight(AllAttributesState allAttributesState, String adapterId, AttributeMap attributes) {
        if (attributes.containsKey((Object)"org.sourceid.saml20.adapter.idp.authn.authnCtx")) {
            Integer weight = this.getAuthnCtxWeight(adapterId);
            if (allAttributesState.authnCtx.get(weight) == null) {
                AttributeValue authnCtx = new AttributeValue(((AttributeValue)attributes.get((Object)"org.sourceid.saml20.adapter.idp.authn.authnCtx")).getValue());
                allAttributesState.authnCtx.put(weight, authnCtx);
            } else {
                ArrayList<String> attrValues = new ArrayList<String>();
                for (String val : allAttributesState.authnCtx.get(weight).getValues()) {
                    attrValues.add(val);
                }
                attrValues.add(((AttributeValue)attributes.get((Object)"org.sourceid.saml20.adapter.idp.authn.authnCtx")).getValue());
                allAttributesState.authnCtx.put(weight, new AttributeValue(attrValues));
            }
        }
        AttributeValue authnCtxList = null;
        Integer i = 5;
        while (i > 0) {
            if (allAttributesState.authnCtx.get(i) != null) {
                if (authnCtxList == null) {
                    authnCtxList = allAttributesState.authnCtx.get(i);
                } else {
                    ArrayList<String> attrValues = new ArrayList<String>();
                    for (String val : authnCtxList.getValues()) {
                        attrValues.add(val);
                    }
                    attrValues.add(allAttributesState.authnCtx.get(i).getValue());
                    authnCtxList = new AttributeValue(attrValues);
                }
            }
            Integer n = i;
            i = i - 1;
            Integer n2 = i;
        }
        allAttributesState.attributes.put("org.sourceid.saml20.adapter.idp.authn.authnCtx", authnCtxList);
    }

    public boolean isInUse(String instanceId) {
        if (this.c.getTable(TABLE_ADAPTERS) != null) {
            for (Row row : this.c.getTable(TABLE_ADAPTERS).getRows()) {
                if (!row.getField(FIELD_ADAPTER_INSTANCE).getValue().equals(instanceId)) continue;
                return true;
            }
        }
        return false;
    }

    private AttributeMap addAuthnCtxOverride(AttributeMap attrMap, String adapterId) {
        String override = this.authnCtxOverrides.get(adapterId);
        if (override != null && !override.equals("")) {
            attrMap.put("org.sourceid.saml20.adapter.idp.authn.authnCtx", override);
        }
        return attrMap;
    }

    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        TransactionalStateSupport txStateSupport = new TransactionalStateSupport(resumePath);
        LogoutState state = (LogoutState)txStateSupport.getAttribute(LOGOUT_STATE_NAME, req, resp);
        if (state == null) {
            state = new LogoutState();
        }
        if (!state.waitingAdapterResponse) {
            resumePath = this.stateSupport.insertNonce(resumePath);
        }
        String currentAdapterId = (String)((AttributeValue)authnIdentifiers.get(LOGGED_IN_ADAPTERS)).getValuesAsCollection().toArray()[state.adapterIdx];
        IdpAuthenticationAdapter authenticationAdapter = MgmtFactory.getAdapterManager().getIdpAuthnAdapter(currentAdapterId);
        this.log.info((Object)(state.adapterIdx + " calling logoutAuthN on adapterId=" + currentAdapterId));
        boolean result = authenticationAdapter.logoutAuthN((Map)authnIdentifiers.get(currentAdapterId), req, resp, resumePath);
        if (resp.isCommitted()) {
            state.waitingAdapterResponse = true;
            txStateSupport.setAttribute(LOGOUT_STATE_NAME, (Object)state, req, resp);
            return false;
        }
        state.waitingAdapterResponse = false;
        if (result) {
            ++state.numSuccesses;
        }
        ++state.adapterIdx;
        if (state.adapterIdx < ((AttributeValue)authnIdentifiers.get(LOGGED_IN_ADAPTERS)).getValuesAsCollection().size()) {
            txStateSupport.setAttribute(LOGOUT_STATE_NAME, (Object)state, req, resp);
            resp.sendRedirect(resumePath);
            return false;
        }
        txStateSupport.removeAttribute(LOGOUT_STATE_NAME, req, resp);
        return state.numSuccesses >= ((AttributeValue)authnIdentifiers.get(LOGGED_IN_ADAPTERS)).getValuesAsCollection().size();
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        AdapterConfigurationGuiDescriptor desc = new AdapterConfigurationGuiDescriptor(DESC_CONFIG);
        TableDescriptor adaptersTable = new TableDescriptor(TABLE_ADAPTERS, DESC_ADAPTERS);
        desc.addTable(adaptersTable);
        adaptersTable.addValidator((RowValidator)new EnhancedRowValidator(){

            public void validate(FieldList fieldsInRow) throws ValidationException {
            }

            public void validate(FieldList fieldsInRow, Configuration configuration) throws ValidationException {
                String repeatedAdapter = CompositeAdapter.this.hasRepeatedFieldValue(configuration, CompositeAdapter.TABLE_ADAPTERS, CompositeAdapter.FIELD_ADAPTER_INSTANCE);
                if (!StringUtils.isEmpty((String)repeatedAdapter)) {
                    throw new ValidationException("Adapter has already been added");
                }
            }
        });
        desc.addValidator(new ConfigurationValidator(){

            public void validate(Configuration configuration) throws ValidationException {
                ArrayList<String> errors = new ArrayList<String>();
                Table table = configuration.getTable(CompositeAdapter.TABLE_ADAPTERS);
                boolean foundVip = false;
                for (Row row : table.getRows()) {
                    String adapterId = row.getField(CompositeAdapter.FIELD_ADAPTER_INSTANCE).getValue();
                    IdpAuthenticationAdapter authenticationAdapter = MgmtFactory.getAdapterManager().getIdpAuthnAdapter(adapterId);
                    IdpAuthnAdapterInstance instance = MgmtFactory.getAdapterManager().getIdpAuthnAdapterInstance(adapterId);
                    if (!(authenticationAdapter instanceof IdpAuthenticationAdapterV2) || CompositeAdapter.this.isCompositeAdapter(instance)) continue;
                    foundVip = true;
                }
                table = configuration.getTable(CompositeAdapter.TABLE_TWO_FACTOR);
                if (table != null && table.getRows().size() > 0 && !foundVip) {
                    errors.add(CompositeAdapter.ERR_TWO_FACTOR_MAPPING);
                }
                if (!errors.isEmpty()) {
                    throw new ValidationException(errors);
                }
            }
        });
        AdapterSelectFieldDescriptor adapterSelectFieldDescriptor = new AdapterSelectFieldDescriptor(FIELD_ADAPTER_INSTANCE, "");
        adapterSelectFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        adaptersTable.addRowField((FieldDescriptor)adapterSelectFieldDescriptor);
        String[] options = new String[]{"Required", "Sufficient"};
        RadioGroupFieldDescriptor groupFieldDescriptor = new RadioGroupFieldDescriptor(POLICY, "", options);
        groupFieldDescriptor.setDefaultValue(options[0]);
        groupFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        adaptersTable.addRowField((FieldDescriptor)groupFieldDescriptor);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> contxOptionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        SelectFieldDescriptor contxDesc = new SelectFieldDescriptor(FIELD_AUTHN_CTX_WEIGHT, "", contxOptionValues);
        Integer i = 1;
        while (i <= 5) {
            contxOptionValues.add(new AbstractSelectionFieldDescriptor.OptionValue(i.toString(), i.toString()));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        contxDesc.setOptionValues(contxOptionValues);
        contxDesc.setDefaultValue("3");
        adaptersTable.addRowField((FieldDescriptor)contxDesc);
        TextFieldDescriptor defaultAuthnCtxDesc = new TextFieldDescriptor(FIELD_AUTHN_CTX_OVERRIDE, "");
        adaptersTable.addRowField((FieldDescriptor)defaultAuthnCtxDesc);
        SelectFieldDescriptor selectFieldDescriptor1 = new SelectFieldDescriptor(FIELD_NAME, "", new String[0]);
        SelectFieldDescriptor selectFieldDescriptor2 = new SelectFieldDescriptor(FIELD_SYNONYM, "", new String[0]);
        String[] attrSortOptions = new String[]{addToBackOption, addToFrontOption};
        RadioGroupFieldDescriptor attrSortDesc = new RadioGroupFieldDescriptor(FIELD_ATTR_INSERTION, DESC_ATTR_INSERTION, attrSortOptions);
        attrSortDesc.setDefaultValue(attrSortOptions[0]);
        attrSortDesc.addValidator((FieldValidator)new RequiredFieldValidator());
        desc.addField((FieldDescriptor)attrSortDesc);
        desc.addPreRenderCallback(new PreRenderCallback(){

            public void callback(List<FieldDescriptor> fieldDescriptors, List<FieldDescriptor> advancedFieldDescriptors, List<TableDescriptor> tableDescriptors, Configuration configuration) {
                TableDescriptor targetTableDescr;
                SelectFieldDescriptor synonymsFieldDescriptor1 = (SelectFieldDescriptor)PreRenderUtil.findTable(tableDescriptors, (String)CompositeAdapter.TABLE_SYNONYMS).getRowFields().get(0);
                SelectFieldDescriptor synonymsFieldDescriptor2 = (SelectFieldDescriptor)PreRenderUtil.findTable(tableDescriptors, (String)CompositeAdapter.TABLE_SYNONYMS).getRowFields().get(1);
                TreeSet<String> attributeNames = new TreeSet<String>();
                TreeSet<String> twoFactorAttributes = new TreeSet<String>();
                TreeSet<String> twoFactorAdapters = new TreeSet<String>();
                for (Object row : configuration.getTable(CompositeAdapter.TABLE_ADAPTERS).getRows()) {
                    AdapterManager adapterManager = MgmtFactory.getAdapterManager();
                    String adapterId = row.getFieldValue(CompositeAdapter.FIELD_ADAPTER_INSTANCE);
                    if (adapterId == null) continue;
                    IdpAuthnAdapterInstance instance = adapterManager.getIdpAuthnAdapterInstance(adapterId);
                    IdpAuthenticationAdapter authenticationAdapter = MgmtFactory.getAdapterManager().getIdpAuthnAdapter(adapterId);
                    if (instance == null) continue;
                    for (String name : instance.getAttributeContract().getAllAttributeNames()) {
                        twoFactorAttributes.add(name);
                        attributeNames.add(name);
                    }
                    if (!(authenticationAdapter instanceof IdpAuthenticationAdapterV2) || CompositeAdapter.this.isCompositeAdapter(instance)) continue;
                    twoFactorAdapters.add(instance.getName());
                }
                if (CompositeAdapter.this.isTwoFactorInstalled()) {
                    ArrayList<AbstractSelectionFieldDescriptor.OptionValue> twoFactorAdapterOptionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
                    for (String string : twoFactorAdapters) {
                        twoFactorAdapterOptionValues.add(new AbstractSelectionFieldDescriptor.OptionValue(string, string));
                    }
                    twoFactorAdapterOptionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
                    twoFactorAdapterOptionValues.add(0, SelectFieldDescriptor.SELECT_ONE);
                    ArrayList<AbstractSelectionFieldDescriptor.OptionValue> twoFactorAttributeOptionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
                    for (String name : twoFactorAttributes) {
                        twoFactorAttributeOptionValues.add(new AbstractSelectionFieldDescriptor.OptionValue(name, name));
                    }
                    twoFactorAttributeOptionValues.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
                    twoFactorAttributeOptionValues.add(0, SelectFieldDescriptor.SELECT_ONE);
                    SelectFieldDescriptor selectFieldDescriptor = (SelectFieldDescriptor)PreRenderUtil.findTable(tableDescriptors, (String)CompositeAdapter.TABLE_TWO_FACTOR).getRowFields().get(0);
                    SelectFieldDescriptor selectFieldTwoFactorAttributesDescriptor = (SelectFieldDescriptor)PreRenderUtil.findTable(tableDescriptors, (String)CompositeAdapter.TABLE_TWO_FACTOR).getRowFields().get(1);
                    selectFieldDescriptor.setOptionValues(twoFactorAdapterOptionValues);
                    selectFieldTwoFactorAttributesDescriptor.setOptionValues(twoFactorAttributeOptionValues);
                } else if (!System.getProperty(CompositeAdapter.KEY_ENABLE_TARGET_ADAPTER, "false").equalsIgnoreCase("true") && (targetTableDescr = PreRenderUtil.findTable(tableDescriptors, (String)CompositeAdapter.TABLE_TWO_FACTOR)) != null) {
                    tableDescriptors.remove(targetTableDescr);
                }
                ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
                optionValues.add(SelectFieldDescriptor.SELECT_ONE);
                for (String string : attributeNames) {
                    optionValues.add(new AbstractSelectionFieldDescriptor.OptionValue(string, string));
                }
                synonymsFieldDescriptor1.setOptionValues(optionValues);
                synonymsFieldDescriptor2.setOptionValues(optionValues);
            }
        });
        TableDescriptor twoFactorTable = new TableDescriptor(TABLE_TWO_FACTOR, DESC_TWO_FACTOR);
        twoFactorTable.setLabel(TABLE_TWO_FACTOR_LABEL);
        desc.addTable(twoFactorTable);
        SelectFieldDescriptor selectFieldTwoFactorAdaptersDescriptor = new SelectFieldDescriptor(FIELD_TWO_FACTOR_ADAPTERS, "", new String[0]);
        SelectFieldDescriptor selectFieldTwoFactorAttributesDescriptor = new SelectFieldDescriptor(FIELD_TWO_FACTOR_USER_ID, "", new String[0]);
        selectFieldTwoFactorAttributesDescriptor.setLabel(FIELD_TWO_FACTOR_USER_ID_LABEL);
        selectFieldTwoFactorAdaptersDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        twoFactorTable.addValidator((RowValidator)new EnhancedRowValidator(){

            public void validate(FieldList fieldsInRow) throws ValidationException {
            }

            public void validate(FieldList fieldsInRow, Configuration configuration) throws ValidationException {
                String repeatedAdapter = CompositeAdapter.this.hasRepeatedFieldValue(configuration, CompositeAdapter.TABLE_TWO_FACTOR, CompositeAdapter.FIELD_TWO_FACTOR_ADAPTERS);
                if (!StringUtils.isEmpty((String)repeatedAdapter)) {
                    throw new ValidationException("Input User ID already mapped for " + repeatedAdapter);
                }
            }
        });
        selectFieldTwoFactorAttributesDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        twoFactorTable.addRowField((FieldDescriptor)selectFieldTwoFactorAdaptersDescriptor);
        twoFactorTable.addRowField((FieldDescriptor)selectFieldTwoFactorAttributesDescriptor);
        TableDescriptor namesTable = new TableDescriptor(TABLE_SYNONYMS, DESC_SYNONYMS);
        desc.addTable(namesTable);
        namesTable.addValidator((RowValidator)new EnhancedRowValidator(){

            public void validate(FieldList fieldsInRow) throws ValidationException {
                if (fieldsInRow.getFieldValue(CompositeAdapter.FIELD_NAME).equals(fieldsInRow.getFieldValue(CompositeAdapter.FIELD_SYNONYM))) {
                    throw new ValidationException("The Name/Synonym pair is identical");
                }
            }

            public void validate(FieldList fieldsInRow, Configuration configuration) throws ValidationException {
                ArrayList<String> names = new ArrayList<String>();
                for (Row row : configuration.getTable(CompositeAdapter.TABLE_SYNONYMS).getRows()) {
                    if (names.contains(row.getFieldValue(CompositeAdapter.FIELD_NAME))) {
                        throw new ValidationException("Name has already been assigned to a synonym");
                    }
                    names.add(row.getFieldValue(CompositeAdapter.FIELD_NAME));
                }
            }
        });
        namesTable.addRowField((FieldDescriptor)selectFieldDescriptor1);
        namesTable.addRowField((FieldDescriptor)selectFieldDescriptor2);
        desc.addValidator((ConfigurationValidator)new CompositeAdapterConfigurationValidator());
        IdpAuthnAdapterDescriptor descriptor = new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, ADAPTER_NAME, new HashSet(), true, desc, false, VersionUtil.getVersion());
        descriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
        return descriptor;
    }

    private String hasRepeatedFieldValue(Configuration configuration, String tableName, String feildName) {
        ArrayList<String> encountredfieldNames = new ArrayList<String>();
        for (Row row : configuration.getTable(tableName).getRows()) {
            String fieldValue = row.getFieldValue(feildName);
            if (encountredfieldNames.contains(fieldValue.toUpperCase())) {
                return fieldValue;
            }
            encountredfieldNames.add(row.getFieldValue(feildName).toUpperCase());
        }
        return null;
    }

    protected boolean isTwoFactorInstalled() {
        for (IdpAuthnAdapterInstance instance : MgmtFactory.getAdapterManager().getIdpAuthnAdapterInstances()) {
            IdpAuthenticationAdapter adapter = MgmtFactory.getAdapterManager().getIdpAuthnAdapter(instance.getId());
            if (!(adapter instanceof IdpAuthenticationAdapterV2) || this.isCompositeAdapter(instance)) continue;
            return true;
        }
        return false;
    }

    public void configure(Configuration configuration) {
        this.c = configuration;
        this.createSynonyms();
        this.createTwoFactorMapping();
        this.createAuthnCtxWeights();
        this.createAuthnCtxOverrides();
        this.createAttributeInsertion();
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    private void addSynonym(String name, String synonym) {
        this.synonyms.put(synonym, name);
    }

    private String getSynonym(String attr) {
        if (this.synonyms.get(attr) == null) {
            return attr;
        }
        return this.synonyms.get(attr);
    }

    private boolean isCompositeAdapter(IdpAuthnAdapterInstance adapter) {
        return adapter.getDescriptor().getPluginClassName().contains("CompositeAdapter");
    }

    protected Map<String, Object> mergeAttributes(AllAttributesState state, AttributeMap sourceMap) {
        String attrKey = null;
        Iterator it = sourceMap.keySet().iterator();
        String attrSynonym = null;
        while (it.hasNext()) {
            attrKey = (String)it.next();
            attrSynonym = this.getSynonym(attrKey);
            if (state.attributes.get(attrSynonym) != null) {
                if (!(state.attributes.get(attrSynonym) instanceof AttributeValue)) continue;
                for (String sourceMapValue : ((AttributeValue)sourceMap.get((Object)attrKey)).getValues()) {
                    AttributeValue valFromState;
                    if (this.valueExists(sourceMapValue, valFromState = (AttributeValue)state.attributes.get(attrSynonym))) continue;
                    ArrayList<String> attrValues = new ArrayList<String>();
                    for (String val : valFromState.getValues()) {
                        attrValues.add(val);
                    }
                    if (this.addToBackAttributeInsertion) {
                        attrValues.add(sourceMapValue);
                    } else {
                        attrValues.add(0, sourceMapValue);
                    }
                    state.attributes.put(attrSynonym, new AttributeValue(attrValues));
                }
                continue;
            }
            state.attributes.put(attrSynonym, sourceMap.get((Object)attrKey));
        }
        return state.attributes;
    }

    private boolean valueExists(String attr, AttributeValue attrValues) {
        for (String val : attrValues.getValues()) {
            if (!val.equals(attr)) continue;
            return true;
        }
        return false;
    }

    private void createAttributeInsertion() {
        this.addToBackAttributeInsertion = this.c.getField(FIELD_ATTR_INSERTION).getValue().equals(addToBackOption);
    }

    private void createAuthnCtxWeights() {
        List rows = this.c.getTable(TABLE_ADAPTERS).getRows();
        for (Row row : rows) {
            if (row.getFieldValue(FIELD_AUTHN_CTX_WEIGHT) == null || row.getFieldValue(FIELD_AUTHN_CTX_WEIGHT).equals("")) continue;
            this.authnCtxWeights.put(row.getFieldValue(FIELD_ADAPTER_INSTANCE), Integer.valueOf(row.getFieldValue(FIELD_AUTHN_CTX_WEIGHT)));
        }
    }

    private void createAuthnCtxOverrides() {
        List rows = this.c.getTable(TABLE_ADAPTERS).getRows();
        for (Row row : rows) {
            this.authnCtxOverrides.put(row.getFieldValue(FIELD_ADAPTER_INSTANCE), row.getFieldValue(FIELD_AUTHN_CTX_OVERRIDE));
        }
    }

    private Integer getAuthnCtxWeight(String adapterId) {
        return this.authnCtxWeights.get(adapterId);
    }

    private void createTwoFactorMapping() {
        if (this.c.getTable(TABLE_TWO_FACTOR) != null) {
            List rows = this.c.getTable(TABLE_TWO_FACTOR).getRows();
            for (Row row : rows) {
                this.twoFactorMapping.put(row.getFieldValue(FIELD_TWO_FACTOR_ADAPTERS), row.getFieldValue(FIELD_TWO_FACTOR_USER_ID));
            }
        }
    }

    private void createSynonyms() {
        List rows = this.c.getTable(TABLE_SYNONYMS).getRows();
        for (Row row : rows) {
            this.addSynonym(row.getFieldValue(FIELD_SYNONYM), row.getFieldValue(FIELD_NAME));
        }
    }

    public Map lookupAuthN(HttpServletRequest req, HttpServletResponse resp, String partnerSpEntityId, AuthnPolicy authnPolicy, String resumePath) throws AuthnAdapterException, IOException {
        throw new UnsupportedOperationException();
    }

    public class AdapterSelectFieldDescriptor
    extends SelectFieldDescriptor {
        private static final long serialVersionUID = 1L;

        protected AdapterSelectFieldDescriptor(String name, String description) {
            super(name, description);
        }

        public List<AbstractSelectionFieldDescriptor.OptionValue> getOptionValues() {
            ArrayList<AbstractSelectionFieldDescriptor.OptionValue> options = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
            AdapterManager adapterManager = MgmtFactory.getAdapterManager();
            Collection instances = adapterManager.getIdpAuthnAdapterNonConnectionBasedInstances();
            for (IdpAuthnAdapterInstance instance : instances) {
                options.add(new AbstractSelectionFieldDescriptor.OptionValue(instance.getName(), instance.getId()));
            }
            options.sort(AbstractSelectionFieldDescriptor.OptionValue.NAME_COMPARATOR);
            options.add(0, SELECT_ONE);
            return options;
        }
    }

    private static enum Policy {
        Required,
        Sufficient;

    }
}

