/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.client.registration;

import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.oauth20.registration.ClientRegistrationException;
import com.pingidentity.sdk.oauth20.registration.DynamicClient;
import com.pingidentity.sdk.oauth20.registration.DynamicClientRegistrationPlugin;
import com.pingidentity.sdk.oauth20.registration.DynamicClientRegistrationPluginDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientUtil;
import org.sourceid.oauth20.domain.DynamicOAuthClient;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class ResponseTypesConstraintsPlugin
implements DynamicClientRegistrationPlugin {
    private static final Log LOG = LogFactory.getLog(ResponseTypesConstraintsPlugin.class);
    private static final String TYPE = "Response Type Constraints";
    private static final String DESCRIPTION = "Select which response types are permitted for dynamically registered clients.";
    private static final String VERSION = "1.0";
    private final String CODE = "code";
    private final String CODE_ID_TOKEN = "code id_token";
    private final String CODE_ID_TOKEN_TOKEN = "code id_token token";
    private final String CODE_TOKEN = "code token";
    private final String ID_TOKEN = "id_token";
    private final String ID_TOKEN_TOKEN = "id_token token";
    private final String TOKEN = "token";
    private boolean codeChecked;
    private boolean tokenChecked;
    private boolean codeIdTokenTokenChecked;
    private boolean codeTokenChecked;
    private boolean idTokenChecked;
    private boolean idTokenTokenChecked;
    private boolean codeIdTokenChecked;

    public void processPlugin(HttpServletRequest request, HttpServletResponse response, DynamicClient dynamicClient, Map<String, Object> inParameters) throws ClientRegistrationException {
        if (dynamicClient.getGrantTypes().contains("implicit") || dynamicClient.getGrantTypes().contains("authorization_code") || dynamicClient.getGrantTypes().isEmpty()) {
            List<Object> responseTypeList;
            ClientUtil.setDefaultClientRegistrationGrantTypesAndResponseTypes((Client)((DynamicOAuthClient)dynamicClient));
            if (dynamicClient.getRestrictedResponseTypes() == null || dynamicClient.getRestrictedResponseTypes().size() == 0) {
                responseTypeList = ClientUtil.RESPONSE_TYPES.stream().map(responseTypeStr -> new ResponseType(responseTypeStr, null)).collect(Collectors.toList());
            } else {
                responseTypeList = dynamicClient.getRestrictedResponseTypes().stream().map(responseTypeStr -> new ResponseType(responseTypeStr, null)).filter(responseType -> responseType.isValidResponseType()).collect(Collectors.toList());
                if (responseTypeList.size() == 0) {
                    String description = "response_types provided are invalid.";
                    LOG.error((Object)description);
                    throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_payload, description);
                }
            }
            this.setResponseType(this.codeChecked, new ResponseType("code", null), responseTypeList);
            this.setResponseType(this.tokenChecked, new ResponseType("token", null), responseTypeList);
            this.setResponseType(this.codeIdTokenTokenChecked, new ResponseType("code id_token token", null), responseTypeList);
            this.setResponseType(this.codeTokenChecked, new ResponseType("code token", null), responseTypeList);
            this.setResponseType(this.idTokenChecked, new ResponseType("id_token", null), responseTypeList);
            this.setResponseType(this.idTokenTokenChecked, new ResponseType("id_token token", null), responseTypeList);
            this.setResponseType(this.codeIdTokenChecked, new ResponseType("code id_token", null), responseTypeList);
            if (responseTypeList.size() == 0) {
                String description = "response_types provided are invalid.";
                LOG.error((Object)description);
                throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_payload, description);
            }
            dynamicClient.setRestrictedResponseTypes(responseTypeList.stream().map(responseType -> String.join((CharSequence)" ", responseType.getParts())).collect(Collectors.toList()));
        }
    }

    public void processPluginUpdate(HttpServletRequest request, HttpServletResponse response, DynamicClient dynamicClient, DynamicClient existingDynamicClient, Map<String, Object> inParameters) throws ClientRegistrationException {
        this.processPlugin(request, response, dynamicClient, inParameters);
    }

    private void setResponseType(boolean isAllowed, ResponseType responseType, List<ResponseType> responseTypeList) {
        if (!isAllowed) {
            responseTypeList.removeIf(responseType1 -> responseType1.hasExactly(responseType.getParts()));
        }
    }

    public void configure(Configuration configuration) {
        this.codeChecked = configuration.getBooleanFieldValue("code");
        this.codeIdTokenChecked = configuration.getBooleanFieldValue("code id_token");
        this.codeIdTokenTokenChecked = configuration.getBooleanFieldValue("code id_token token");
        this.codeTokenChecked = configuration.getBooleanFieldValue("code token");
        this.idTokenChecked = configuration.getBooleanFieldValue("id_token");
        this.idTokenTokenChecked = configuration.getBooleanFieldValue("id_token token");
        this.tokenChecked = configuration.getBooleanFieldValue("token");
    }

    public PluginDescriptor getPluginDescriptor() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor(DESCRIPTION);
        CheckBoxFieldDescriptor code = new CheckBoxFieldDescriptor("code", "");
        code.setDefaultValue(true);
        guiConfigDescriptor.addField((FieldDescriptor)code);
        CheckBoxFieldDescriptor codeIdToken = new CheckBoxFieldDescriptor("code id_token", "");
        codeIdToken.setDefaultValue(true);
        guiConfigDescriptor.addField((FieldDescriptor)codeIdToken);
        CheckBoxFieldDescriptor codeIdTokenToken = new CheckBoxFieldDescriptor("code id_token token", "");
        codeIdTokenToken.setDefaultValue(true);
        guiConfigDescriptor.addField((FieldDescriptor)codeIdTokenToken);
        CheckBoxFieldDescriptor codeToken = new CheckBoxFieldDescriptor("code token", "");
        codeToken.setDefaultValue(true);
        guiConfigDescriptor.addField((FieldDescriptor)codeToken);
        CheckBoxFieldDescriptor idToken = new CheckBoxFieldDescriptor("id_token", "");
        idToken.setDefaultValue(true);
        guiConfigDescriptor.addField((FieldDescriptor)idToken);
        CheckBoxFieldDescriptor idTokenToken = new CheckBoxFieldDescriptor("id_token token", "");
        idTokenToken.setDefaultValue(true);
        guiConfigDescriptor.addField((FieldDescriptor)idTokenToken);
        CheckBoxFieldDescriptor token = new CheckBoxFieldDescriptor("token", "");
        token.setDefaultValue(true);
        guiConfigDescriptor.addField((FieldDescriptor)token);
        guiConfigDescriptor.addValidator(configuration -> {
            this.codeChecked = configuration.getBooleanFieldValue("code");
            this.codeIdTokenChecked = configuration.getBooleanFieldValue("code id_token");
            this.codeIdTokenTokenChecked = configuration.getBooleanFieldValue("code id_token token");
            this.codeTokenChecked = configuration.getBooleanFieldValue("code token");
            this.idTokenChecked = configuration.getBooleanFieldValue("id_token");
            this.idTokenTokenChecked = configuration.getBooleanFieldValue("id_token token");
            this.tokenChecked = configuration.getBooleanFieldValue("token");
            ArrayList<String> errors = new ArrayList<String>();
            if (!(this.codeChecked || this.codeIdTokenChecked || this.codeIdTokenTokenChecked || this.codeTokenChecked || this.idTokenChecked || this.idTokenTokenChecked || this.tokenChecked)) {
                errors.add("Please select at least one response type");
            }
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        });
        DynamicClientRegistrationPluginDescriptor pluginDescriptor = new DynamicClientRegistrationPluginDescriptor(TYPE, (Plugin)this, guiConfigDescriptor, VERSION);
        pluginDescriptor.setSupportsExtendedContract(false);
        pluginDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
        return pluginDescriptor;
    }
}

