/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.datastore.other;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.access.ClusterAccessor;
import com.pingidentity.common.util.ssl.PingCustomSSLSocketFactoryUtil;
import com.pingidentity.pf.datastore.other.AccessTokenResponse;
import com.pingidentity.pf.datastore.other.RequestResponse;
import com.pingidentity.pf.datastore.other.util.ExponentialBackOffCalculator;
import com.pingidentity.pf.datastore.other.util.HttpUtil;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sources.CustomDataSourceDriver;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLSocketFactory;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.sourceid.common.Util;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ClientCertKeypairFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SecretReferenceFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.TableValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.TableColumnValuesUniqueValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.URLValidator;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTagUtil;
import org.sourceid.saml20.domain.datasource.tag.RestDataSourceInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.RestDataSourceTagConfig;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.impl.SecretReferenceHelper;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public abstract class RestDataSourceBase
implements CustomDataSourceDriver {
    static final String SOURCE_DESCRIPTOR = "REST API";
    static final String BASE_URL_FIELD = "Base URL";
    static final String BASE_URL_DESC = "The base URL of the REST API service.";
    static final String AUTH_METHOD_FIELD = "Authentication Method";
    static final String AUTH_METHOD_DESC = "Select the authentication method used to access the REST service.";
    static final String HTTP_METHOD = "HTTP Method";
    static final String HTTP_METHOD_DESC = "Select the HTTP method to call the REST API service.";
    static final String HTTP_BASIC_USER_FIELD = "Username";
    static final String HTTP_BASIC_USER_DESC = "The username to use for basic authentication.";
    static final String HTTP_BASIC_PASSWORD_FIELD = "Password";
    static final String HTTP_BASIC_PASSWORD_REFERENCE_FIELD = "Password Reference";
    static final String HTTP_BASIC_PASSWORD_DESC = "The password to use for basic authentication. Only one of 'Password Reference' or this field can be provided.";
    static final String HTTP_BASIC_PASSWORD_REFERENCE_DESC = "The secret reference used to retrieve the password from a configured secret manager. Only one of 'Password' or this field can be provided. \nExpected format 'OBF:MGR:{secretManagerId}:{secretId}'.";
    static final String AUTH_SERVER_URL_FIELD = "OAuth Token Endpoint";
    static final String AUTH_SERVER_URL_DESC = "When using OAuth client credentials grant type, this specifies the authorization server token endpoint URL.";
    static final String AUTH_SCOPE_FIELD = "OAuth Scope";
    static final String AUTH_SCOPE_DESC = "When using OAuth client credentials grant type, this specifies the space delimited authorization scope(s) requested from the authorization endpoint to access the REST API service.";
    static final String CLIENT_ID_FIELD = "Client ID";
    static final String CLIENT_ID_DESC = "When using OAuth client credentials grant type, this specifies the ID of the client created in the REST service for authentication.";
    static final String CLIENT_SECRET_FIELD = "Client Secret";
    static final String CLIENT_SECRET_REFERENCE_FIELD = "Client Secret Reference";
    static final String CLIENT_SECRET_DESC = "When using OAuth client credentials grant type, this specifies the secret of the client created in the REST service authentication. Only one of 'Client Secret Reference' or this field can be provided.";
    static final String CLIENT_SECRET_REFERENCE_DESC = "The secret reference used to retrieve the secret from a configured secret manager. Only one of 'Client Secret' or this field can be provided. \nExpected format 'OBF:MGR:{secretManagerId}:{secretId}'.";
    static final String CLIENT_TLS_CERTIFICATE_FIELD = "Client TLS Certificate";
    static final String CLIENT_TLS_CERTIFICATE_DESC = "The certificate to use for Client TLS Certificate authentication.";
    static final String HTTPS_HOSTNAME_VERIFICATION_FIELD = "Enable HTTPS Hostname Verification";
    static final String HTTPS_HOSTNAME_VERIFICATION_DESC = "When SSL/TLS is used, this specifies whether to check if the hostname for the REST service matches the hostname in the certificate it presents.";
    static final String READ_TIMEOUT_FIELD = "Read Timeout (ms)";
    static final String READ_TIMEOUT_DESC = "Defines the socket timeout in milliseconds. A timeout value of zero is interpreted as an infinite timeout. A value of -1 will cause the OS level default to be used.";
    static final String CONNECTION_TIMEOUT_FIELD = "Connection Timeout (ms)";
    static final String CONNECTION_TIMEOUT_DESC = "Determines the timeout in milliseconds until a connection is established. A timeout value of zero is interpreted as an infinite timeout. A value of -1 will cause the OS level default to be used.";
    static final String MAX_PAYLOAD_SIZE_FIELD = "Max Payload Size (KB)";
    static final String MAX_PAYLOAD_SIZE_DESC = "Defines the maximum allowed size in kilobytes of the returned JSON response payload. A value of zero is interpreted as an unrestricted payload size.";
    static final String RETRY_REQUEST_FIELD = "Retry Request";
    static final String RETRY_REQUEST_DESC = "Retry user data retrieval request if API fails with error codes configured.";
    static final String MAX_RETRIES_ATTEMPT_FIELD = "Maximum Retries Limit";
    static final String MAX_RETRIES_ATTEMPT_DESC = "Maximum number of retries attempted if API fails with error codes configured.";
    static final String API_FAILURE_CODES_FIELD = "Retry Error Codes";
    static final String POOLING_MANAGER_MAX_CONNECTIONS_FIELD = "Maximum Connections";
    static final String POOLING_MANAGER_MAX_CONNECTIONS_DESC = "Defines the maximum size of the pool of connections that can be open for this datastore.";
    static final String API_FAILURE_CODES_DESCR = "Comma-separated list of error code values for API re-attempt e.g. 429, 503.";
    static final String TEST_CONNECTION_URL_FIELD = "Test Connection URL";
    static final String TEST_CONNECTION_URL_DESC = "The URL for sending a GET or POST request to in order to test the data store connection. If not specified, it will use the Base URL.";
    static final String TEST_CONNECTION_BODY_FIELD = "Test Connection Body";
    static final String TEST_CONNECTION_BODY_DESC = "The body to send to test the data store connection.";
    static final String EXCLUDE_CONTENT_TYPE_FROM_GET_CALL = "Exclude default Content-Type from GET Request";
    static final String EXCLUDE_CONTENT_TYPE_FROM_GET_CALL_DESC = "When checked, the default Content-Type header is excluded from GET requests, but custom headers are still included.";
    static final String HEADER_TABLE_NAME = "HTTP Request Headers";
    static final String HEADER_TABLE_NAME_DESC = "Define HTTP headers to include in the request.";
    static final String HEADER_NAME_COL_FIELD = "Header Name";
    static final String HEADER_NAME_COL_DESC = "";
    static final String HEADER_VALUE_COL_FIELD = "Header Value";
    static final String HEADER_VALUE_COL_DESC = "";
    static final String TEST_CONNECTION__ACTION_FIELD = "Test Connection";
    static final String TEST_CONNECTION_ACTION_DESC = "Tests connectivity to the REST service based on the provided Test Connection URL";
    static final String BASE_URL_TAG_TABLE_NAME = "Base URLs and Tags";
    static final String BASE_URL_TAG_TABLE_NAME_DESC = "Define Base URLs of the REST API service and associated tags. When multiple URLs are configured, nodes use the first URL with a tag matching one of the node.tags in the run.properties file.";
    static final String BASE_URL_COL_FIELD = "Base URL";
    static final String BASE_URL_COL_DESC = "";
    static final String TAGS_COL_FIELD = "Tags";
    static final String TAGS_COL_DESC = "";
    static final String AUTH_OPTION_NONE = "None";
    static final String AUTH_OPTION_BASIC = "Basic Authentication";
    static final String AUTH_OPTION_OAUTH = "OAuth 2.0 Bearer Token";
    static final String AUTH_OPTION_CLIENT_TLS_CERTIFICATE = "Client TLS Certificate";
    private static final String[] AUTHORIZATION_OPTIONS = new String[]{"None", "Basic Authentication", "OAuth 2.0 Bearer Token", "Client TLS Certificate"};
    static final String HTTP_METHOD_GET = "GET";
    static final String HTTP_METHOD_POST = "POST";
    private static final String[] HTTP_METHOD_OPTIONS = new String[]{"GET", "POST"};
    private static final Log log = LogFactory.getLog(RestDataSourceBase.class);
    private static final ObjectMapper mapper = ObjectMapperFactory.buildLowerCaseWithUnderscoresObjectMapper();
    AdapterConfigurationGuiDescriptor guiDescriptor;
    RequiredFieldValidator requiredFieldValidator;
    String baseUrl = "Rest Service Base URL";
    String testConnectionUrl = "Test Connection Endpoint";
    String authServerUrl = "Authorization Server URL";
    String instanceId;
    String testConnectionBody;
    String authOptionSelected;
    String accessToken;
    String authScope;
    String httpMethod;
    String clientId = "Client ID";
    String clientSecret = "Client Secret";
    String httpBasicUserId;
    String httpBasicPassword;
    String secretReferencePassword;
    String secretReferenceClientSecret;
    String clientTlsCertificate;
    RequestConfig requestConfig;
    boolean useHttpsHostnameVerification = true;
    int readTimeoutMillis = 10000;
    int connectionTimeoutMillis = 10000;
    long maxPayloadSize = 1024L;
    boolean retryRequest = true;
    int maxRetriesAttempt = 5;
    int poolingManagerMaxConnections = 32;
    boolean excludeContentTypeInGet = true;
    List<String> errorCodeForRetries = new ArrayList<String>();
    Map<String, String> headerMap = new HashMap<String, String>();
    List<RestDataSourceTagConfig> restDataSourceTagConfigList = new LinkedList<RestDataSourceTagConfig>();

    public RestDataSourceBase() {
        this.guiDescriptor = new AdapterConfigurationGuiDescriptor();
        this.guiDescriptor.addAction(new ActionDescriptor(TEST_CONNECTION__ACTION_FIELD, TEST_CONNECTION_ACTION_DESC, (ActionDescriptor.Action)new TestConnectionValidator(this)));
        this.requiredFieldValidator = new RequiredFieldValidator();
        TextFieldDescriptor textFieldDescriptor = new TextFieldDescriptor("Base URL", BASE_URL_DESC);
        textFieldDescriptor.setHidden(true);
        this.guiDescriptor.addValidator(configuration -> this.baseUrlFieldValidation(configuration, "Base URL"));
        this.guiDescriptor.addField((FieldDescriptor)textFieldDescriptor);
        RadioGroupFieldDescriptor authRadioField = new RadioGroupFieldDescriptor(AUTH_METHOD_FIELD, AUTH_METHOD_DESC, AUTHORIZATION_OPTIONS);
        authRadioField.setDefaultValue(AUTH_OPTION_NONE);
        authRadioField.setDefaultForLegacyConfig(AUTH_OPTION_NONE);
        this.guiDescriptor.addField((FieldDescriptor)authRadioField);
        RadioGroupFieldDescriptor httpMethodField = new RadioGroupFieldDescriptor(HTTP_METHOD, HTTP_METHOD_DESC, HTTP_METHOD_OPTIONS);
        httpMethodField.setDefaultValue(HTTP_METHOD_GET);
        httpMethodField.setDefaultForLegacyConfig(HTTP_METHOD_GET);
        this.guiDescriptor.addField((FieldDescriptor)httpMethodField);
        textFieldDescriptor = new TextFieldDescriptor(HTTP_BASIC_USER_FIELD, HTTP_BASIC_USER_DESC);
        this.guiDescriptor.addValidator(this::basicAuthUsernameRequiredFieldValidation);
        this.guiDescriptor.addField((FieldDescriptor)textFieldDescriptor);
        textFieldDescriptor = new TextFieldDescriptor(HTTP_BASIC_PASSWORD_FIELD, HTTP_BASIC_PASSWORD_DESC, true);
        this.guiDescriptor.addValidator(configuration -> {
            if (AUTH_OPTION_BASIC.equals(configuration.getFieldValue(AUTH_METHOD_FIELD))) {
                String password = configuration.getFieldValue(HTTP_BASIC_PASSWORD_FIELD);
                String secretManagerPassword = configuration.getFieldValue(HTTP_BASIC_PASSWORD_REFERENCE_FIELD);
                if (StringUtils.isBlank((String)password) && StringUtils.isBlank((String)secretManagerPassword)) {
                    throw new ValidationException("Either Password or Password Reference needs to be configured for Basic Authentication.");
                }
                if (StringUtils.isNotBlank((String)password) && StringUtils.isNotBlank((String)secretManagerPassword)) {
                    throw new ValidationException("Password and Password Reference both cannot be configured for Basic Authentication.");
                }
            }
        });
        this.guiDescriptor.addField((FieldDescriptor)textFieldDescriptor);
        textFieldDescriptor = new SecretReferenceFieldDescriptor(HTTP_BASIC_PASSWORD_REFERENCE_FIELD, HTTP_BASIC_PASSWORD_REFERENCE_DESC);
        this.guiDescriptor.addField((FieldDescriptor)textFieldDescriptor);
        textFieldDescriptor = new TextFieldDescriptor(AUTH_SERVER_URL_FIELD, AUTH_SERVER_URL_DESC);
        this.guiDescriptor.addValidator(configuration -> {
            Field authServerUrlField = configuration.getField(AUTH_SERVER_URL_FIELD);
            if (authServerUrlField != null && AUTH_OPTION_OAUTH.equals(configuration.getFieldValue(AUTH_METHOD_FIELD))) {
                RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator();
                requiredFieldValidator.validate(authServerUrlField);
                URLValidator urlValidator = new URLValidator();
                urlValidator.validate(authServerUrlField);
                this.logWarnForHttp().validate(authServerUrlField);
            }
        });
        this.guiDescriptor.addField((FieldDescriptor)textFieldDescriptor);
        textFieldDescriptor = new TextFieldDescriptor(AUTH_SCOPE_FIELD, AUTH_SCOPE_DESC);
        this.guiDescriptor.addField((FieldDescriptor)textFieldDescriptor);
        textFieldDescriptor = new TextFieldDescriptor(CLIENT_ID_FIELD, CLIENT_ID_DESC);
        this.guiDescriptor.addValidator(this::oauthClientIdRequiredFieldValidation);
        this.guiDescriptor.addField((FieldDescriptor)textFieldDescriptor);
        textFieldDescriptor = new TextFieldDescriptor(CLIENT_SECRET_FIELD, CLIENT_SECRET_DESC, true);
        this.guiDescriptor.addValidator(configuration -> {
            if (AUTH_OPTION_OAUTH.equals(configuration.getFieldValue(AUTH_METHOD_FIELD))) {
                String secret = configuration.getFieldValue(CLIENT_SECRET_FIELD);
                String secretManagerPassword = configuration.getFieldValue(CLIENT_SECRET_REFERENCE_FIELD);
                if (StringUtils.isBlank((String)secret) && StringUtils.isBlank((String)secretManagerPassword)) {
                    throw new ValidationException("Either Client Secret or Client Secret Reference needs to be configured for OAuth 2.0 Bearer Token authentication.");
                }
                if (StringUtils.isNotBlank((String)secret) && StringUtils.isNotBlank((String)secretManagerPassword)) {
                    throw new ValidationException("Client Secret and Client Secret Reference both cannot be configured for OAuth 2.0 Bearer Token authentication.");
                }
            }
        });
        this.guiDescriptor.addField((FieldDescriptor)textFieldDescriptor);
        textFieldDescriptor = new SecretReferenceFieldDescriptor(CLIENT_SECRET_REFERENCE_FIELD, CLIENT_SECRET_REFERENCE_DESC);
        this.guiDescriptor.addField((FieldDescriptor)textFieldDescriptor);
        ClientCertKeypairFieldDescriptor certKeypairFieldDescriptor = new ClientCertKeypairFieldDescriptor("Client TLS Certificate", CLIENT_TLS_CERTIFICATE_DESC);
        this.guiDescriptor.addValidator(this::clientTlsCertificateRequiredFieldValidation);
        this.guiDescriptor.addField((FieldDescriptor)certKeypairFieldDescriptor);
        CheckBoxFieldDescriptor httpsHostnameVerificationCheckboxField = new CheckBoxFieldDescriptor(HTTPS_HOSTNAME_VERIFICATION_FIELD, HTTPS_HOSTNAME_VERIFICATION_DESC);
        httpsHostnameVerificationCheckboxField.setDefaultValue(true);
        this.guiDescriptor.addAdvancedField((FieldDescriptor)httpsHostnameVerificationCheckboxField);
        TextFieldDescriptor readTimeOutFieldDescriptor = new TextFieldDescriptor(READ_TIMEOUT_FIELD, READ_TIMEOUT_DESC);
        readTimeOutFieldDescriptor.addValidator((FieldValidator)this.requiredFieldValidator);
        readTimeOutFieldDescriptor.addValidator((FieldValidator & Serializable)readTimeoutField -> this.validateIntegerWithRange(readTimeoutField, -1, Integer.MAX_VALUE));
        readTimeOutFieldDescriptor.setDefaultValue(Integer.toString(this.readTimeoutMillis));
        this.guiDescriptor.addAdvancedField((FieldDescriptor)readTimeOutFieldDescriptor);
        TextFieldDescriptor connectionTimeOutFieldDescriptor = new TextFieldDescriptor(CONNECTION_TIMEOUT_FIELD, CONNECTION_TIMEOUT_DESC);
        connectionTimeOutFieldDescriptor.addValidator((FieldValidator)this.requiredFieldValidator);
        connectionTimeOutFieldDescriptor.setDefaultValue(Integer.toString(this.connectionTimeoutMillis));
        connectionTimeOutFieldDescriptor.addValidator((FieldValidator & Serializable)connectionTimeoutField -> this.validateIntegerWithRange(connectionTimeoutField, -1, Integer.MAX_VALUE));
        this.guiDescriptor.addAdvancedField((FieldDescriptor)connectionTimeOutFieldDescriptor);
        TextFieldDescriptor payloadSizeFieldDescriptor = new TextFieldDescriptor(MAX_PAYLOAD_SIZE_FIELD, MAX_PAYLOAD_SIZE_DESC);
        payloadSizeFieldDescriptor.addValidator((FieldValidator)this.requiredFieldValidator);
        payloadSizeFieldDescriptor.setDefaultValue(Long.toString(this.maxPayloadSize));
        payloadSizeFieldDescriptor.addValidator((FieldValidator & Serializable)payloadSizeField -> this.validateIntegerWithRange(payloadSizeField, 0, Integer.MAX_VALUE));
        this.guiDescriptor.addAdvancedField((FieldDescriptor)payloadSizeFieldDescriptor);
        CheckBoxFieldDescriptor retryCheckboxField = new CheckBoxFieldDescriptor(RETRY_REQUEST_FIELD, RETRY_REQUEST_DESC);
        retryCheckboxField.setDefaultValue(true);
        this.guiDescriptor.addAdvancedField((FieldDescriptor)retryCheckboxField);
        TextFieldDescriptor maxRetriesAttemptField = new TextFieldDescriptor(MAX_RETRIES_ATTEMPT_FIELD, MAX_RETRIES_ATTEMPT_DESC);
        String maxRetriesAttemptStr = Integer.toString(this.maxRetriesAttempt);
        maxRetriesAttemptField.setDefaultValue(maxRetriesAttemptStr);
        maxRetriesAttemptField.setDefaultForLegacyConfig(maxRetriesAttemptStr);
        this.guiDescriptor.addAdvancedField((FieldDescriptor)maxRetriesAttemptField);
        TextFieldDescriptor errorCodeForRetryField = new TextFieldDescriptor(API_FAILURE_CODES_FIELD, API_FAILURE_CODES_DESCR);
        errorCodeForRetryField.setDefaultValue("429");
        this.guiDescriptor.addAdvancedField((FieldDescriptor)errorCodeForRetryField);
        TextFieldDescriptor maxConnectionsFieldDescriptor = new TextFieldDescriptor(POOLING_MANAGER_MAX_CONNECTIONS_FIELD, POOLING_MANAGER_MAX_CONNECTIONS_DESC);
        maxConnectionsFieldDescriptor.setDefaultValue(Integer.toString(this.poolingManagerMaxConnections));
        this.guiDescriptor.addAdvancedField((FieldDescriptor)maxConnectionsFieldDescriptor);
        maxConnectionsFieldDescriptor.addValidator((FieldValidator & Serializable)maxConnectionsField -> this.validateIntegerWithRange(maxConnectionsField, 1, 500));
        textFieldDescriptor = new TextFieldDescriptor(TEST_CONNECTION_URL_FIELD, TEST_CONNECTION_URL_DESC);
        textFieldDescriptor.addValidator((FieldValidator)new URLValidator(), true);
        textFieldDescriptor.addValidator(this.logWarnForHttp());
        this.guiDescriptor.addAdvancedField((FieldDescriptor)textFieldDescriptor);
        TextFieldDescriptor testConnectionBodyTextField = new TextFieldDescriptor(TEST_CONNECTION_BODY_FIELD, TEST_CONNECTION_BODY_DESC);
        this.guiDescriptor.addAdvancedField((FieldDescriptor)testConnectionBodyTextField);
        TableDescriptor baseUrlTagsTableDescriptor = new TableDescriptor(BASE_URL_TAG_TABLE_NAME, BASE_URL_TAG_TABLE_NAME_DESC, true);
        TextFieldDescriptor tableColTextField = new TextFieldDescriptor("Base URL", "");
        tableColTextField.addValidator((FieldValidator)this.requiredFieldValidator);
        tableColTextField.addValidator(this::baseUrlFieldValidation);
        baseUrlTagsTableDescriptor.addRowField((FieldDescriptor)tableColTextField);
        tableColTextField = new TextFieldDescriptor(TAGS_COL_FIELD, "");
        baseUrlTagsTableDescriptor.addRowField((FieldDescriptor)tableColTextField);
        this.guiDescriptor.addAdvancedField((FieldDescriptor)RestDataSourceBase.getCheckBoxFieldDescriptor());
        baseUrlTagsTableDescriptor.addTableValidator((TableValidator)new NoMultipleBlankTagsValidator());
        this.guiDescriptor.addTable(baseUrlTagsTableDescriptor);
        TableDescriptor httpHeaderTableDescriptor = new TableDescriptor(HEADER_TABLE_NAME, HEADER_TABLE_NAME_DESC);
        tableColTextField = new TextFieldDescriptor(HEADER_NAME_COL_FIELD, "");
        tableColTextField.addValidator((FieldValidator)this.requiredFieldValidator);
        httpHeaderTableDescriptor.addRowField((FieldDescriptor)tableColTextField);
        tableColTextField = new TextFieldDescriptor(HEADER_VALUE_COL_FIELD, "");
        tableColTextField.addValidator((FieldValidator)this.requiredFieldValidator);
        httpHeaderTableDescriptor.addRowField((FieldDescriptor)tableColTextField);
        this.guiDescriptor.addTable(httpHeaderTableDescriptor);
        this.guiDescriptor.addValidator(this::baseUrlTagConfigTableValidation);
        this.guiDescriptor.addValidator(this::baseUrlConsistencyValidation);
        this.guiDescriptor.addValidator((ConfigurationValidator)new TableColumnValuesUniqueValidator(BASE_URL_TAG_TABLE_NAME, "Base URL", "Duplicate base URLs are not allowed: "));
        this.guiDescriptor.addValidator((ConfigurationValidator)new TableColumnValuesUniqueValidator(BASE_URL_TAG_TABLE_NAME, TAGS_COL_FIELD, "Duplicate tags are not allowed: "){

            public List<String> processValue(Field field) {
                if (field.getValue() != null) {
                    String[] tagValues = StringUtils.split((String)field.getValue(), (String)" ");
                    return Arrays.asList(tagValues);
                }
                return new ArrayList<String>();
            }
        });
        this.guiDescriptor.addValidator((ConfigurationValidator)new TableColumnValuesUniqueValidator(HEADER_TABLE_NAME, HEADER_NAME_COL_FIELD, "Duplicate request header names are not allowed: "));
        this.guiDescriptor.addValidator(this::validateRetry);
    }

    private static CheckBoxFieldDescriptor getCheckBoxFieldDescriptor() {
        CheckBoxFieldDescriptor excludeContentTypeCheckboxField = new CheckBoxFieldDescriptor(EXCLUDE_CONTENT_TYPE_FROM_GET_CALL, EXCLUDE_CONTENT_TYPE_FROM_GET_CALL_DESC);
        excludeContentTypeCheckboxField.setDefaultValue(true);
        excludeContentTypeCheckboxField.setDefaultForLegacyConfig("false");
        return excludeContentTypeCheckboxField;
    }

    private void basicAuthUsernameRequiredFieldValidation(Configuration configuration) throws ValidationException {
        Field field = configuration.getField(HTTP_BASIC_USER_FIELD);
        if (AUTH_OPTION_BASIC.equals(configuration.getFieldValue(AUTH_METHOD_FIELD))) {
            RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator();
            requiredFieldValidator.validate(field);
        }
    }

    private void oauthClientIdRequiredFieldValidation(Configuration configuration) throws ValidationException {
        Field field = configuration.getField(CLIENT_ID_FIELD);
        if (field != null && AUTH_OPTION_OAUTH.equals(configuration.getFieldValue(AUTH_METHOD_FIELD))) {
            RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator();
            requiredFieldValidator.validate(field);
        }
    }

    private void clientTlsCertificateRequiredFieldValidation(Configuration configuration) throws ValidationException {
        Field field = configuration.getField("Client TLS Certificate");
        if ("Client TLS Certificate".equals(configuration.getFieldValue(AUTH_METHOD_FIELD))) {
            RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator();
            requiredFieldValidator.validate(field);
        }
    }

    void baseUrlFieldValidation(Configuration configuration, String fieldName) throws ValidationException {
        Field field = configuration.getField(fieldName);
        if (field != null) {
            this.baseUrlFieldValidation(field);
        }
    }

    private void baseUrlFieldValidation(Field field) throws ValidationException {
        String fieldValue = field.getValue();
        if (StringUtils.isNotEmpty((String)fieldValue)) {
            URLValidator urlValidator = new URLValidator();
            urlValidator.validate(field);
            FieldValidator logWarnValidator = this.logWarnForHttp();
            logWarnValidator.validate(field);
        }
    }

    public void baseUrlConsistencyValidation(Configuration configuration) throws ValidationException {
        if (configuration != null) {
            boolean hasTagTableRows = Optional.of(configuration).map(conf -> conf.getTable(BASE_URL_TAG_TABLE_NAME)).map(Table::getRows).filter(rows -> !rows.isEmpty()).isPresent();
            if (StringUtils.isNotEmpty((String)configuration.getFieldValue("Base URL")) && hasTagTableRows) {
                throw new ValidationException("Must specify either 'Base URL' field or 'Base URLs and Tags' table, but not both.");
            }
        }
    }

    public void baseUrlTagConfigTableValidation(Configuration configuration) throws ValidationException {
        if (configuration != null && StringUtils.isEmpty((String)configuration.getFieldValue("Base URL"))) {
            this.atLeastOneRow(configuration, BASE_URL_TAG_TABLE_NAME);
        }
    }

    protected void atLeastOneRow(Configuration configuration, String tableName) throws ValidationException {
        Table table = configuration.getTable(tableName);
        if (table.getRows() == null || table.getRows().size() <= 0) {
            throw new ValidationException(tableName + " table must have at least one row.");
        }
    }

    void validateRetry(Configuration config) throws ValidationException {
        boolean isEnableRetry = config.getAdvancedFields().getBooleanFieldValue(RETRY_REQUEST_FIELD);
        if (isEnableRetry) {
            this.validateIntegerWithRange(config.getAdvancedFields().getField(MAX_RETRIES_ATTEMPT_FIELD), 1, Integer.MAX_VALUE);
        }
    }

    void validateIntegerWithRange(Field field, int minValue, int maxValue) throws ValidationException {
        try {
            int tmpInt = Integer.parseInt(field.getValue());
            if (tmpInt < minValue || tmpInt > maxValue) {
                throw new ValidationException("'" + field.getName() + "' is out of range. Please enter an integer between " + minValue + " and " + maxValue + ".");
            }
        }
        catch (NumberFormatException ex) {
            throw new ValidationException("'" + field.getName() + "' is not a valid integer. Please enter an integer between " + minValue + " and " + maxValue + ".");
        }
    }

    RequestResponse doRequest(HttpRequestBase request, String acceptContentType, String authOptionSelected, boolean refreshAccessTokenIfNecessary, boolean applyCustomHeaders, boolean applyPayloadMax, boolean isTestConnection) throws IOException, SecretManagerException {
        ExponentialBackOffCalculator backoffCalculator = new ExponentialBackOffCalculator();
        int retryAttemptNumber = 0;
        request.setConfig(this.requestConfig);
        if (acceptContentType != null) {
            HttpUtil.addContentType(request, acceptContentType);
        }
        HttpUtil.addAdditionalHeaders(request);
        if (applyCustomHeaders) {
            for (Map.Entry<String, String> headerKeyValSet : this.headerMap.entrySet()) {
                String headerValue = headerKeyValSet.getValue();
                if (StringUtils.isNotEmpty((String)headerValue)) {
                    headerValue = new String(headerValue.getBytes(StandardCharsets.US_ASCII), StandardCharsets.US_ASCII);
                }
                request.setHeader(headerKeyValSet.getKey(), headerValue);
            }
        }
        boolean done = false;
        BasicStatusLine statusLine = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 0, "");
        String responseString = null;
        boolean firstAttempt = true;
        while (!done) {
            if (!(firstAttempt || backoffCalculator.shouldRetry() && retryAttemptNumber <= this.maxRetriesAttempt)) {
                log.debug((Object)"Exceeded configured retries number or maximum wait time");
                throw new IOException("Exceeded configured retries number or maximum retries attempt due to rate limiting");
            }
            if (!firstAttempt && backoffCalculator.isBackOffEnforced()) {
                long waitTime = backoffCalculator.calculateRetryDelay();
                log.debug((Object)("Exponential Backoff Algorithm delay enforced to handle rate limiting failures. Sleeping for " + (double)waitTime / 1000.0 + " seconds"));
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {
                    log.error((Object)("An error occurred while waiting for the next retry attempt. Error: " + e1.getMessage()));
                    log.debug((Object)("An error occurred while waiting for the next retry attempt." + e1));
                }
            }
            if (retryAttemptNumber == 0) {
                log.debug((Object)("Sending " + request.getMethod() + " request to " + request.getURI()));
            } else {
                log.debug((Object)("Retrying " + request.getMethod() + " request to " + request.getURI() + " (retry #" + retryAttemptNumber + ")"));
            }
            this.applyAuthentication(request, authOptionSelected);
            CloseableHttpClient client = this.getHttpConnectionPoolingManagerClient(isTestConnection);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create());
            firstAttempt = false;
            responseString = null;
            if (applyPayloadMax) {
                responseString = HttpUtil.toString(response, Consts.UTF_8, this.maxPayloadSize * 1000L);
            } else {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    responseString = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                    EntityUtils.consume((HttpEntity)entity);
                }
            }
            statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            String statusCodeStr = Integer.toString(statusLine.getStatusCode());
            int index = StringUtils.indexOfAny((String)statusCodeStr, (String[])this.errorCodeForRetries.toArray(new String[0]));
            if (index != -1 && this.retryRequest) {
                if (!backoffCalculator.isBackOffEnforced()) {
                    backoffCalculator.enableBackOffEnforcement();
                }
                ++retryAttemptNumber;
            } else if ((statusCode == 401 || statusCode == 403) && AUTH_OPTION_OAUTH.equals(authOptionSelected) && refreshAccessTokenIfNecessary) {
                log.debug((Object)("Service returned " + statusCode + ", refreshing access token"));
                refreshAccessTokenIfNecessary = false;
                this.setAccessToken(true, request);
            } else {
                done = true;
                if (backoffCalculator.isBackOffEnforced()) {
                    backoffCalculator.resetBackOffEnforcement();
                }
            }
            if (!"Client TLS Certificate".equals(authOptionSelected) || !isTestConnection) continue;
            client.close();
        }
        this.logResponseStatus(request, (StatusLine)statusLine, responseString);
        return new RequestResponse(responseString, (StatusLine)statusLine);
    }

    private void applyAuthentication(HttpRequestBase request, String authOptionSelected) throws SecretManagerException, IOException {
        boolean requestHasAuthzHeader;
        boolean bl = requestHasAuthzHeader = request.getFirstHeader("Authorization") != null && StringUtils.isNotBlank((String)request.getFirstHeader("Authorization").getValue());
        if (requestHasAuthzHeader && StringUtils.isNotBlank((String)authOptionSelected)) {
            log.debug((Object)String.format("Overriding '%s=%s' as a dynamic Authorization header is present.", AUTH_METHOD_FIELD, authOptionSelected));
        } else if (AUTH_OPTION_NONE.equals(authOptionSelected)) {
            log.debug((Object)"Using no authentication");
        } else if (AUTH_OPTION_BASIC.equals(authOptionSelected)) {
            log.debug((Object)"Using Basic Authentication");
            String value = "Basic " + this.generateEncodedCredentials(this.httpBasicUserId, this.httpBasicPassword, this.secretReferencePassword);
            request.setHeader("Authorization", value);
        } else if (AUTH_OPTION_OAUTH.equals(authOptionSelected)) {
            log.debug((Object)"Using OAuth 2.0 Bearer Token");
            this.setAccessToken(false, request);
        } else if ("Client TLS Certificate".equals(authOptionSelected)) {
            log.debug((Object)"Using Client TLS Certificate");
        }
    }

    private void logResponseStatus(HttpRequestBase request, StatusLine statusLine, String responseString) {
        int statusCode = statusLine.getStatusCode();
        Response.Status statusCodeFamily = Response.Status.fromStatusCode((int)statusCode);
        if (statusCodeFamily.getFamily() == Response.Status.Family.SERVER_ERROR || statusCodeFamily.getFamily() == Response.Status.Family.CLIENT_ERROR) {
            log.error((Object)(request.getMethod() + " request to " + request.getURI() + " returned status code: " + statusCode + "."));
        } else {
            log.debug((Object)(request.getMethod() + " request to " + request.getURI() + " returned status code: " + statusCode + "."));
        }
        log.trace((Object)("response string:\n" + responseString));
    }

    CloseableHttpClient getHttpConnectionPoolingManagerClient(boolean isTestConnection) {
        if ("Client TLS Certificate".equals(this.authOptionSelected)) {
            try {
                SSLSocketFactory sslSocketFactory = PingCustomSSLSocketFactoryUtil.getSSLSocketFactoryWithSingleKey((String)this.clientTlsCertificate);
                if (isTestConnection) {
                    return HttpConnectionPoolingManager.getInstance().createClient(this.useHttpsHostnameVerification, sslSocketFactory, this.poolingManagerMaxConnections, this.poolingManagerMaxConnections);
                }
                return HttpConnectionPoolingManager.getInstance().getClient(this.instanceId, this.useHttpsHostnameVerification, sslSocketFactory, this.poolingManagerMaxConnections, this.poolingManagerMaxConnections);
            }
            catch (GeneralSecurityException e) {
                throw new ProcessRuntimeException("Unable to create custom SSL Socket Factory with single-key", (Throwable)e);
            }
        }
        return this.useHttpsHostnameVerification ? HttpConnectionPoolingManager.getInstance().getDefaultClient() : HttpConnectionPoolingManager.getInstance().getDefaultClientWithoutHostnameVerification();
    }

    void setAccessToken(boolean refresh, HttpRequestBase request) throws IOException, SecretManagerException {
        if (this.accessToken == null || refresh) {
            log.debug((Object)"Getting new AccessToken");
            this.accessToken = this.retrieveAccessToken();
        }
        if (StringUtils.isNotEmpty((String)this.accessToken)) {
            HttpUtil.setRequestAccessToken(request, this.accessToken);
        }
    }

    String retrieveAccessToken() throws IOException, SecretManagerException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("grant_type", "client_credentials"));
        params.add(new BasicNameValuePair("scope", this.authScope));
        HttpPost post = new HttpPost(this.authServerUrl);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
        post.setEntity((HttpEntity)entity);
        String encoding = this.generateEncodedCredentials(this.clientId, this.clientSecret, this.secretReferenceClientSecret);
        post.addHeader("Authorization", "Basic " + encoding);
        RequestResponse requestResponse = this.doRequest((HttpRequestBase)post, "application/x-www-form-urlencoded", null, false, false, false, false);
        int statusCode = requestResponse.getStatusLine().getStatusCode();
        Response.Status status = Response.Status.fromStatusCode((int)statusCode);
        if (status == null || status.getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new IOException("Unable to retrieve access token from OAuth token endpoint \"" + this.authServerUrl + "\". Returned status code: " + statusCode);
        }
        String response = requestResponse.getResultString();
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)mapper.readValue(response, AccessTokenResponse.class);
        return accessTokenResponse.getAccessToken();
    }

    public void configure(Configuration configuration) {
        this.loadTableData(configuration, HEADER_TABLE_NAME, HEADER_NAME_COL_FIELD, HEADER_VALUE_COL_FIELD, this.headerMap);
        this.instanceId = configuration.getId();
        this.baseUrl = configuration.getFieldValue("Base URL");
        this.loadBaseUrlTagTableData(configuration, this.restDataSourceTagConfigList);
        this.testConnectionUrl = configuration.getFieldValue(TEST_CONNECTION_URL_FIELD);
        this.testConnectionBody = configuration.getFieldValue(TEST_CONNECTION_BODY_FIELD);
        this.authOptionSelected = configuration.getFieldValue(AUTH_METHOD_FIELD);
        this.httpMethod = StringUtils.defaultIfEmpty((String)configuration.getFieldValue(HTTP_METHOD), (String)HTTP_METHOD_GET);
        this.httpBasicUserId = configuration.getFieldValue(HTTP_BASIC_USER_FIELD);
        this.httpBasicPassword = configuration.getFieldValue(HTTP_BASIC_PASSWORD_FIELD);
        this.secretReferencePassword = configuration.getFieldValue(HTTP_BASIC_PASSWORD_REFERENCE_FIELD);
        this.authServerUrl = configuration.getFieldValue(AUTH_SERVER_URL_FIELD);
        this.authScope = configuration.getFieldValue(AUTH_SCOPE_FIELD);
        this.clientId = configuration.getFieldValue(CLIENT_ID_FIELD);
        this.clientSecret = configuration.getFieldValue(CLIENT_SECRET_FIELD);
        this.secretReferenceClientSecret = configuration.getFieldValue(CLIENT_SECRET_REFERENCE_FIELD);
        this.clientTlsCertificate = configuration.getFieldValue("Client TLS Certificate");
        this.useHttpsHostnameVerification = configuration.getBooleanFieldValue(HTTPS_HOSTNAME_VERIFICATION_FIELD);
        this.readTimeoutMillis = configuration.getIntFieldValue(READ_TIMEOUT_FIELD);
        this.maxRetriesAttempt = configuration.getIntFieldValue(MAX_RETRIES_ATTEMPT_FIELD);
        this.retryRequest = configuration.getBooleanFieldValue(RETRY_REQUEST_FIELD);
        this.maxPayloadSize = configuration.getLongFieldValue(MAX_PAYLOAD_SIZE_FIELD);
        this.poolingManagerMaxConnections = configuration.getIntFieldValue(POOLING_MANAGER_MAX_CONNECTIONS_FIELD);
        this.excludeContentTypeInGet = configuration.getBooleanFieldValue(EXCLUDE_CONTENT_TYPE_FROM_GET_CALL);
        this.parseCommaDelimitedString(configuration.getFieldValue(API_FAILURE_CODES_FIELD), this.errorCodeForRetries);
        this.connectionTimeoutMillis = configuration.getIntFieldValue(CONNECTION_TIMEOUT_FIELD);
        this.requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeoutMillis).setConnectionRequestTimeout(this.connectionTimeoutMillis).setSocketTimeout(this.readTimeoutMillis).setStaleConnectionCheckEnabled(false).build();
    }

    public boolean testConnection() {
        try {
            String testUrl = this.getTestConnectionBaseUrl();
            RequestResponse requestResponse = this.doTestConnection(testUrl, this.authOptionSelected);
            log.debug((Object)("Connection test response code: " + requestResponse.getStatusLine().getStatusCode() + ", Status message: " + requestResponse.getStatusLine().getReasonPhrase()));
        }
        catch (Exception e) {
            log.error((Object)"Error while testing connection: ", (Throwable)e);
        }
        return true;
    }

    RequestResponse doTestConnection(String testConnectionURL, String authOptionSelected) throws IOException, SecretManagerException {
        RequestBuilder requestBuilder = RequestBuilder.create((String)this.httpMethod).setUri(testConnectionURL);
        if (StringUtils.isNotBlank((String)this.testConnectionBody)) {
            requestBuilder.setEntity((HttpEntity)new StringEntity(this.testConnectionBody));
        }
        String contentType = "application/json";
        if (this.httpMethod.equals(HTTP_METHOD_GET) && this.excludeContentTypeInGet) {
            contentType = null;
        }
        return this.doRequest((HttpRequestBase)requestBuilder.build(), contentType, authOptionSelected, true, true, true, true);
    }

    void loadTableData(Configuration configuration, String tableName, String keyColName, String valColName, Map<String, String> targetMap) {
        Table customAttrsTable = configuration.getTable(tableName);
        if (customAttrsTable != null && !customAttrsTable.getRows().isEmpty()) {
            for (Row row : customAttrsTable.getRows()) {
                if (row == null) continue;
                String localAttribute = row.getFieldValue(keyColName);
                String path = row.getFieldValue(valColName);
                if (localAttribute == null || localAttribute.isEmpty() || path == null || path.isEmpty()) continue;
                targetMap.put(localAttribute, path);
            }
        }
    }

    void loadBaseUrlTagTableData(Configuration configuration, List<RestDataSourceTagConfig> restDataSourceTagConfigList) {
        Table customAttrsTable = configuration.getTable(BASE_URL_TAG_TABLE_NAME);
        if (customAttrsTable != null && !customAttrsTable.getRows().isEmpty()) {
            for (Row row : customAttrsTable.getRows()) {
                if (row == null) continue;
                String baseUrl = row.getFieldValue("Base URL");
                RestDataSourceInstanceIdentifier identifier = new RestDataSourceInstanceIdentifier(baseUrl);
                String tags = row.getFieldValue(TAGS_COL_FIELD);
                restDataSourceTagConfigList.add(new RestDataSourceTagConfig(identifier, tags, row.isDefaultRow()));
            }
        }
    }

    private void parseCommaDelimitedString(String commaDelimeitedString, List<String> populateThisList) {
        populateThisList.clear();
        if (commaDelimeitedString != null && !commaDelimeitedString.isEmpty()) {
            String[] errorCodeArr;
            for (String errorCode : errorCodeArr = commaDelimeitedString.split(",")) {
                populateThisList.add(errorCode.trim());
            }
        }
    }

    String removeSubstitutionVar(String fieldString) {
        if (fieldString == null) {
            return null;
        }
        return fieldString.replaceAll("\\$\\{.*?\\}", "");
    }

    private FieldValidator logWarnForHttp() {
        return (FieldValidator & Serializable)field -> {
            try {
                URL url = new URL(field.getValue());
                if ("http".equalsIgnoreCase(url.getProtocol())) {
                    log.warn((Object)("'" + field.getLabel() + "' field for REST Data Store is configured with a protocol that does not secure data at the transport level. Consider using transport level security (for example HTTPS) to ensure confidentiality of the data in transit."));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        };
    }

    String resolveBaseUrl() {
        RestDataSourceInstanceIdentifier dataSourceIdentifier;
        if (!this.restDataSourceTagConfigList.isEmpty() && (dataSourceIdentifier = (RestDataSourceInstanceIdentifier)DataSourceTagUtil.findMatchingDataSource(this.restDataSourceTagConfigList, (List)ClusterAccessor.getNodeTags())) != null) {
            return dataSourceIdentifier.getBaseUrl();
        }
        return this.baseUrl;
    }

    private String getTestConnectionBaseUrl() {
        String baseUrlToUse = this.resolveBaseUrl();
        return StringUtils.isNotEmpty((String)this.testConnectionUrl) ? this.testConnectionUrl : baseUrlToUse;
    }

    private String generateEncodedCredentials(String username, String password, String secretReference) throws SecretManagerException {
        if (StringUtils.isNotBlank((String)secretReference)) {
            SecretReferenceHelper secretReferenceHelper = new SecretReferenceHelper(secretReference);
            SecretReferenceHelper.Credentials credentials = secretReferenceHelper.getSecretInfo(username);
            username = credentials.getUsername();
            password = credentials.getSecret();
        }
        return new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    static class NoMultipleBlankTagsValidator
    implements TableValidator {
        NoMultipleBlankTagsValidator() {
        }

        public void validate(Table table) throws ValidationException {
            if (table.getRows().stream().map(row -> row.getFieldValue(RestDataSourceBase.TAGS_COL_FIELD)).filter(String::isEmpty).count() > 1L) {
                throw new ValidationException(String.format("Multiple '%s' rows with no '%s' is not allowed.", "Base URL", RestDataSourceBase.TAGS_COL_FIELD));
            }
        }
    }

    private class TestConnectionValidator
    implements ActionDescriptor.Action {
        CustomDataSourceDriver dataSourceDriver;

        TestConnectionValidator(CustomDataSourceDriver dataSourceDriver) {
            this.dataSourceDriver = dataSourceDriver;
        }

        public String actionInvoked(Configuration configuration) {
            Object actionResult;
            log.debug((Object)"Action invoked to test connection");
            RestDataSourceBase.this.configure(configuration);
            String testUrl = RestDataSourceBase.this.getTestConnectionBaseUrl();
            try {
                AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.DATA_STORE, (AdminAuditLogger.Event)AdminAuditLogger.Event.TEST_CONNECTION, (String)("Test connection to REST data source URL: " + testUrl));
                RequestResponse response = RestDataSourceBase.this.doTestConnection(testUrl, RestDataSourceBase.this.authOptionSelected);
                actionResult = "The connection test HTTP " + RestDataSourceBase.this.httpMethod + " request to the data store returned the following response: " + Util.LINE_BREAK + Util.LINE_BREAK + "Response code: " + response.getStatusLine().getStatusCode() + Util.LINE_BREAK + "Status message: " + response.getStatusLine().getReasonPhrase() + Util.LINE_BREAK + Util.LINE_BREAK + "The server log may contain additional details about this test.";
            }
            catch (SecretManagerException e) {
                actionResult = "An error occurred while retrieving credentials from secret manager.";
            }
            catch (IOException e) {
                log.error((Object)("An error occurred while testing the connection. Error: " + e.getMessage()));
                actionResult = "An error occurred while testing the connection. Check server log for more details.";
            }
            return actionResult;
        }
    }
}

