/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.datastore.other;

import com.fasterxml.jackson.core.JsonPointer;
import com.pingidentity.pf.datastore.other.RequestResponse;
import com.pingidentity.pf.datastore.other.RestDataSourceBase;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sources.ConfigurableDriver;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.CustomDataSourceDriverException;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.sources.gui.FilterFieldsGuiDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.json.simple.JSONValue;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextAreaFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.TableColumnValuesUniqueValidator;
import org.sourceid.util.JsonPointerExpressionEvaluator;

public class RestDataSourceDriver
extends RestDataSourceBase {
    static final String ATTRIBUTES_TABLE_NAME = "Attributes";
    static final String ATTRIBUTES_TABLE_NAME_DESC = "Define attributes to expose from this data source. Each named attribute must include a path using JSON Pointer syntax (RFC 6901) from where it is retrieved in the response of the REST API. For example, a JSON Response Attribute Path of /age will return the value of a top-level JSON key called \"age\". Click 'Add a new row ...' to add multiple entries.";
    static final String ATTRIBUTES_TABLE_LOCAL_ATTR_FIELD = "Local Attribute";
    static final String ATTRIBUTES_TABLE_NAME_LOCAL_ATTR_DESC = "";
    static final String ATTRIBUTES_TABLE_REMOTE_ATTR_FIELD = "JSON Response Attribute Path";
    static final String ATTRIBUTES_TABLE_REMOTE_ATTR_DESC = "";
    static final String FILTER_DESC = "Populate filtering configuration";
    static final String FILTER_AUTHORIZATION_FIELD = "Authorization Header";
    static final String FILTER_AUTHORIZATION_DESC = "Optionally specify the bearer token to be used in an Authorization header that was received from earlier in the authentication flow (like in an OIDC IdP connection). For example, to use the access token from a Google OIDC IdP Connection specify \"Bearer ${idp.https://accounts.google.com.access_token}\"";
    static final String FILTER_PATH_FIELD = "Resource Path";
    static final String FILTER_PATH_DESC = "Optionally define the resource path appended to the base URL of the REST API data store. Relative URL paths, query strings and references to attributes in context of the transaction can be used to query for specific resources. For example, /users?uid=${username} could be used to request a user object by username.";
    static final String FILTER_BODY_FIELD = "Body";
    static final String FILTER_BODY_DESC = "Optionally define the body sent on a GET or POST request to the REST API data store. The body should match the Content-Type header specified in the data store. For example, {\"login\":\"${username}\",\"department\":\"${departmentNumber}\"} could be used for a GET or POST JSON request.";
    private static final Log log = LogFactory.getLog(RestDataSourceDriver.class);
    private final CustomDataSourceDriverDescriptor sourceDescriptor;
    private final FilterFieldsGuiDescriptor filterFieldsDescriptor;
    private final Map<String, String> customAttributesTable = new HashMap<String, String>();

    public RestDataSourceDriver() {
        TableDescriptor jsonResponseAttributeMappingTable = new TableDescriptor(ATTRIBUTES_TABLE_NAME, ATTRIBUTES_TABLE_NAME_DESC);
        TextFieldDescriptor customAttributeLocalAttributeNameField = new TextFieldDescriptor(ATTRIBUTES_TABLE_LOCAL_ATTR_FIELD, "");
        customAttributeLocalAttributeNameField.addValidator((FieldValidator)this.requiredFieldValidator);
        jsonResponseAttributeMappingTable.addRowField((FieldDescriptor)customAttributeLocalAttributeNameField);
        TextFieldDescriptor customAttributeRemoteAttributePathField = new TextFieldDescriptor(ATTRIBUTES_TABLE_REMOTE_ATTR_FIELD, "");
        customAttributeRemoteAttributePathField.addValidator((FieldValidator)this.requiredFieldValidator);
        jsonResponseAttributeMappingTable.addRowField((FieldDescriptor)customAttributeRemoteAttributePathField);
        jsonResponseAttributeMappingTable.addValidator(fieldsInRow -> {
            String path = fieldsInRow.getFieldValue(ATTRIBUTES_TABLE_REMOTE_ATTR_FIELD);
            try {
                JsonPointer.compile((String)path);
            }
            catch (IllegalArgumentException ex) {
                throw new ValidationException("Enter valid format for remote path.\nError: " + ex.getMessage());
            }
        });
        this.guiDescriptor.addTable(jsonResponseAttributeMappingTable);
        this.guiDescriptor.addValidator(configuration -> this.atLeastOneRow(configuration, ATTRIBUTES_TABLE_NAME));
        this.guiDescriptor.addValidator((ConfigurationValidator)new TableColumnValuesUniqueValidator(ATTRIBUTES_TABLE_NAME, ATTRIBUTES_TABLE_LOCAL_ATTR_FIELD, "Duplicate local attributes names are not allowed: "));
        this.filterFieldsDescriptor = new FilterFieldsGuiDescriptor(FILTER_DESC);
        TextFieldDescriptor pathParamField = new TextFieldDescriptor(FILTER_PATH_FIELD, FILTER_PATH_DESC);
        pathParamField.addValidator((FieldValidator & Serializable)field -> {
            String filterPathField;
            String string = filterPathField = field != null ? field.getValue() : null;
            if (StringUtils.isNotEmpty((String)filterPathField)) {
                String exampleBaseUrl = "https://example.base.url";
                String fullURI = "https://example.base.url" + filterPathField;
                if (!ValidationUtil.isValidUrl((String)this.removeSubstitutionVar(fullURI))) {
                    throw new ValidationException("'Resource Path' is not a valid path when appended to a base URL.");
                }
            }
        });
        this.filterFieldsDescriptor.addField((FieldDescriptor)pathParamField);
        TextFieldDescriptor authzHeaderField = new TextFieldDescriptor(FILTER_AUTHORIZATION_FIELD, FILTER_AUTHORIZATION_DESC);
        this.filterFieldsDescriptor.addField((FieldDescriptor)authzHeaderField);
        TextAreaFieldDescriptor bodyTextAreaField = new TextAreaFieldDescriptor(FILTER_BODY_FIELD, FILTER_BODY_DESC, 10, 33);
        this.filterFieldsDescriptor.addField((FieldDescriptor)bodyTextAreaField);
        this.sourceDescriptor = new CustomDataSourceDriverDescriptor((ConfigurableDriver)this, "REST API", this.guiDescriptor, this.filterFieldsDescriptor, false, this.getGuiConfigDescriptorBuilder());
        this.sourceDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public Map<String, Object> retrieveValues(Collection<String> attributeNamesToFill, SimpleFieldList filterConfiguration) throws CustomDataSourceDriverException {
        String response;
        HashMap<String, Object> results = new HashMap<String, Object>();
        String resourcePath = filterConfiguration.getFieldValue(FILTER_PATH_FIELD);
        Object url = this.resolveBaseUrl() + resourcePath;
        url = ((String)url).replace("+", "%20");
        String accessToken = filterConfiguration.getFieldValue(FILTER_AUTHORIZATION_FIELD);
        try {
            HttpRequestBase httpRequestBase = this.buildRequestBase(filterConfiguration, (String)url);
            if (accessToken != null) {
                httpRequestBase.addHeader("Authorization", accessToken);
            }
            String contentType = "application/json";
            if (this.httpMethod.equals("GET") && this.excludeContentTypeInGet) {
                contentType = null;
            }
            RequestResponse requestResponse = this.doRequest(httpRequestBase, contentType, this.authOptionSelected, true, true, true, false);
            response = requestResponse.getResultString();
        }
        catch (IOException e) {
            throw new CustomDataSourceDriverException("Error while retrieving information from driver", (Throwable)e);
        }
        catch (SecretManagerException e) {
            throw new CustomDataSourceDriverException("Error while retrieving credentials for driver", (Throwable)e);
        }
        for (String localAttributeName : attributeNamesToFill) {
            String path = this.customAttributesTable.get(localAttributeName);
            Object attributeValue = JsonPointerExpressionEvaluator.evaluateJsonPointer((String)response, (String)path);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Assigning local attribute:" + localAttributeName + " value: " + attributeValue));
            }
            if (attributeValue == null) continue;
            results.put(localAttributeName, attributeValue);
        }
        Map convertedMap = JsonPointerExpressionEvaluator.convertToMapOfAttributeValues(results);
        return JsonPointerExpressionEvaluator.convertToObjectMap((Map)convertedMap);
    }

    private HttpRequestBase buildRequestBase(SimpleFieldList filterConfiguration, String uri) throws UnsupportedEncodingException {
        String body = filterConfiguration.getFieldValue(FILTER_BODY_FIELD);
        StringEntity entity = null;
        if (StringUtils.isNotBlank((String)body)) {
            body = StringUtils.trim((String)body);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("HTTP Request Body: '%s'", body));
            }
            entity = new StringEntity(body);
        }
        return (HttpRequestBase)RequestBuilder.create((String)this.httpMethod).setUri(uri).setEntity(entity).build();
    }

    public List<String> getAvailableFields() {
        return new ArrayList<String>(this.customAttributesTable.keySet());
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.loadTableData(configuration, ATTRIBUTES_TABLE_NAME, ATTRIBUTES_TABLE_LOCAL_ATTR_FIELD, ATTRIBUTES_TABLE_REMOTE_ATTR_FIELD, this.customAttributesTable);
    }

    public SourceDescriptor getSourceDescriptor() {
        return this.sourceDescriptor;
    }

    public String encodeFilterFieldParam(String filterFieldName, String paramToEncode) {
        String contentTypeKey = this.getContentTypeKey();
        if (StringUtils.isNotBlank((String)contentTypeKey)) {
            MediaType type = MediaType.valueOf((String)((String)this.headerMap.get(contentTypeKey)));
            if (FILTER_BODY_FIELD.equals(filterFieldName) && MediaType.APPLICATION_JSON_TYPE.equals((Object)type)) {
                return JSONValue.escape((String)paramToEncode);
            }
        }
        try {
            return URLEncoder.encode(paramToEncode, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)("Unable to encode parameter for filter field: " + filterFieldName));
            return null;
        }
    }

    private String getContentTypeKey() {
        String contentTypeHeaderName = null;
        Set headerNames = this.headerMap.keySet();
        for (String headerName : headerNames) {
            if (!"content-type".equalsIgnoreCase(headerName)) continue;
            contentTypeHeaderName = headerName;
            break;
        }
        return contentTypeHeaderName;
    }

    private GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
        return new GuiConfigDescriptorBuilder(){

            public GuiConfigDescriptor buildNewGuiDescriptor() {
                return RestDataSourceDriver.this.guiDescriptor;
            }

            public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
                if (StringUtils.isNotEmpty((String)configuration.getFieldValue("Base URL"))) {
                    List fieldDescriptorList = RestDataSourceDriver.this.guiDescriptor.getFields();
                    fieldDescriptorList.parallelStream().filter(fieldDescriptor -> "Base URL".equals(fieldDescriptor.getName())).findFirst().ifPresent(baseUrlField -> baseUrlField.setHidden(false));
                }
                return RestDataSourceDriver.this.guiDescriptor;
            }
        };
    }
}

