/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.datastore.other.util;

import com.pingidentity.crypto.SecurityProviderUtil;
import java.security.SecureRandom;

public class ExponentialBackOffCalculator {
    private static final double DELAY_IN_MILLIS = 1000.0;
    private static final double MULTIPLIER = 2.0;
    private static final long MAX_DELAY = 60000L;
    private boolean backOffEnforced = false;
    private int retryAttemptNumber = 0;

    public boolean isBackOffEnforced() {
        return this.backOffEnforced;
    }

    public void resetBackOffEnforcement() {
        this.backOffEnforced = false;
        this.retryAttemptNumber = 0;
    }

    public void enableBackOffEnforcement() {
        this.backOffEnforced = true;
        this.retryAttemptNumber = 0;
    }

    public long calculateRetryDelay() {
        SecureRandom randomGenerator = SecurityProviderUtil.getSecureRandom();
        long delay = (long)(Math.pow(2.0, this.retryAttemptNumber) * 1000.0 + (double)randomGenerator.nextInt(1001));
        ++this.retryAttemptNumber;
        return delay;
    }

    public boolean shouldRetry() {
        SecureRandom randomGenerator = SecurityProviderUtil.getSecureRandom();
        long delay = (long)(Math.pow(2.0, this.retryAttemptNumber) * 1000.0 + (double)randomGenerator.nextInt(1001));
        boolean exceedMaxWaitTime = delay > 60000L;
        return !exceedMaxWaitTime;
    }
}

