/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.datastore.other.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DecimalFormat;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;

public class HttpUtil {
    private static DecimalFormat decimalFormat = new DecimalFormat("#,##0");

    public static void addContentType(HttpRequestBase request, String contentType) {
        request.setHeader("Content-Type", contentType);
    }

    public static void setRequestAccessToken(HttpRequestBase request, String accessToken) {
        request.setHeader("Authorization", "Bearer " + accessToken);
    }

    public static void addAdditionalHeaders(HttpRequestBase request) {
        request.setHeader("Connection", "Keep-Alive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(CloseableHttpResponse response, Charset defaultCharset, long maxContentSize) throws IOException, ParseException {
        if (response == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        Args.notNull((Object)entity, (String)"Entity");
        InputStream instream = entity.getContent();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (instream == null) {
            return null;
        }
        long contentBytesRead = 0L;
        try {
            int bytesRead;
            Charset charset;
            block14: {
                Args.check((entity.getContentLength() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"HTTP entity too large to be buffered in memory");
                charset = null;
                try {
                    ContentType contentType = ContentType.get((HttpEntity)entity);
                    if (contentType != null) {
                        charset = contentType.getCharset();
                    }
                }
                catch (UnsupportedCharsetException ex) {
                    if (defaultCharset != null) break block14;
                    throw new UnsupportedEncodingException(ex.getMessage());
                }
            }
            if (charset == null) {
                charset = defaultCharset;
            }
            if (charset == null) {
                charset = HTTP.DEF_CONTENT_CHARSET;
            }
            byte[] buffer = new byte[1024];
            while ((bytesRead = instream.read(buffer)) != -1 && HttpUtil.withinMaxPayloadSizeLimit(maxContentSize, contentBytesRead)) {
                outputStream.write(buffer, 0, bytesRead);
                contentBytesRead += (long)bytesRead;
            }
            if (!HttpUtil.withinMaxPayloadSizeLimit(maxContentSize, contentBytesRead)) {
                throw new IOException("Content size maximum of " + decimalFormat.format(maxContentSize / 1000L) + " kb reached.");
            }
            String string = outputStream.toString(charset.name());
            return string;
        }
        finally {
            if (!HttpUtil.withinMaxPayloadSizeLimit(maxContentSize, contentBytesRead)) {
                response.close();
            } else {
                instream.close();
            }
            outputStream.close();
        }
    }

    static boolean withinMaxPayloadSizeLimit(long maxContentSize, long contentBytesRead) {
        return maxContentSize <= 0L || contentBytesRead < maxContentSize;
    }
}

