/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.secretmanagers.cyberark;

import com.pingidentity.pf.secretmanagers.cyberark.PasswordRequest;
import com.pingidentity.sdk.secretmanager.SecretInfo;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javapasswordsdk.CyberArkGetPassword;
import javapasswordsdk.PSDKPassword;
import javapasswordsdk.PSDKPasswordRequest;
import javapasswordsdk.PasswordSDK;
import javapasswordsdk.exceptions.PSDKException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.util.log.AttributeMap;

@CyberArkGetPassword
public final class CyberArkCredentialProviderHelper {
    private static final Log LOG;
    private static boolean isDisposeMethodPresent;
    private static boolean isGetSecureContentPresent;
    static final String USERNAME_NOT_RETURNED_MSG = "Requested username account property was not returned.";
    static final String PASSWORD_CHANGE_IN_PROGRESS_MSG = "Password change is in progress for: %s.";
    static final String ERROR_RETRIEVING_PASSWORD_MSG = "Error occurred while retrieving the password.";
    static final String ERROR_RETRIEVING_USERNAME_MSG = "Error occurred while retrieving the username.";
    static final String PROPERTY_NAME_PREFIX = "PassProps.";

    public static SecretInfo getPassword(PasswordRequest passwordRequest, String usernameRetrievalPropertyName) throws SecretManagerException {
        SecretInfo secretInfo;
        block25: {
            PSDKPassword password;
            block24: {
                AttributeMap attributes;
                char[] content;
                block21: {
                    block23: {
                        block22: {
                            password = null;
                            content = null;
                            password = PasswordSDK.getPassword((PSDKPasswordRequest)passwordRequest.getPsdkPasswordRequest());
                            if ("true".equals(password.getAttribute("PasswordChangeInProcess")) && LOG.isDebugEnabled()) {
                                LOG.debug((Object)String.format(PASSWORD_CHANGE_IN_PROGRESS_MSG, passwordRequest.getSecretReference()));
                            }
                            attributes = new AttributeMap();
                            if (passwordRequest.getRetrieveUsernameAccountProperty()) {
                                String username = CyberArkCredentialProviderHelper.getUsername(password, usernameRetrievalPropertyName);
                                if (StringUtils.isEmpty((String)username)) {
                                    throw new SecretManagerException(USERNAME_NOT_RETURNED_MSG);
                                }
                                attributes.put("Username", username);
                            }
                            if (!isGetSecureContentPresent) break block21;
                            content = password.getSecureContent();
                            secretInfo = new SecretInfo(new String(content), attributes);
                            if (content == null) break block22;
                            Arrays.fill(content, '\u0000');
                        }
                        if (password != null) {
                            try {
                                if (isDisposeMethodPresent) {
                                    password.dispose();
                                }
                            }
                            catch (PSDKException e) {
                                if (!LOG.isDebugEnabled()) break block23;
                                LOG.debug((Object)"Error occurred while disposing PSDKPassword object", (Throwable)e);
                            }
                        }
                    }
                    return secretInfo;
                }
                try {
                    secretInfo = new SecretInfo(password.getContent(), attributes);
                    if (content == null) break block24;
                }
                catch (PSDKException e) {
                    try {
                        throw new SecretManagerException(String.format("%s: %s", ERROR_RETRIEVING_PASSWORD_MSG, e.getMessage()), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        block26: {
                            if (content != null) {
                                Arrays.fill(content, '\u0000');
                            }
                            if (password != null) {
                                try {
                                    if (isDisposeMethodPresent) {
                                        password.dispose();
                                    }
                                }
                                catch (PSDKException e2) {
                                    if (!LOG.isDebugEnabled()) break block26;
                                    LOG.debug((Object)"Error occurred while disposing PSDKPassword object", (Throwable)e2);
                                }
                            }
                        }
                        throw throwable;
                    }
                }
                Arrays.fill(content, '\u0000');
            }
            if (password != null) {
                try {
                    if (isDisposeMethodPresent) {
                        password.dispose();
                    }
                }
                catch (PSDKException e) {
                    if (!LOG.isDebugEnabled()) break block25;
                    LOG.debug((Object)"Error occurred while disposing PSDKPassword object", (Throwable)e);
                }
            }
        }
        return secretInfo;
    }

    private static String getUsername(PSDKPassword password, String usernameRetrievalPropertyName) throws SecretManagerException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving username from '" + usernameRetrievalPropertyName + "' property"));
        }
        try {
            return password.getAttribute(PROPERTY_NAME_PREFIX + usernameRetrievalPropertyName);
        }
        catch (PSDKException e) {
            throw new SecretManagerException(String.format("%s: %s", ERROR_RETRIEVING_USERNAME_MSG, e.getMessage()), (Throwable)e);
        }
    }

    static {
        Method[] methods;
        LOG = LogFactory.getLog(CyberArkCredentialProviderHelper.class);
        isDisposeMethodPresent = false;
        isGetSecureContentPresent = false;
        for (Method method : methods = PSDKPassword.class.getMethods()) {
            if ("dispose".equals(method.getName())) {
                isDisposeMethodPresent = true;
            }
            if (!"getSecureContent".equals(method.getName())) continue;
            isGetSecureContentPresent = true;
        }
    }
}

