/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.selectors.cidr;

import com.pingidentity.common.util.HostAddressUtils;
import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.utils.cidr.CIDRUtils;
import java.lang.invoke.CallSite;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class CIDRAdapterSelector
implements AuthenticationSelector,
AuthnApiPlugin {
    private final Log log = LogFactory.getLog(CIDRAdapterSelector.class);
    private final AuthenticationSelectorDescriptor authnSelectorDescriptor;
    private List<CIDRUtils> networkCheckers = new ArrayList<CIDRUtils>();
    private String attributeName;
    static final String YES = "Yes";
    static final String NO = "No";
    private static final String NETWORKS_TABLE_NAME = "Networks";
    private static final String NETWORK_FIELD_NAME = "Network Range (CIDR notation)";
    private static final String NETWORK_DESCRIPTION_FIELD_NAME = "Description";
    private static final String RESULT_ATTR_NAME = "Result Attribute Name";
    private static final String DESCRIPTION = "This authentication selector chooses an authentication source at runtime based on a match found in the specified HTTP Header.";

    public CIDRAdapterSelector() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.setDescription(DESCRIPTION);
        TextFieldDescriptor networkCIDR = new TextFieldDescriptor(NETWORK_FIELD_NAME, "A valid network range in CIDR notation");
        networkCIDR.addValidator(new FieldValidator(){

            public void validate(Field field) throws ValidationException {
                try {
                    new CIDRUtils(field.getValue());
                }
                catch (IllegalArgumentException | UnknownHostException ex) {
                    throw new ValidationException("Invalid network range.  Please verify that the network range is defined using CIDR notation. For example, 192.168.0.1/24.");
                }
            }
        });
        TextFieldDescriptor networkCIDRDescription = new TextFieldDescriptor(NETWORK_DESCRIPTION_FIELD_NAME, "A description to help identify the network range");
        TableDescriptor networks = new TableDescriptor(NETWORKS_TABLE_NAME, "A table of valid networks");
        networks.addRowField((FieldDescriptor)networkCIDR);
        networks.addRowField((FieldDescriptor)networkCIDRDescription);
        guiConfigDescriptor.addTable(networks);
        guiConfigDescriptor.addField((FieldDescriptor)new TextFieldDescriptor(RESULT_ATTR_NAME, "Indicates (when specified) the attribute name in which to store the authentication selector result value."));
        guiConfigDescriptor.addValidator(new ConfigurationValidator(){

            public void validate(Configuration configuration) throws ValidationException {
                Table table = configuration.getTable(CIDRAdapterSelector.NETWORKS_TABLE_NAME);
                List rows = table.getRows();
                if (rows.isEmpty()) {
                    throw new ValidationException("Please add at least one network to the 'Networks' table.");
                }
                ArrayList<CallSite> errors = new ArrayList<CallSite>();
                HashSet<String> networks = new HashSet<String>();
                for (Row row : rows) {
                    String network = row.getFieldValue(CIDRAdapterSelector.NETWORK_FIELD_NAME);
                    if (networks.add(network)) continue;
                    errors.add((CallSite)((Object)("Duplicate network: " + network)));
                }
                if (!errors.isEmpty()) {
                    throw new ValidationException(errors);
                }
            }
        });
        HashSet<String> results = new HashSet<String>();
        results.add(YES);
        results.add(NO);
        this.authnSelectorDescriptor = new AuthenticationSelectorDescriptor("CIDR Authentication Selector", (ConfigurablePlugin)this, guiConfigDescriptor, results, VersionUtil.getVersion());
        this.authnSelectorDescriptor.setSupportsExtendedResults(false);
        this.authnSelectorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public void configure(Configuration configuration) {
        Table networks = configuration.getTable(NETWORKS_TABLE_NAME);
        for (Row network : networks.getRows()) {
            try {
                CIDRUtils cidrUtils = new CIDRUtils(network.getFieldValue(NETWORK_FIELD_NAME));
                this.networkCheckers.add(cidrUtils);
            }
            catch (UnknownHostException unknownHostException) {}
        }
        this.attributeName = configuration.getFieldValue(RESULT_ATTR_NAME);
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.authnSelectorDescriptor;
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse res, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        String remoteAddr = req.getRemoteAddr();
        if (remoteAddr != null) {
            this.log.debug((Object)("Using client address " + remoteAddr));
        }
        return this.getContext(remoteAddr);
    }

    AuthenticationSelectorContext getContext(String remoteAddr) {
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        context.setResult(NO);
        for (CIDRUtils networkChecker : this.networkCheckers) {
            try {
                if (!networkChecker.isInRange(HostAddressUtils.getIpAddress((String)remoteAddr))) continue;
                context.setResult(YES);
                this.log.debug((Object)(remoteAddr + " is within range " + networkChecker));
                break;
            }
            catch (UnknownHostException e) {
                this.log.info((Object)("Invalid address value: " + remoteAddr));
                this.log.debug((Object)e);
            }
        }
        return context;
    }

    public void callback(HttpServletRequest req, HttpServletResponse res, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
        if (StringUtils.isNotBlank((String)this.attributeName) && !authnIdentifiers.containsKey(this.attributeName)) {
            boolean anyAttributeValues = false;
            for (Object value : authnIdentifiers.values()) {
                anyAttributeValues |= value instanceof AttributeValue;
            }
            Object attr = anyAttributeValues ? new AttributeValue(authnSelectorContext.getResult()) : authnSelectorContext.getResult();
            authnIdentifiers.put(this.attributeName, attr);
            this.log.debug((Object)("Attribute '" + this.attributeName + "added with value '" + authnSelectorContext.getResult()));
        }
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    void setNetworkCheckers(List<CIDRUtils> networkCheckers) {
        this.networkCheckers = networkCheckers;
    }
}

