/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.selectors.connectionset;

import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.ConnectionSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;

public class ConnectionSetAdapterSelector
implements AuthenticationSelector,
GuiConfigDescriptorBuilder,
AuthnApiPlugin {
    private final Log log = LogFactory.getLog(ConnectionSetAdapterSelector.class);
    private static final String YES_RESULT = "Yes";
    private static final String NO_RESULT = "No";
    private static final String SELECTOR_DESCRIPTOR_NAME = "Connection Set Authentication Selector";
    private static final String SELECTOR_DESCRIPTION = "This authentication selector chooses authentication sources at runtime based on a match found between the SP Connection used for the SSO request and SP Connections configured in the system.";
    private static final String CONNECTIONS_TABLE_NAME = "Connections";
    private static final String CONNECTIONS_TABLE_DESC = "A table of connections";
    private static final String CONNECTION_FIELD_NAME = "Connection";
    private static final String CONNECTION_FIELD_DESC = "Select from the list of service provider connections";
    private final AuthenticationSelectorDescriptor authenticationSelectorDescriptor;
    private final Set<String> selectedConnectionSet = new LinkedHashSet<String>();

    public ConnectionSetAdapterSelector() {
        this.authenticationSelectorDescriptor = new AuthenticationSelectorDescriptor(SELECTOR_DESCRIPTOR_NAME, (ConfigurablePlugin)this, (GuiConfigDescriptorBuilder)this, new HashSet<String>(Arrays.asList(YES_RESULT, NO_RESULT)), VersionUtil.getVersion());
        this.authenticationSelectorDescriptor.setSupportsExtendedResults(false);
        this.authenticationSelectorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse res, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        String connectionId;
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        context.setResult(NO_RESULT);
        if (extraParameters.containsKey("com.pingidentity.sdk.AdapterSelector.entityid") && this.selectedConnectionSet.contains(connectionId = extraParameters.get("com.pingidentity.sdk.AdapterSelector.entityid").toString())) {
            this.log.debug((Object)("Found connection: " + connectionId));
            context.setResult(YES_RESULT);
        }
        return context;
    }

    public void callback(HttpServletRequest req, HttpServletResponse res, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
    }

    public void configure(Configuration configuration) {
        Table connectionsTable = configuration.getTable(CONNECTIONS_TABLE_NAME);
        connectionsTable.getRows().forEach(row -> this.selectedConnectionSet.add(row.getFieldValue(CONNECTION_FIELD_NAME)));
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.authenticationSelectorDescriptor;
    }

    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration config) {
        return this.buildGuiDescriptor();
    }

    public GuiConfigDescriptor buildNewGuiDescriptor() {
        return this.buildGuiDescriptor();
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    private GuiConfigDescriptor buildGuiDescriptor() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.addValidator((ConfigurationValidator)new ConnectionSetAdapterConfigurationValidator());
        guiConfigDescriptor.addTable(this.buildTableDescriptor());
        guiConfigDescriptor.setDescription(SELECTOR_DESCRIPTION);
        return guiConfigDescriptor;
    }

    private TableDescriptor buildTableDescriptor() {
        TableDescriptor tableDescriptor = new TableDescriptor(CONNECTIONS_TABLE_NAME, CONNECTIONS_TABLE_DESC);
        CustomConnectionSelectionFieldDescriptor filterableSelectionFieldDescriptor = new CustomConnectionSelectionFieldDescriptor(CONNECTION_FIELD_NAME, CONNECTION_FIELD_DESC, ConnectionSelectionFieldDescriptor.ConnectionType.SP_CONNECTION);
        filterableSelectionFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        filterableSelectionFieldDescriptor.addValidator((FieldValidator)new FilterableSelectionFieldDescriptor.FilterableSelectionFieldDefaultValidator((FilterableSelectionFieldDescriptor)filterableSelectionFieldDescriptor));
        filterableSelectionFieldDescriptor.addValidator(new ConnectionSetAdapterFieldValidator());
        tableDescriptor.addRowField((FieldDescriptor)filterableSelectionFieldDescriptor);
        return tableDescriptor;
    }

    private static class CustomConnectionSelectionFieldDescriptor
    extends ConnectionSelectionFieldDescriptor {
        CustomConnectionSelectionFieldDescriptor(String name, String description, ConnectionSelectionFieldDescriptor.ConnectionType connectionType) {
            super(name, description, connectionType);
        }

        public String parseSelectedValueForStorage(String selectedValue) {
            if (this.isValidFormat(selectedValue)) {
                return selectedValue.split("-", 2)[1];
            }
            return selectedValue;
        }

        public String getSelectedDisplayName(String valueForStorage) {
            ConnectionDbEntry connectionDbEntry = MgmtFactory.getConnectionDb().getEntryByEntityId(this.getRole(), valueForStorage);
            if (connectionDbEntry != null) {
                return String.format("%s (%s)", connectionDbEntry.getName() + (!connectionDbEntry.isActive() ? " - Inactive" : ""), valueForStorage);
            }
            return "";
        }

        private Role getRole() {
            switch (this.getConnectionType()) {
                case SP_CONNECTION: {
                    return Role.SP;
                }
                case IDP_CONNECTION: {
                    return Role.IDP;
                }
            }
            return null;
        }
    }

    private static class ConnectionSetAdapterConfigurationValidator
    implements ConfigurationValidator {
        private static final String VALIDATION_ERROR_MESSAGE_AT_LEASE_ONE_ENTRY = "Please add at least one connection to the 'Connections' table.";
        private static final String VALIDATION_ERROR_MESSAGE_DUPLICATE_ENTRY = "Duplicate connection: %s.";
        private static final String VALIDATION_ERROR_MESSAGE_NON_EXISTENT_ENTRY = "Connection '%s' no longer exists. Please remove it from the 'Connections' table.";

        ConnectionSetAdapterConfigurationValidator() {
        }

        public void validate(Configuration configuration) throws ValidationException {
            ArrayList<String> errors = new ArrayList<String>();
            this.assertAtLeastOneConfiguredConnection(configuration);
            this.checkForConfiguredConnectionExistence(configuration, errors);
            this.checkForDuplicateConfiguredConnection(configuration, errors);
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        }

        private void assertAtLeastOneConfiguredConnection(Configuration configuration) throws ValidationException {
            Table table = configuration.getTable(ConnectionSetAdapterSelector.CONNECTIONS_TABLE_NAME);
            if (table.getRows().isEmpty()) {
                throw new ValidationException(VALIDATION_ERROR_MESSAGE_AT_LEASE_ONE_ENTRY);
            }
        }

        private void checkForConfiguredConnectionExistence(Configuration configuration, List<String> errors) {
            Table table = configuration.getTable(ConnectionSetAdapterSelector.CONNECTIONS_TABLE_NAME);
            table.getRows().forEach(row -> {
                String entityId = row.getFieldValue(ConnectionSetAdapterSelector.CONNECTION_FIELD_NAME);
                if (MgmtFactory.getConnectionDb().getEntryByEntityId(Role.SP, entityId) == null) {
                    errors.add(String.format(VALIDATION_ERROR_MESSAGE_NON_EXISTENT_ENTRY, entityId));
                }
            });
        }

        private void checkForDuplicateConfiguredConnection(Configuration configuration, List<String> errors) {
            Table table = configuration.getTable(ConnectionSetAdapterSelector.CONNECTIONS_TABLE_NAME);
            HashSet connections = new HashSet();
            table.getRows().forEach(row -> {
                String connectionId = row.getFieldValue(ConnectionSetAdapterSelector.CONNECTION_FIELD_NAME);
                if (!connections.add(connectionId)) {
                    errors.add(String.format(VALIDATION_ERROR_MESSAGE_DUPLICATE_ENTRY, MgmtFactory.getConnectionDb().getEntryByEntityId(Role.SP, connectionId).getEntityId()));
                }
            });
        }
    }

    private static class ConnectionSetAdapterFieldValidator
    implements FieldValidator {
        private static final long serialVersionUID = 1L;

        private ConnectionSetAdapterFieldValidator() {
        }

        public void validate(Field field) throws ValidationException {
            if (StringUtils.isBlank((String)field.getValue())) {
                throw new ValidationException("Select a service provider connection from the list.");
            }
        }
    }
}

