/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.selectors.http;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExpressionMatchHandler;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class HttpRequestParamAuthnSelector
implements AuthenticationSelector,
AuthnApiPlugin {
    private static final String DESCRIPTION = "This authentication selector provides a means of choosing authentication sources at runtime based on HTTP request parameters.";
    static final String FIELD_HTTP_REQUEST_PARAMETER_NAME = "HTTP Request Parameter Name";
    static final String FIELD_ENABLE_CASESENSITIVE = "Case-Sensitive Matching";
    private static final String DESC_HTTP_REQUEST_PARAMETER_NAME = "The exact name of the HTTP request parameter.";
    private static final String DESC_ENABLE_CASESENSITIVE = "Allows HTTP request parameter value matching to be case-sensitive.";
    private static final boolean DEFAULT_VALUE_ENABLE_CASESENSITIVE = true;
    private static final String PLUGIN_TYPE_NAME = "HTTP Request Parameter Authentication Selector";
    private static String NOT_IN_REQUEST_RESULT_VALUE = "Not in Request";
    private static String NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME = "Enable '" + NOT_IN_REQUEST_RESULT_VALUE + "' Result Value";
    private static String NOT_IN_REQUEST_RESULT_ENABLED_FIELD_DESCRIPTION = "By default, selector evaluation fails and the next applicable authentication policy is executed if the HTTP request parameter is not found. Select this checkbox to enable a policy branch in this case.";
    private static String NO_MATCH_RESULT_VALUE = "No Match";
    private static String NO_MATCH_RESULT_ENABLED_FIELD_NAME = "Enable '" + NO_MATCH_RESULT_VALUE + "' Result Value";
    private static String NO_MATCH_RESULT_ENABLED_FIELD_DESCRIPTION = "By default, selector evaluation fails and the next applicable authentication policy is executed when the HTTP request parameter value does not match any of the configured selector result values. Select this checkbox to enable an authentication policy branch in this case.";
    private static String ANY_RESULT_VALUE = "Any";
    private static String ANY_RESULT_ENABLED_FIELD_NAME = "Enable '" + ANY_RESULT_VALUE + "' Result Value";
    private static String ANY_RESULT_ENABLED_FIELD_DESCRIPTION = "By default, each configured selector result value leads to a separate authentication policy branch. Select this checkbox to enable a single policy branch if the HTTP request parameter matches any selector result value.";
    private String requestParamName = null;
    private boolean enableCaseSensitiveMatch = true;
    private ExpressionMatchHandler expressionHandler = null;
    private volatile boolean notInRequestResultEnabled = false;
    private volatile boolean noMatchResultEnabled = false;
    private volatile boolean anyResultEnabled = false;
    private static final Log log = LogFactory.getLog(HttpRequestParamAuthnSelector.class);

    public void configure(Configuration configuration) {
        this.requestParamName = configuration.getFieldValue(FIELD_HTTP_REQUEST_PARAMETER_NAME);
        Field caseSensitiveField = configuration.getField(FIELD_ENABLE_CASESENSITIVE);
        if (caseSensitiveField != null) {
            this.enableCaseSensitiveMatch = caseSensitiveField.getValueAsBoolean();
        }
        ArrayList attrs = new ArrayList();
        attrs.addAll(configuration.getAdditionalAttrNames());
        this.expressionHandler = new ExpressionMatchHandler(attrs, this.enableCaseSensitiveMatch);
        this.notInRequestResultEnabled = configuration.getBooleanFieldValue(NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME);
        this.noMatchResultEnabled = configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME);
        this.anyResultEnabled = configuration.getBooleanFieldValue(ANY_RESULT_ENABLED_FIELD_NAME);
    }

    public PluginDescriptor getPluginDescriptor() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.setDescription(DESCRIPTION);
        TextFieldDescriptor requestParamNameField = new TextFieldDescriptor(FIELD_HTTP_REQUEST_PARAMETER_NAME, DESC_HTTP_REQUEST_PARAMETER_NAME);
        requestParamNameField.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)requestParamNameField);
        CheckBoxFieldDescriptor enableCaseSensitiveField = new CheckBoxFieldDescriptor(FIELD_ENABLE_CASESENSITIVE, DESC_ENABLE_CASESENSITIVE);
        enableCaseSensitiveField.setDefaultValue(true);
        enableCaseSensitiveField.setDefaultForLegacyConfig(Boolean.toString(true));
        guiConfigDescriptor.addField((FieldDescriptor)enableCaseSensitiveField);
        CheckBoxFieldDescriptor resultRequestedContextAnyMatch = new CheckBoxFieldDescriptor(ANY_RESULT_ENABLED_FIELD_NAME, ANY_RESULT_ENABLED_FIELD_DESCRIPTION);
        resultRequestedContextAnyMatch.setDefaultValue(false);
        resultRequestedContextAnyMatch.setDefaultForLegacyConfig(Boolean.toString(false));
        guiConfigDescriptor.addField((FieldDescriptor)resultRequestedContextAnyMatch);
        CheckBoxFieldDescriptor resultRequestedContextDoesNotMatch = new CheckBoxFieldDescriptor(NO_MATCH_RESULT_ENABLED_FIELD_NAME, NO_MATCH_RESULT_ENABLED_FIELD_DESCRIPTION);
        resultRequestedContextDoesNotMatch.setDefaultValue(false);
        resultRequestedContextDoesNotMatch.setDefaultForLegacyConfig(Boolean.toString(false));
        guiConfigDescriptor.addField((FieldDescriptor)resultRequestedContextDoesNotMatch);
        CheckBoxFieldDescriptor resultNoRequestedContext = new CheckBoxFieldDescriptor(NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME, NOT_IN_REQUEST_RESULT_ENABLED_FIELD_DESCRIPTION);
        resultNoRequestedContext.setDefaultValue(false);
        resultNoRequestedContext.setDefaultForLegacyConfig(Boolean.toString(false));
        guiConfigDescriptor.addField((FieldDescriptor)resultNoRequestedContext);
        HttpRequestParamAuthnSelectorDescriptor authSelectorDescriptor = new HttpRequestParamAuthnSelectorDescriptor(PLUGIN_TYPE_NAME, (ConfigurablePlugin)this, guiConfigDescriptor, null);
        authSelectorDescriptor.setSupportsExtendedResults(true);
        authSelectorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
        guiConfigDescriptor.addValidator((ConfigurationValidator)new HttpReqParamAuthnSelectorValidator());
        return authSelectorDescriptor;
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse resp, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        Collection<String> values;
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting HTTP Request parameter value for '" + LogGuard.encode((String)this.requestParamName) + "'."));
        }
        String requestParamValue = null;
        Map<String, Collection<String>> trackedParams = this.getTrackedParams(extraParameters);
        if (!trackedParams.isEmpty() && (values = trackedParams.get(this.requestParamName)) != null && !values.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found parameter value in the tracked parameters.");
            }
            requestParamValue = values.iterator().next();
        }
        if (requestParamValue == null && (requestParamValue = req.getParameter(this.requestParamName)) != null && log.isDebugEnabled()) {
            log.debug((Object)"Found parameter value in the servlet request.");
        }
        if (requestParamValue != null) {
            String matchedParam = this.expressionHandler.getBestMatchedExpression(requestParamValue);
            if (this.anyResultEnabled && matchedParam != null) {
                context.setResult(this.getAnyResult());
                return context;
            }
            if (matchedParam != null) {
                context.setResult(matchedParam);
                return context;
            }
        }
        if (this.notInRequestResultEnabled && requestParamValue == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No value for " + LogGuard.encode((String)this.requestParamName) + " was found."));
            }
            context.setResult(this.getNotInRequestResult());
            return context;
        }
        if (this.noMatchResultEnabled && requestParamValue != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"None of the configured params matches the requested request parameter.");
            }
            context.setResult(this.getNoMatchResult());
            return context;
        }
        return context;
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    private Map<String, Collection<String>> getTrackedParams(Map<String, Object> extraParams) {
        Object trackedParamsObject = extraParams.get("com.pingidentity.sdk.authnselector.tracked.http.request.params");
        if (trackedParamsObject != null) {
            return (Map)trackedParamsObject;
        }
        return Collections.emptyMap();
    }

    public void callback(HttpServletRequest req, HttpServletResponse resp, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
    }

    private String getNotInRequestResult() {
        if (this.notInRequestResultEnabled) {
            return NOT_IN_REQUEST_RESULT_VALUE;
        }
        return null;
    }

    private String getNoMatchResult() {
        if (this.noMatchResultEnabled) {
            return NO_MATCH_RESULT_VALUE;
        }
        return null;
    }

    private String getAnyResult() {
        if (this.anyResultEnabled) {
            return ANY_RESULT_VALUE;
        }
        return null;
    }

    private static class HttpReqParamAuthnSelectorValidator
    implements ConfigurationValidator {
        private static final String VALIDATION_ERROR_NOT_IN_REQUEST_RESERVED = "'" + NOT_IN_REQUEST_RESULT_VALUE + "' is a reserved result value. Please remove the problematic result value or disable the option.";
        private static final String VALIDATION_ERROR_NO_MATCH_RESERVED = "'" + NO_MATCH_RESULT_VALUE + "' is a reserved result value. Please remove the problematic result value or disable the option.";
        private static final String VALIDATION_ERROR_ANY_RESERVED = "'" + ANY_RESULT_VALUE + "' is a reserved result value. Please remove the problematic result value or disable the option.";

        private HttpReqParamAuthnSelectorValidator() {
        }

        public void validate(Configuration configuration) throws ValidationException {
            if (configuration == null) {
                return;
            }
            boolean notInRequestEnabled = configuration.getBooleanFieldValue(NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME);
            boolean noMatchEnabled = configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME);
            boolean anyEnabled = configuration.getBooleanFieldValue(ANY_RESULT_ENABLED_FIELD_NAME);
            ArrayList<String> errors = new ArrayList<String>();
            if (notInRequestEnabled && configuration.getAdditionalAttrNames().stream().anyMatch(result -> NOT_IN_REQUEST_RESULT_VALUE.equalsIgnoreCase((String)result))) {
                errors.add(VALIDATION_ERROR_NOT_IN_REQUEST_RESERVED);
            }
            if (noMatchEnabled && configuration.getAdditionalAttrNames().stream().anyMatch(result -> NO_MATCH_RESULT_VALUE.equalsIgnoreCase((String)result))) {
                errors.add(VALIDATION_ERROR_NO_MATCH_RESERVED);
            }
            if (anyEnabled && configuration.getAdditionalAttrNames().stream().anyMatch(result -> ANY_RESULT_VALUE.equalsIgnoreCase((String)result))) {
                errors.add(VALIDATION_ERROR_ANY_RESERVED);
            }
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        }
    }

    private static class HttpRequestParamAuthnSelectorDescriptor
    extends AuthenticationSelectorDescriptor {
        public HttpRequestParamAuthnSelectorDescriptor(String type, ConfigurablePlugin plugin, GuiConfigDescriptor guiConfigDesc, Set<String> results) {
            super(type, plugin, guiConfigDesc, results);
        }

        public List<String> getAdditionalResults(Configuration configuration) {
            ArrayList<String> results = new ArrayList<String>();
            if (configuration.getBooleanFieldValue(NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME)) {
                results.add(NOT_IN_REQUEST_RESULT_VALUE);
            }
            if (configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME)) {
                results.add(NO_MATCH_RESULT_VALUE);
            }
            if (configuration.getBooleanFieldValue(ANY_RESULT_ENABLED_FIELD_NAME)) {
                results.add(ANY_RESULT_VALUE);
            }
            return results;
        }

        public boolean isAnyMatchEnabled(Configuration configuration) {
            return configuration.getBooleanFieldValue(ANY_RESULT_ENABLED_FIELD_NAME);
        }

        public boolean isSortConfigurationAttributes(Configuration configuration) {
            return true;
        }
    }
}

