/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.tokenprocessors.jwt;

import com.pingidentity.access.TrustedCAAccessor;
import com.pingidentity.pf.tokenprocessors.jwt.JwksInfo;
import com.pingidentity.pf.tokenprocessors.jwt.configuration.JwtTokenProcessorConfiguration;
import com.pingidentity.pf.tokenprocessors.jwt.util.JwtUtil;
import com.pingidentity.pf.tokenprocessors.jwt.util.KeyResolverUtil;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginFipsStatus;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.process.TokenContext;
import org.sourceid.wstrust.plugin.process.TokenProcessor;
import org.sourceid.wstrust.plugin.process.TokenProcessorDescriptor;

public class JwtTokenProcessor
implements TokenProcessor<BinarySecurityToken> {
    private static final Logger log = LogManager.getLogger(JwtTokenProcessor.class);
    private int clockSkewInSeconds;
    private boolean requireAudience;
    private boolean requireExpiry;
    private Integer maxFutureValidityInMinutes;
    private boolean requireIssuedAt;
    private boolean requireNotBefore;
    private final HashMap<String, JwksInfo> issuerJwksInfoMap = new HashMap();
    private final List<String> audienceList = new ArrayList<String>();
    private final TokenProcessorDescriptor tokenPluginDescriptor = new TokenProcessorDescriptor(String.format("JWT Token Processor %s", "2.0"), (Plugin)this, JwtTokenProcessorConfiguration.getPluginDescriptor(), "urn:ietf:params:oauth:token-type:jwt", Collections.singleton("sub"));

    public JwtTokenProcessor() {
        this.tokenPluginDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public void configure(Configuration configuration) {
        Table issuerTable = configuration.getTable("Allowed Issuers");
        long defaultCacheDurationInSeconds = configuration.getLongFieldValue("Default Cache Duration") * 60L;
        for (Row row : issuerTable.getRows()) {
            String issuer = StringUtils.trim((String)row.getFieldValue("Issuer"));
            JwksInfo jwksInfo = new JwksInfo();
            String jwkUrl = StringUtils.trim((String)row.getFieldValue("JWKS URL"));
            if (StringUtils.isNotBlank((String)jwkUrl)) {
                HttpsJwks httpsJwks = new HttpsJwks(jwkUrl);
                httpsJwks.setSimpleHttpGet((SimpleGet)JwtTokenProcessor.getSimpleHttpGet());
                httpsJwks.setDefaultCacheDuration(defaultCacheDurationInSeconds);
                httpsJwks.setRetainCacheOnErrorDuration(defaultCacheDurationInSeconds / 2L);
                jwksInfo.setHttpsJwks(httpsJwks);
            } else {
                String jwks = StringUtils.trim((String)row.getFieldValue("JWKS"));
                try {
                    jwksInfo.setJwks(new JsonWebKeySet(jwks));
                }
                catch (JoseException joseException) {
                    // empty catch block
                }
            }
            this.issuerJwksInfoMap.put(issuer, jwksInfo);
        }
        Table audienceTable = configuration.getTable("Allowed Audiences");
        for (Row row : audienceTable.getRows()) {
            String audience = StringUtils.trim((String)row.getFieldValue("Audience"));
            this.audienceList.add(audience);
        }
        this.requireAudience = configuration.getBooleanFieldValue("Require Audience", true);
        this.clockSkewInSeconds = configuration.getIntFieldValue("Allowed Clock Skew");
        this.requireExpiry = configuration.getBooleanFieldValue("Require Expiration Time", true);
        this.requireIssuedAt = configuration.getBooleanFieldValue("Require Issued At Time");
        this.requireNotBefore = configuration.getBooleanFieldValue("Require Not Before Time");
        if (StringUtils.isNotBlank((String)configuration.getFieldValue("Max Future Validity"))) {
            this.maxFutureValidityInMinutes = configuration.getIntFieldValue("Max Future Validity");
        }
    }

    private static Get getSimpleHttpGet() {
        Get get = new Get();
        Set allTrustAnchors = new TrustedCAAccessor().getAllTrustAnchors();
        ArrayList<X509Certificate> trustedCertificates = new ArrayList<X509Certificate>();
        for (TrustAnchor ta : allTrustAnchors) {
            trustedCertificates.add(ta.getTrustedCert());
        }
        get.setTrustedCertificates(trustedCertificates);
        get.setHostnameVerifier(SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        return get;
    }

    public TokenContext processToken(BinarySecurityToken binarySecurityToken) throws TokenProcessingException {
        try {
            JwtContext jwtContext = JwtUtil.getJwtContext(binarySecurityToken);
            this.validateJwtTokenContext(jwtContext);
            TokenContext tokenContext = new TokenContext();
            tokenContext.setSubjectAttributes(JwtUtil.getOutgoingAttributes(jwtContext));
            return tokenContext;
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            String errorMessagePrefix = "Invalid Token.";
            log.debug(errorMessagePrefix + " " + e.getMessage());
            throw new TokenProcessingException(errorMessagePrefix, e);
        }
    }

    private void validateJwtTokenContext(JwtContext jwtContext) throws InvalidJwtException, MalformedClaimException, TokenProcessingException {
        String issuer;
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder();
        if (this.audienceList.size() > 0) {
            jwtConsumerBuilder.setExpectedAudience(this.requireAudience, this.audienceList.toArray(new String[0]));
        }
        if (this.requireExpiry) {
            jwtConsumerBuilder.setRequireExpirationTime();
        }
        if (this.requireIssuedAt) {
            jwtConsumerBuilder.setRequireIssuedAt();
        }
        if (this.requireNotBefore) {
            jwtConsumerBuilder.setRequireNotBefore();
        }
        if (this.maxFutureValidityInMinutes != null) {
            jwtConsumerBuilder.setMaxFutureValidityInMinutes(this.maxFutureValidityInMinutes.intValue());
        }
        if (this.issuerJwksInfoMap.get(issuer = jwtContext.getJwtClaims().getIssuer()) == null) {
            throw new TokenProcessingException("The issuer was not recognized.");
        }
        VerificationKeyResolver verificationKeyResolver = KeyResolverUtil.getVerificationKeyResolver(this.issuerJwksInfoMap.get(issuer));
        jwtConsumerBuilder.setVerificationKeyResolver(verificationKeyResolver);
        jwtConsumerBuilder.setExpectedIssuer(true, issuer).setAllowedClockSkewInSeconds(this.clockSkewInSeconds).setJwsAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE).build().processContext(jwtContext);
    }

    public TokenProcessorDescriptor getPluginDescriptor() {
        return this.tokenPluginDescriptor;
    }
}

