/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.tokenprocessors.jwt.configuration;

import com.pingidentity.pf.tokenprocessors.jwt.validation.ExpectedAudiencesValidator;
import com.pingidentity.pf.tokenprocessors.jwt.validation.ExpectedIssuersValidator;
import com.pingidentity.pf.tokenprocessors.jwt.validation.IssuerJwksValidator;
import com.pingidentity.pf.tokenprocessors.jwt.validation.JwtTokenProcessorConfigurationValidator;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.util.Arrays;
import java.util.Collections;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.TableValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.HttpsURLValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.JwksValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class JwtTokenProcessorConfiguration {
    public static GuiConfigDescriptor getPluginDescriptor() {
        GuiConfigDescriptor guiDescriptor = new GuiConfigDescriptor();
        TextFieldDescriptor issuer = new TextFieldDescriptor("Issuer", "Accepted \"iss\" (Issuer) claim value.");
        issuer.addValidator((FieldValidator)new RequiredFieldValidator());
        TextFieldDescriptor jwksUrl = new TextFieldDescriptor("JWKS URL", "Represents a set of JSON Web Keys (typically public keys) published at an HTTPS URI that is used to verify the authenticity of the JWTs with the configured issuer.");
        jwksUrl.addValidator((FieldValidator)new HttpsURLValidator(), true);
        TextFieldDescriptor jwks = new TextFieldDescriptor("JWKS", "Represents a set of JSON Web Keys (typically public keys) used to verify the authenticity of the JWTs with the configured issuer.");
        jwks.addValidator((FieldValidator)new JwksValidator(), true);
        TableDescriptor expectedIssuersTable = new TableDescriptor("Allowed Issuers", "List of allowed issuers with associated JWKS or JWKS URIs.", Arrays.asList(issuer, jwksUrl, jwks));
        expectedIssuersTable.addTableValidator((TableValidator)new ExpectedIssuersValidator());
        expectedIssuersTable.addValidator((RowValidator)new IssuerJwksValidator());
        guiDescriptor.addTable(expectedIssuersTable);
        TextFieldDescriptor audience = new TextFieldDescriptor("Audience", "Accepted \"aud\" (Audience) claim value.");
        audience.addValidator((FieldValidator)new RequiredFieldValidator());
        TableDescriptor audienceTable = new TableDescriptor("Allowed Audiences", "A list of audience values that identify the PingFederate server as the target audience.", Collections.singletonList(audience));
        audienceTable.addTableValidator((TableValidator)new ExpectedAudiencesValidator());
        guiDescriptor.addTable(audienceTable);
        CheckBoxFieldDescriptor requireAudience = new CheckBoxFieldDescriptor("Require Audience", "Whether the \"aud\" (Audience) claim is required in the token.");
        requireAudience.setDefaultValue(true);
        guiDescriptor.addField((FieldDescriptor)requireAudience);
        CheckBoxFieldDescriptor requireExpirationTime = new CheckBoxFieldDescriptor("Require Expiration Time", "Whether the \"exp\" (Expiration Time) claim is required in the token.");
        requireExpirationTime.setDefaultValue(true);
        guiDescriptor.addField((FieldDescriptor)requireExpirationTime);
        CheckBoxFieldDescriptor requireIssuedAt = new CheckBoxFieldDescriptor("Require Issued At Time", "Whether the \"iat\" (Issued At Time) claim is required in the token.");
        requireIssuedAt.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)requireIssuedAt);
        CheckBoxFieldDescriptor requireNotBefore = new CheckBoxFieldDescriptor("Require Not Before Time", "Whether the \"nbf\" (Not Before Time) claim is required in the token.");
        requireNotBefore.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)requireNotBefore);
        TextFieldDescriptor defaultCacheTime = new TextFieldDescriptor("Default Cache Duration", "The amount of time (in minutes) to cache the JWKs from the endpoint. This is used when the cache headers from the JWKS Endpoint response don't indicate a cache time. Allowable values: 0 - 8640. The default value is 720.");
        defaultCacheTime.setDefaultValue(Integer.toString(720));
        defaultCacheTime.addValidator((FieldValidator)new IntegerValidator(0, 8640), true);
        guiDescriptor.addAdvancedField((FieldDescriptor)defaultCacheTime);
        TextFieldDescriptor clockSkew = new TextFieldDescriptor("Allowed Clock Skew", "The amount of clock skew (in seconds) to allow for when validating the \"exp\" (Expiration Time) and \"nbf\" (Not Before Time) claims. Allowable values: 0 - 3600. The default value is 0.");
        clockSkew.setDefaultValue(Integer.toString(0));
        clockSkew.addValidator((FieldValidator)new IntegerValidator(0, 3600), true);
        guiDescriptor.addAdvancedField((FieldDescriptor)clockSkew);
        TextFieldDescriptor maxFutureValidity = new TextFieldDescriptor("Max Future Validity", "The maximum amount of time (in minutes) on how far in the future the \"exp\" (Expiration Time) claim can be.");
        maxFutureValidity.addValidator((FieldValidator)new IntegerValidator(1, 0x2222222), true);
        guiDescriptor.addAdvancedField((FieldDescriptor)maxFutureValidity);
        guiDescriptor.addValidator((ConfigurationValidator)new JwtTokenProcessorConfigurationValidator());
        return guiDescriptor;
    }
}

