/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.tokenprocessors.jwt.util;

import com.pingidentity.pf.tokenprocessors.jwt.util.KeyResolverUtil;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.wstrust.model.BinarySecurityToken;

public final class JwtUtil {
    private static final AlgorithmConstraints JWE_ALGORITHM_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"RSA-OAEP", "RSA-OAEP-256", "ECDH-ES", "ECDH-ES+A128KW", "ECDH-ES+A192KW", "ECDH-ES+A256KW"});

    private JwtUtil() {
        throw new IllegalStateException("not allowed");
    }

    public static JwtContext getJwtContext(BinarySecurityToken binarySecurityToken) throws InvalidJwtException {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().setDecryptionKeyResolver((DecryptionKeyResolver)KeyResolverUtil.getDecryptionKeyResolver()).setJweAlgorithmConstraints(JWE_ALGORITHM_CONSTRAINTS).build();
        String jwtToken = binarySecurityToken.getEncodedData();
        return jwtConsumer.process(jwtToken);
    }

    public static Map<String, AttributeValue> getOutgoingAttributes(JwtContext jwtContext) {
        Map incomingAttributes = jwtContext.getJwtClaims().getClaimsMap();
        Function<Map.Entry, AttributeValue> entryValueToAttributeValueMapper = e -> e.getValue() instanceof Collection ? AttrValueSupport.make((Collection)((Collection)e.getValue())) : AttrValueSupport.make(e.getValue());
        return incomingAttributes.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entryValueToAttributeValueMapper));
    }
}

