/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.tokenprocessors.jwt.util;

import com.pingidentity.access.JwksEndpointKeyAccessor;
import com.pingidentity.pf.tokenprocessors.jwt.JwksInfo;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.JwksDecryptionKeyResolver;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

public class KeyResolverUtil {
    public static VerificationKeyResolver getVerificationKeyResolver(JwksInfo jwksInfo) {
        if (jwksInfo.getHttpsJwks() != null) {
            HttpsJwksVerificationKeyResolver httpsJwksResolver = new HttpsJwksVerificationKeyResolver(jwksInfo.getHttpsJwks());
            httpsJwksResolver.setDisambiguateWithVerifySignature(true);
            return httpsJwksResolver;
        }
        JwksVerificationKeyResolver jwksResolver = new JwksVerificationKeyResolver(jwksInfo.getJwks().getJsonWebKeys());
        jwksResolver.setDisambiguateWithVerifySignature(true);
        return jwksResolver;
    }

    public static JwksDecryptionKeyResolver getDecryptionKeyResolver() {
        JwksEndpointKeyAccessor jwksEndpointKeyAccessor = JwksEndpointKeyAccessor.newInstance();
        JsonWebKeySet jwks = jwksEndpointKeyAccessor.getDecryptionKeys();
        JwksDecryptionKeyResolver jwksDecryptionKeyResolver = new JwksDecryptionKeyResolver(jwks.getJsonWebKeys());
        jwksDecryptionKeyResolver.setDisambiguateWithAttemptDecrypt(true);
        return jwksDecryptionKeyResolver;
    }
}

