/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.tokenprocessors.username;

import com.pingidentity.access.PasswordCredentialValidatorAccessor;
import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import com.pingidentity.pf.tokenprocessors.username.UsernamePcvsConfigValidator;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.PasswordValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.PasswordCredentialValidatorFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.EnhancedRowValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.wstrust.model.UsernameToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.process.FailedAuthnException;
import org.sourceid.wstrust.plugin.process.TokenContext;
import org.sourceid.wstrust.plugin.process.TokenProcessor;
import org.sourceid.wstrust.plugin.process.TokenProcessorDescriptor;

public class UsernameTokenProcessor
implements TokenProcessor<UsernameToken> {
    private static final Log log = LogFactory.getLog(UsernameTokenProcessor.class);
    private static final String TP_NAME = "Username Token Processor";
    private static final String TP_DESC = "A token processor that validates username tokens against a set of Password Credential Validator instances. The first Credential Validator that successfully validates a token will pass its attributes to this token processor and can be accessed by extending the attribute contract.";
    private static final String PCVS_DESCRIPTION = "A list of Credential Validator instances to authenticate Username Tokens. A token is processed in the same order as the selected Credential Validators";
    private static final String PCV_DESCRIPTION = "A configured Password Credential Validator instance";
    private static final String USERNAME_ATTRIBUTE = "username";
    public static final String MAX_AUTH_ATTEMPTS = String.valueOf(AccountLockingService.getMaxConsecutiveFailures());
    public static final String FIELD_RETRIES = "Authentication Attempts";
    public static final String DESC_RETRIES = "Max number of failed Authentication Attempts before locking a user account.";
    private LockingService accountLockingService;
    private int maxConsecutiveFailures;
    private final TokenProcessorDescriptor processorDescriptor;
    private final List<String> pcvIds = new LinkedList<String>();

    public UsernameTokenProcessor() {
        HashSet<String> attrContract = new HashSet<String>();
        attrContract.add(USERNAME_ATTRIBUTE);
        GuiConfigDescriptor guiDescriptor = new GuiConfigDescriptor(TP_DESC);
        PasswordCredentialValidatorFieldDescriptor pcvDesc = new PasswordCredentialValidatorFieldDescriptor("Password Credential Validator Instance", PCV_DESCRIPTION);
        pcvDesc.addValidator((FieldValidator)new RequiredFieldValidator());
        TableDescriptor tableDescriptor = new TableDescriptor("Credential Validators", PCVS_DESCRIPTION);
        tableDescriptor.addRowField((FieldDescriptor)pcvDesc);
        tableDescriptor.addValidator((RowValidator)new PcvRowValidator());
        guiDescriptor.addTable(tableDescriptor);
        guiDescriptor.addValidator((ConfigurationValidator)new UsernamePcvsConfigValidator());
        TextFieldDescriptor retries = new TextFieldDescriptor(FIELD_RETRIES, DESC_RETRIES);
        retries.addValidator((FieldValidator)new RequiredFieldValidator());
        retries.addValidator((FieldValidator)new IntegerValidator(1, 100));
        retries.setDefaultValue(MAX_AUTH_ATTEMPTS);
        retries.setDefaultForLegacyConfig(MAX_AUTH_ATTEMPTS);
        guiDescriptor.addField((FieldDescriptor)retries);
        this.processorDescriptor = new TokenProcessorDescriptor(TP_NAME, (Plugin)this, guiDescriptor, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken", attrContract, VersionUtil.getVersion());
        this.processorDescriptor.setSupportsExtendedContract(true);
        this.processorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public TokenProcessorDescriptor getPluginDescriptor() {
        return this.processorDescriptor;
    }

    public TokenContext processToken(UsernameToken usernameToken) throws TokenProcessingException {
        String passwordKey;
        String userKey = AccountLockingService.getUserKey((String)usernameToken.getRequestIpAddress(), (String)usernameToken.getUsername());
        LockingService.IsLockedRequest usernameRequest = new LockingService.IsLockedRequest.Builder(userKey).loginType(LockingService.FailedLoginType.USERNAME).maxFailedLogins(this.maxConsecutiveFailures).lockoutPeriod(AccountLockingService.getLockoutPeriod()).build();
        FailedAuthnException failedAuthnException = this.checkIsLocked(usernameToken, usernameRequest, passwordKey = usernameToken.getPassword() != null ? AccountLockingService.buildPasswordLockingKey((String)usernameToken.getPassword()) : null);
        if (failedAuthnException != null) {
            throw failedAuthnException;
        }
        PasswordValidationException firstPcvException = null;
        if (this.pcvIds.isEmpty()) {
            throw new TokenProcessingException("No password credential validators are configured. Rejecting username token.");
        }
        for (String pcvId : this.pcvIds) {
            AttributeMap attrMap;
            block8: {
                attrMap = null;
                try {
                    PasswordCredentialValidatorAccessor pcvAccessor = new PasswordCredentialValidatorAccessor();
                    PasswordCredentialValidator pcv = pcvAccessor.getPasswordCredentialValidator(pcvId);
                    if (pcv == null) break block8;
                    attrMap = pcv.processPasswordCredential(usernameToken.getUsername(), usernameToken.getPassword());
                }
                catch (PasswordCredentialValidatorAuthnException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("PCV failed to validate credentials - " + e.getMessage()));
                    continue;
                }
                catch (PasswordValidationException e) {
                    log.error((Object)("PCV failed to process credentials - " + e.getMessage()));
                    if (firstPcvException == null) continue;
                    firstPcvException = e;
                    continue;
                }
            }
            if (attrMap == null || attrMap.isEmpty()) continue;
            TokenContext tokenContext = new TokenContext();
            attrMap.put(USERNAME_ATTRIBUTE, new AttributeValue(usernameToken.getUsername()));
            tokenContext.setSubjectAttributes((Map)attrMap);
            AuditLogger.setPcvId((String)pcvId);
            this.accountLockingService.clearFailedLogins(userKey);
            return tokenContext;
        }
        this.accountLockingService.logFailedLogin(userKey);
        if (passwordKey != null) {
            this.accountLockingService.logFailedPassword(passwordKey);
        }
        if ((failedAuthnException = this.checkIsLocked(usernameToken, usernameRequest, passwordKey)) == null) {
            failedAuthnException = firstPcvException != null ? new FailedAuthnException("Invalid credentials - " + firstPcvException.getMessage()) : new FailedAuthnException("Invalid credentials.");
        }
        throw failedAuthnException;
    }

    private FailedAuthnException checkIsLocked(UsernameToken usernameToken, LockingService.IsLockedRequest usernameRequest, String passwordKey) {
        LockingService.IsLockedRequest passwordRequest;
        FailedAuthnException failedAuthnException = null;
        if (this.accountLockingService.isLocked(usernameRequest)) {
            failedAuthnException = new FailedAuthnException("Account Locked.");
        }
        if (usernameToken.getPassword() != null && this.accountLockingService.isLocked(passwordRequest = new LockingService.IsLockedRequest.Builder(passwordKey).loginType(LockingService.FailedLoginType.PASSWORD).build())) {
            failedAuthnException = new FailedAuthnException("Password Locked.");
        }
        return failedAuthnException;
    }

    public void configure(Configuration configuration) {
        Table table = configuration.getTable("Credential Validators");
        try {
            this.maxConsecutiveFailures = Integer.parseInt(configuration.getFieldValue(FIELD_RETRIES));
        }
        catch (NumberFormatException ne) {
            this.maxConsecutiveFailures = Integer.parseInt(MAX_AUTH_ATTEMPTS);
        }
        this.accountLockingService = MgmtFactory.getAccountLockingService().getInstance(this.getClass().getSimpleName() + configuration.getId());
        this.pcvIds.clear();
        if (table != null) {
            for (Row row : table.getRows()) {
                String pcvId = row.getFieldValue("Password Credential Validator Instance");
                this.pcvIds.add(pcvId);
            }
        }
    }

    private static class PcvRowValidator
    implements EnhancedRowValidator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PcvRowValidator() {
        }

        public void validate(FieldList fieldsInRow) {
        }

        public void validate(FieldList fieldsInRow, Configuration configuration) throws ValidationException {
            ArrayList<String> adapters = new ArrayList<String>();
            for (Row row : configuration.getTable("Credential Validators").getRows()) {
                String pcvName = row.getFieldValue("Password Credential Validator Instance");
                if (adapters.contains(pcvName)) {
                    throw new ValidationException("Password Credential Validator '" + pcvName + "' has already been added");
                }
                adapters.add(pcvName);
            }
        }
    }
}

