/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas.scim11serviceprovider;

import com.pingidentity.common.util.B64;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.common.Util;
import org.sourceid.util.json.JsonUtils;

public class OAuth2BearerTokenAuthFilter
extends ClientFilter {
    private final Logger logger = LogManager.getLogger(OAuth2BearerTokenAuthFilter.class);
    private String tokenEndpoint;
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private String username;
    private String password;

    public OAuth2BearerTokenAuthFilter(String tokenEndpoint, String clientId, String clientSecret, String username, String password) {
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.username = username;
        this.password = password;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        if (this.accessToken == null) {
            this.getAccessToken();
        }
        if (!cr.getMetadata().containsKey((Object)"Authorization")) {
            cr.getMetadata().add((Object)"Authorization", (Object)("Bearer " + this.accessToken));
        }
        return this.getNext().handle(cr);
    }

    public void resetAccessToken() {
        this.accessToken = null;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="SpotBug complains about possible NPE, but putting in a check causes redundant null-check SpotBugs warning.")
    private void getAccessToken() throws ClientHandlerException {
        block32: {
            HttpURLConnection accessConnection = null;
            try {
                HashMap<String, String> parms = new HashMap<String, String>();
                parms.put("grant_type", "password");
                parms.put("username", this.username);
                parms.put("password", this.password);
                this.logger.debug("Send request to Token Endpoint = " + this.tokenEndpoint);
                accessConnection = (HttpURLConnection)new URL(this.tokenEndpoint).openConnection();
                accessConnection.setRequestMethod("POST");
                accessConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String credentials = this.clientId + ":" + this.clientSecret;
                accessConnection.setRequestProperty("Authorization", "Basic " + B64.encode((String)credentials));
                StringBuilder builder = new StringBuilder();
                URLCodec urlCodec = new URLCodec();
                try {
                    for (Map.Entry entry : parms.entrySet()) {
                        builder.append((String)entry.getKey()).append("=");
                        builder.append(urlCodec.encode((String)entry.getValue())).append("&");
                    }
                }
                catch (EncoderException e) {
                    throw new ClientHandlerException("Problem encoding params.", (Throwable)e);
                }
                String postBody = builder.toString();
                byte[] postBodyBytes = Util.utf8bytes((String)postBody);
                String length = Integer.toString(postBodyBytes.length);
                accessConnection.setRequestProperty("Content-Length", length);
                accessConnection.setUseCaches(false);
                accessConnection.setDoInput(true);
                accessConnection.setDoOutput(true);
                try (OutputStream outputStream = accessConnection.getOutputStream();){
                    outputStream.write(postBodyBytes);
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw new ClientHandlerException("Unable to post data to " + this.tokenEndpoint, (Throwable)e);
                }
                int responseCode = accessConnection.getResponseCode();
                this.logger.debug("Response Code: " + responseCode);
                String encoding = Optional.ofNullable(accessConnection.getContentEncoding()).orElse("UTF-8");
                try (InputStream inputStream = responseCode >= 400 ? accessConnection.getErrorStream() : accessConnection.getInputStream();
                     InputStreamReader jsonInputStream = new InputStreamReader(inputStream, encoding);){
                    Map tokenResponse = JsonUtils.getInstance().readToMap((Reader)jsonInputStream);
                    if (responseCode == 200) {
                        this.accessToken = (String)tokenResponse.get("access_token");
                        break block32;
                    }
                    StringBuilder sb = new StringBuilder("Token endpoint returned error: ");
                    if (tokenResponse.containsKey("error")) {
                        sb.append("error=").append(tokenResponse.get("error"));
                    }
                    if (tokenResponse.containsKey("error_description")) {
                        sb.append(" | error_description=").append(tokenResponse.get("error_description"));
                    }
                    throw new ClientHandlerException("Failed to retrieve access token. " + sb);
                }
            }
            catch (IOException e) {
                throw new ClientHandlerException("Failed to make access token request", (Throwable)e);
            }
            finally {
                if (accessConnection != null) {
                    accessConnection.disconnect();
                }
            }
        }
    }
}

