/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.processor.kerberos;

import com.pingidentity.access.KerberosRealmAccessor;
import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.KerberosResult;
import com.pingidentity.common.util.KerberosUtil;
import com.pingidentity.common.util.KerberosUtilFactory;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginFipsStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.kerberos.KerberosRealmFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.process.TokenContext;
import org.sourceid.wstrust.plugin.process.TokenProcessor;
import org.sourceid.wstrust.plugin.process.TokenProcessorDescriptor;

public class KerberosTokenProcessor
implements TokenProcessor<BinarySecurityToken> {
    private static final Logger log = LogManager.getLogger(KerberosTokenProcessor.class);
    private static final String TYPE = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ";
    private static final String TOKEN_PROCESSOR_NAME = "Kerberos Token Processor";
    private static final RequiredFieldValidator REQUIRED_VALIDATOR = new RequiredFieldValidator();
    private final TokenProcessorDescriptor tokenProcessorDescriptor;
    private String kerberosRealmName;

    public KerberosTokenProcessor() {
        GuiConfigDescriptor gui = new GuiConfigDescriptor(TOKEN_PROCESSOR_NAME);
        KerberosRealmFieldDescriptor kerberosRealmFieldDescriptor = new KerberosRealmFieldDescriptor("Domain/Realm Name", "");
        kerberosRealmFieldDescriptor.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        gui.addField((FieldDescriptor)kerberosRealmFieldDescriptor);
        HashSet<String> contract = new HashSet<String>();
        contract.add("principal");
        contract.add("domain");
        contract.add("username");
        contract.add("objectSid");
        contract.add("sids");
        this.tokenProcessorDescriptor = new TokenProcessorDescriptor(TOKEN_PROCESSOR_NAME, (Plugin)this, gui, TYPE, contract);
        this.tokenProcessorDescriptor.setSupportsExtendedContract(false);
        this.tokenProcessorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public TokenProcessorDescriptor getPluginDescriptor() {
        return this.tokenProcessorDescriptor;
    }

    public TokenContext processToken(BinarySecurityToken token) throws TokenProcessingException {
        Set sids;
        String objectSid;
        String principal;
        KerberosRealmAccessor kerberosRealmAccessor = new KerberosRealmAccessor();
        KerberosRealm kerberosRealm = kerberosRealmAccessor.getKerberosRealm(this.kerberosRealmName);
        KerberosUtil kerberosUtil = KerberosUtilFactory.getKerberosUtil((KerberosRealm)kerberosRealm);
        try (TimerScope ignored = Meters.getTimerScope((String)"kerberos.kdc.request", (String[])new String[]{"kerberos.realm", kerberosRealm.getKerberosRealmName()});){
            KerberosResult kerberosResult = kerberosUtil.validateTicketAndExtractSids(token.getDecodedData());
            principal = kerberosResult.getPrincipal();
            objectSid = kerberosResult.getObjectSid();
            sids = kerberosResult.getSids();
        }
        catch (KerberosException e) {
            throw new TokenProcessingException("Error processing Kerberos Token", (Throwable)e);
        }
        TokenContext tokenContext = new TokenContext();
        HashMap<String, AttributeValue> attrs = new HashMap<String, AttributeValue>(2);
        attrs.put("principal", new AttributeValue(principal));
        String[] parts = principal.split("@");
        String username = parts[0];
        String domain = parts.length == 2 ? parts[1] : null;
        attrs.put("username", new AttributeValue(username));
        attrs.put("domain", new AttributeValue(domain));
        attrs.put("objectSid", new AttributeValue(objectSid));
        attrs.put("sids", new AttributeValue((Collection)sids));
        tokenContext.setSubjectAttributes(attrs);
        return tokenContext;
    }

    public void configure(Configuration configuration) {
        this.kerberosRealmName = configuration.getFieldValue("Domain/Realm Name");
    }
}

