/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid;

import com.pingidentity.plugins.pcvs.pingid.AgentContext;
import com.pingidentity.plugins.pcvs.pingid.Config;
import com.pingidentity.plugins.pcvs.pingid.PingIdPCV;
import com.pingidentity.plugins.pcvs.pingid.RadiusServer;
import com.pingidentity.sdk.password.PasswordChallengeResult;
import com.pingidentity.sdk.password.PasswordCredentialChallengeException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.newjradius.exception.JRadiusException;
import org.accells.api.model.agent.AgentAuthStatus;
import org.accells.api.model.response.body.AgentAuthResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.newtinyradius.util.RadiusException;
import org.sourceid.saml20.domain.mgmt.impl.RadiusAdminUserException;

public enum AsyncPollingThreads {
    INSTANCE;

    private ScheduledThreadPoolExecutor taskScheduler = new ScheduledThreadPoolExecutor(5);
    private ExecutorService threadPoolExecutor;
    private static Log log;

    public void poll(AgentAuthResponse agentResponse, AgentContext agentContext, Config config, boolean isChallengeSupported) {
        if (agentContext.getPollAttempts() <= RadiusServer.MAX_POLL_ATTEMPTS) {
            this.taskScheduler.schedule(() -> this.threadPoolExecutor.submit(() -> {
                AgentAuthResponse agentAuthResponse = isChallengeSupported ? config.getPingIdPCV().secondFactorChallengeSupported(agentContext.getServerParams()) : config.getPingIdPCV().secondFactorNoChallenge(agentContext.getUserName(), agentContext.getPingIDUsername(), agentContext.getResponse(), agentResponse.getSessionId());
                try {
                    agentContext.increasePollAttempts();
                    if (isChallengeSupported) {
                        this.continueAsyncFlowChallengeSupported(agentAuthResponse, agentContext, config);
                    } else {
                        this.continueAsyncFlowNoChallenge(agentAuthResponse, agentContext, config);
                    }
                }
                catch (IOException ioe) {
                    log.error("RADIUS response could not be sent for username=" + agentContext.getServerParams().getUsername() + " message=" + ioe.getMessage());
                }
                catch (PasswordCredentialChallengeException e) {
                    RadiusAdminUserException hackEx = (RadiusAdminUserException)e.getCause();
                    String replyMessage = hackEx.getReplyMessage();
                    agentContext.getResponse().setPacketType(11);
                    agentContext.getResponse().addAttribute("Reply-Message", replyMessage);
                    agentContext.getResponse().addAttribute("State", hackEx.getState());
                    try {
                        PingIdPCV.sendResponseToClient(agentContext, config);
                    }
                    catch (IOException | InvalidKeyException | NoSuchAlgorithmException | JRadiusException | RadiusException ioe) {
                        log.error("RADIUS response could not be sent for username=" + agentContext.getServerParams().getUsername() + " message=" + ioe.getMessage());
                    }
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | JRadiusException | RadiusException e) {
                    log.error("RADIUS MSCHAPv2 response could not be sent for username=" + agentContext.getServerParams().getUsername() + " message=" + e.getMessage());
                }
            }), agentResponse.getTimeBetweenSamplesForAsyncAuthInMillis() != null ? Math.min(agentResponse.getTimeBetweenSamplesForAsyncAuthInMillis(), 10000L) : 2000L, TimeUnit.MILLISECONDS);
        } else {
            log.info("Max attempts for async authentication for user=" + agentContext.getServerParams().getUsername() + " reached, sending ACCESS_REJECT");
            agentContext.getResponse().addAttribute("Reply-Message", "Exceeded threshold");
            try {
                PingIdPCV.sendResponseToClient(agentContext, config);
            }
            catch (IOException ioe) {
                log.error("RADIUS response could not be sent for username=" + agentContext.getServerParams().getUsername() + " message=" + ioe.getMessage());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | JRadiusException | RadiusException e) {
                log.error("RADIUS response containing Message-Authenticator could not be sent for username=" + agentContext.getServerParams().getUsername() + " message=" + e.getMessage());
            }
        }
    }

    private void continueAsyncFlowNoChallenge(AgentAuthResponse agentResponse, AgentContext agentContext, Config config) throws IOException, JRadiusException, NoSuchAlgorithmException, InvalidKeyException, RadiusException {
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.ASYNC_AUTH_WAIT) {
            this.poll(agentResponse, agentContext, config, false);
        } else {
            RadiusServer.updateRadiusPacket(agentResponse, agentContext.getResponse());
            if (agentContext.getResponse().getPacketType() == 2) {
                RadiusServer.sendLdapInfoToRadiusClient(agentContext.getResponse(), agentContext.getAttributeMap(), config);
            }
            if (agentContext.getProxyStateModel() != null) {
                PingIdPCV.sendMschapResponseToClient(agentContext);
            } else {
                PingIdPCV.sendResponseToClient(agentContext, config);
            }
        }
    }

    private void continueAsyncFlowChallengeSupported(AgentAuthResponse agentResponse, AgentContext agentContext, Config config) throws PasswordCredentialChallengeException, IOException, NoSuchAlgorithmException, InvalidKeyException, JRadiusException, RadiusException {
        switch (agentResponse.getAgentAuthStatus()) {
            case ASYNC_AUTH_WAIT: {
                this.poll(agentResponse, agentContext, config, true);
                break;
            }
            case SUCCESS: {
                if (!agentContext.isAfterChallenge()) {
                    PingIdPCV.handleBeforeChallengeSuccess(agentContext.getAttributeMap(), agentContext.getServerParams().getUsername());
                    agentContext.getResponse().setPacketType(2);
                    RadiusServer.sendLdapInfoToRadiusClient(agentContext.getResponse(), agentContext.getAttributeMap(), config);
                } else {
                    PasswordChallengeResult passwordChallengeResult = PingIdPCV.handleAfterChallengeSuccess(agentResponse);
                    RadiusServer.handleAfterChallengeResult(passwordChallengeResult, agentContext.getResponse(), config);
                }
                PingIdPCV.sendResponseToClient(agentContext, config);
                break;
            }
            case MORE_INFO: {
                int attemptNumber = agentContext.isAfterChallenge() ? agentContext.getServerParams().getAttemptNumber() : 1;
                log.info("PingID RADIUS PCV username=" + agentContext.getServerParams().getUsername() + " return=ACCESS_CHALLENGE");
                throw PingIdPCV.makeChallengeEx(agentContext.getServerParams().getUsername(), attemptNumber, agentResponse.getSessionId(), agentResponse.getMessage(), agentResponse.getClientData(), agentContext.getSecondFactorLogic(), config);
            }
            default: {
                log.info("PingID RADIUS PCV CHALLENGE finished: username=" + agentContext.getServerParams().getUsername() + " message=" + agentResponse.getMessage());
                PingIdPCV.sendResponseToClient(agentContext, config);
            }
        }
    }

    public void init(int numberOfServerThreads) {
        ThreadPoolExecutor currentThreadPool = (ThreadPoolExecutor)this.threadPoolExecutor;
        if (this.threadPoolExecutor != null && currentThreadPool.getCorePoolSize() != numberOfServerThreads) {
            List<Runnable> runnables = this.threadPoolExecutor.shutdownNow();
            String logNumber = numberOfServerThreads == 0 ? "Integer.MAX_VALUE" : String.valueOf(numberOfServerThreads);
            log.debug("Creating new ThreadPool for async authentication with size=" + logNumber);
            this.threadPoolExecutor = numberOfServerThreads == 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(numberOfServerThreads);
            for (Runnable r : runnables) {
                this.threadPoolExecutor.submit(r);
            }
        } else if (this.threadPoolExecutor == null) {
            this.threadPoolExecutor = numberOfServerThreads == 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(numberOfServerThreads);
        }
    }

    static {
        log = LogFactory.getLog(AsyncPollingThreads.class);
    }
}

