/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid.AuditLogger;

import com.pingidentity.sdk.logging.LoggingUtil;
import org.accells.api.model.response.body.AgentAuthResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;

public class AuditLoggerHelper {
    public static final String DELEGATE_PCV_ID = "delegatePcvId";
    public static final String INVALID_PASSCODE = "Invalid passcode";
    private static final String MDS_TRACKINGID = "trackingid";
    private static final String ROLE = "RADIUS Server";
    private static final String PROTOCOL = "RADIUS";

    public static String getPcvContainerId() {
        try {
            String pcvId = ThreadContext.get((String)DELEGATE_PCV_ID);
            return StringUtils.isNotEmpty(pcvId) ? pcvId : "";
        }
        catch (NoClassDefFoundError e) {
            return "";
        }
    }

    public static void setThreadContext(String key, String value) {
        try {
            ThreadContext.put((String)key, (String)(StringUtils.isNoneEmpty(value) ? value : ""));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static void updateAuditLogDetails(String event, String status, String description, String username, String host, String trackingId) {
        try {
            LoggingUtil.setEvent((String)event);
            LoggingUtil.setStatus((String)status);
            LoggingUtil.setDescription((String)description);
            if (username != null) {
                LoggingUtil.setUserName((String)username);
            }
            LoggingUtil.setProtocol((String)PROTOCOL);
            LoggingUtil.setRole((String)ROLE);
            if (host != null) {
                LoggingUtil.setHost((String)host);
            }
            if (trackingId != null) {
                ThreadContext.put((String)MDS_TRACKINGID, (String)trackingId);
            }
            LoggingUtil.log((String)description);
            ThreadContext.put((String)MDS_TRACKINGID, (String)"");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static void updateAuditLogDetails(String event, String status, String description, String username, String host, String trackingId, boolean needToLog) {
        try {
            LoggingUtil.setEvent((String)event);
            LoggingUtil.setStatus((String)status);
            LoggingUtil.setDescription((String)description);
            LoggingUtil.setUserName((String)username);
            LoggingUtil.setProtocol((String)PROTOCOL);
            LoggingUtil.setRole((String)ROLE);
            if (host != null) {
                LoggingUtil.setHost((String)host);
            }
            if (trackingId != null) {
                ThreadContext.put((String)MDS_TRACKINGID, (String)trackingId);
            }
            if (needToLog) {
                LoggingUtil.log((String)description);
            }
            ThreadContext.put((String)MDS_TRACKINGID, (String)"");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static boolean isOldApi(AgentAuthResponse response) {
        try {
            response.getAgentAuthEvent();
            response.getPcvAuditDescription();
            return false;
        }
        catch (Throwable e) {
            return true;
        }
    }
}

