/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.pingidentity.plugins.pcvs.pingid.AgentContext;
import com.pingidentity.plugins.pcvs.pingid.AsyncPollingThreads;
import com.pingidentity.plugins.pcvs.pingid.AuditLogger.AuditEvents;
import com.pingidentity.plugins.pcvs.pingid.AuditLogger.AuditLoggerHelper;
import com.pingidentity.plugins.pcvs.pingid.AuditLogger.AuditMessages;
import com.pingidentity.plugins.pcvs.pingid.Config;
import com.pingidentity.plugins.pcvs.pingid.PCVContainer;
import com.pingidentity.plugins.pcvs.pingid.PingIdPCVHelper;
import com.pingidentity.plugins.pcvs.pingid.RADIUSUtils;
import com.pingidentity.plugins.pcvs.pingid.RadiusServer;
import com.pingidentity.plugins.pcvs.pingid.RadiusServerCoordinator;
import com.pingidentity.plugins.pcvs.pingid.ServerParams;
import com.pingidentity.plugins.pcvs.pingid.secondfactorlogic.SecondFactorLogic;
import com.pingidentity.plugins.pcvs.pingid.secondfactorlogic.SecondFactorLogicFactory;
import com.pingidentity.plugins.pcvs.pingid.vpnagent.VPNAgentConfig;
import com.pingidentity.plugins.pcvs.pingid.vpnagent.VPNAgentConfigEnum;
import com.pingidentity.plugins.pcvs.pingid.vpnagent.ldap.LdapAccess;
import com.pingidentity.plugins.pcvs.pingid.vpnagent.ldap.LdapRecord;
import com.pingidentity.plugins.pcvs.pingid.vpnagent.util.PingIdSecurityUtil;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.password.ChallengeablePasswordCredential;
import com.pingidentity.sdk.password.PasswordChallengeResult;
import com.pingidentity.sdk.password.PasswordCredentialChallengeException;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.PasswordValidationException;
import com.pingidentity.shaded.v0_3_8.jose4j.json.JsonUtil;
import com.pingidentity.shaded.v0_3_8.jose4j.jwt.IntDate;
import com.pingidentity.shaded.v0_3_8.jose4j.lang.JoseException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import net.newjradius.exception.JRadiusException;
import net.newjradius.packet.JRadiusPacket;
import net.newjradius.packet.PacketFactory;
import org.accells.api.model.agent.AgentAuthStatus;
import org.accells.api.model.response.body.AgentAuthResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.newtinyradius.packet.RadiusPacket;
import org.newtinyradius.util.RadiusException;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.RadiusAdminUserException;
import org.sourceid.util.log.AttributeMap;

public class PingIdPCV
implements PasswordCredentialValidator,
ChallengeablePasswordCredential {
    public static final String ATTEMPTS_CLAIM_NAME = "a";
    public static final String USERNAME_CLAIM_NAME = "u";
    public static final String PINGID_SESSION_ID_CLAIM_NAME = "i";
    public static final String EXPIRATION_CLAIM_NAME = "x";
    public static final String LOCAL_FALLBACK_RANDOM_CLAIM_NAME = "r";
    public static final String MEMBER_OF = "memberOf";
    public static final String USER_GROUP_TO_RADIUS_CLIENT = "__USER_GROUP_TO_RADIUS_CLIENT";
    public static final String LDAP_TO_RADIUS_CLIENT = "__LDAP_TO_RADIUS_CLIENT";
    public static final String SEPARATOR = ":";
    public static final String SEMICOLON = ";";
    RadiusServerCoordinator radiusServerCoordinator = RadiusServerCoordinator.getInstance();
    private static Log log = LogFactory.getLog(PingIdPCV.class);
    private Config config;
    private ThreadLocal<String> clientIpAddress = new ThreadLocal();
    private PingIdPCVHelper helper;
    private static final long THREE_MINUTES_IN_MILLIS = 180000L;

    public AttributeMap processPasswordCredential(String username, String password) throws PasswordValidationException {
        FirstFactorResult firstFactorResult = this.firstFactor(username, password);
        if (!firstFactorResult.continueToSecondFactor) {
            return firstFactorResult.returnObject;
        }
        String pingIdUsername = this.helper.getPingIdUsernameAttributeValue(firstFactorResult.getAttributeMap());
        String distinguishedName = this.helper.getDistinguishedNameAttributeValue(firstFactorResult.getAttributeMap());
        Map<String, List<String>> attributeMapToPingId = this.helper.getAttributeMappingToPingId(firstFactorResult.getAttributeMap());
        Map<String, String> attributeFieldsOfUserNeedToBeUpdated = this.helper.getUserUpdateFields(firstFactorResult.getAttributeMap());
        ServerParams serverParams = new ServerParams.Builder().username(username).ip(this.clientIpAddress.get()).isADValidate(firstFactorResult.isADValidate).config(this.config.getFieldsMap()).pingIDUsername(pingIdUsername == null ? username : pingIdUsername).attributeMapping(attributeMapToPingId).distinguishedName(distinguishedName).userUpdateFields(attributeFieldsOfUserNeedToBeUpdated).build();
        String userStateAttrVal = this.helper.getUserStateAttributeValue(firstFactorResult.getAttributeMap());
        this.loadLocalFallbackUserAttributes(serverParams, userStateAttrVal);
        SecondFactorLogic secondFactorLogic = new SecondFactorLogicFactory(serverParams).getSecondFactorLogic();
        AgentAuthResponse agentResponse = secondFactorLogic.doLogic();
        if (agentResponse == null) {
            log.info("PingID RADIUS PCV finished: username=" + username + ". return null");
            return null;
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.ASYNC_AUTH_WAIT) {
            serverParams.setSessionId(agentResponse.getSessionId());
            long timeBetweenSamples = agentResponse.getTimeBetweenSamplesForAsyncAuthInMillis() != null ? Math.min(agentResponse.getTimeBetweenSamplesForAsyncAuthInMillis(), 10000L) : 2000L;
            long startTimer = new Date().getTime();
            while (agentResponse.getAgentAuthStatus() == AgentAuthStatus.ASYNC_AUTH_WAIT && new Date().getTime() - startTimer < 180000L) {
                try {
                    Thread.sleep(timeBetweenSamples);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                agentResponse = secondFactorLogic.doLogic();
            }
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.MORE_INFO) {
            log.info("PingID RADIUS PCV finished: username=" + username + " return=ACCESS_CHALLENGE");
            throw PingIdPCV.makeChallengeEx(username, 1, agentResponse.getSessionId(), agentResponse.getMessage(), agentResponse.getClientData(), secondFactorLogic, this.config);
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.SUCCESS) {
            AttributeMap attributeMap = firstFactorResult.getAttributeMap();
            return PingIdPCV.handleBeforeChallengeSuccess(attributeMap, username);
        }
        if (StringUtils.isNotEmpty(agentResponse.getMessage())) {
            log.info("PingId response message=" + agentResponse.getMessage());
        }
        log.info("PingID RADIUS PCV finished: username=" + username + " return null");
        return null;
    }

    public AttributeMap processPasswordCredentialAsync(String username, String password) throws PasswordValidationException {
        FirstFactorResult firstFactorResult = this.firstFactor(username, password);
        if (!firstFactorResult.continueToSecondFactor) {
            return firstFactorResult.returnObject;
        }
        String pingIdUsername = this.helper.getPingIdUsernameAttributeValue(firstFactorResult.getAttributeMap());
        String distinguishedName = this.helper.getDistinguishedNameAttributeValue(firstFactorResult.getAttributeMap());
        Map<String, List<String>> attributeMapToPingId = this.helper.getAttributeMappingToPingId(firstFactorResult.getAttributeMap());
        Map<String, String> attributeFieldsOfUserNeedToBeUpdated = this.helper.getUserUpdateFields(firstFactorResult.getAttributeMap());
        ServerParams serverParams = new ServerParams.Builder().username(username).ip(this.clientIpAddress.get()).isADValidate(firstFactorResult.isADValidate).config(this.config.getFieldsMap()).pingIDUsername(pingIdUsername == null ? username : pingIdUsername).attributeMapping(attributeMapToPingId).distinguishedName(distinguishedName).userUpdateFields(attributeFieldsOfUserNeedToBeUpdated).build();
        String userStateAttrVal = this.helper.getUserStateAttributeValue(firstFactorResult.getAttributeMap());
        this.loadLocalFallbackUserAttributes(serverParams, userStateAttrVal);
        SecondFactorLogic secondFactorLogic = new SecondFactorLogicFactory(serverParams).getSecondFactorLogic();
        AgentAuthResponse agentResponse = secondFactorLogic.doLogic();
        AgentContext agentContextFromThread = RadiusServer.getAgentContextThreadLocal().get();
        if (agentResponse == null) {
            log.info("PingID RADIUS PCV finished: username=" + username + ". return null");
            return null;
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.ASYNC_AUTH_WAIT) {
            AgentContext agentContext = this.initAsyncAgentContext(agentContextFromThread, serverParams, agentResponse, secondFactorLogic, firstFactorResult.getAttributeMap(), false);
            AsyncPollingThreads.INSTANCE.poll(agentResponse, agentContext, this.config, true);
            return null;
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.MORE_INFO) {
            log.info("PingID RADIUS PCV finished: username=" + username + " return=ACCESS_CHALLENGE");
            throw PingIdPCV.makeChallengeEx(username, 1, agentResponse.getSessionId(), agentResponse.getMessage(), agentResponse.getClientData(), secondFactorLogic, this.config);
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.SUCCESS) {
            AttributeMap attributeMap = firstFactorResult.getAttributeMap();
            return PingIdPCV.handleBeforeChallengeSuccess(attributeMap, username);
        }
        if (StringUtils.isNotEmpty(agentResponse.getMessage())) {
            log.info("PingId response message=" + agentResponse.getMessage());
        }
        log.info("PingID RADIUS PCV finished: username=" + username + " return null");
        return null;
    }

    private boolean isMemberOfRelevant() {
        return this.config.isMemberOfRelevant();
    }

    private boolean isMemberOfBypassRelevant() {
        return this.config.isMemberOfBypassRelevant();
    }

    public static PasswordCredentialChallengeException makeChallengeEx(String username, int attemptNumber, String pingIdSessionId, String msgkey, String localFallbackRandom, SecondFactorLogic secondFactorLogic, Config config) {
        AdminUserException.Code challengeCode = AdminUserException.Code.RADIUS_ACCESS_CHALLENGE;
        byte[] state = PingIdPCV.makeState(username, attemptNumber, pingIdSessionId, localFallbackRandom, secondFactorLogic, config);
        RadiusAdminUserException hackEx = new RadiusAdminUserException(challengeCode, username, state, msgkey);
        throw new PasswordCredentialChallengeException(true, msgkey, (Throwable)hackEx);
    }

    public PasswordChallengeResult challenge(String username, String password, Object stateObj) {
        log.info("PingID RADIUS PCV CHALLENGE started: username=" + username);
        StateHolder stateHolder = this.checkState(stateObj, username);
        String pingIdSessionId = stateHolder.getPingIdSessionId();
        int attemptNumber = stateHolder.getAttemptNumber();
        String rand = stateHolder.getLocalFallbackRandom();
        ServerParams serverParams = new ServerParams.Builder().username(username).sessionId(pingIdSessionId).challengeData(password).isADValidate(true).config(this.config.getFieldsMap()).localFallbackRandom(rand).attemptNumber(attemptNumber).build();
        this.loadLocalFallbackUserAttributes(serverParams, null);
        SecondFactorLogic secondFactorLogic = new SecondFactorLogicFactory(serverParams).getSecondFactorLogic();
        AgentAuthResponse agentResponse = secondFactorLogic.doLogic();
        if (agentResponse == null) {
            log.info("PingID RADIUS PCV finished: username=" + username + ". return null");
            return null;
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.ASYNC_AUTH_WAIT) {
            serverParams.setSessionId(agentResponse.getSessionId());
            long timeBetweenSamples = agentResponse.getTimeBetweenSamplesForAsyncAuthInMillis() != null ? Math.min(agentResponse.getTimeBetweenSamplesForAsyncAuthInMillis(), 10000L) : 2000L;
            long startTimer = new Date().getTime();
            while (agentResponse.getAgentAuthStatus() == AgentAuthStatus.ASYNC_AUTH_WAIT && new Date().getTime() - startTimer < 180000L) {
                try {
                    Thread.sleep(timeBetweenSamples);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                agentResponse = secondFactorLogic.doLogic();
            }
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.MORE_INFO) {
            log.info("PingID RADIUS PCV finished: username=" + username + " return=ACCESS_CHALLENGE");
            throw PingIdPCV.makeChallengeEx(username, attemptNumber + 1, agentResponse.getSessionId(), agentResponse.getMessage(), agentResponse.getClientData(), secondFactorLogic, this.config);
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.SUCCESS) {
            log.info("PingID RADIUS PCV CHALLENGE finished: username=" + username + " return=ACCESS_ACCEPT");
            return PingIdPCV.handleAfterChallengeSuccess(agentResponse);
        }
        if (StringUtils.isNotEmpty(agentResponse.getMessage())) {
            log.info("PingId response message=" + agentResponse.getMessage());
        }
        log.info("PingID RADIUS PCV CHALLENGE finished: username=" + username + " return=invalid passcode");
        throw new PasswordCredentialValidatorAuthnException(false, "invalid passcode");
    }

    public PasswordChallengeResult challengeAsync(String username, String password, Object stateObj) {
        log.info("PingID RADIUS PCV CHALLENGE started: username=" + username);
        StateHolder stateHolder = this.checkState(stateObj, username);
        String pingIdSessionId = stateHolder.getPingIdSessionId();
        int attemptNumber = stateHolder.getAttemptNumber();
        String rand = stateHolder.getLocalFallbackRandom();
        ServerParams serverParams = new ServerParams.Builder().username(username).sessionId(pingIdSessionId).challengeData(password).isADValidate(true).config(this.config.getFieldsMap()).localFallbackRandom(rand).attemptNumber(attemptNumber).build();
        this.loadLocalFallbackUserAttributes(serverParams, null);
        SecondFactorLogic secondFactorLogic = new SecondFactorLogicFactory(serverParams).getSecondFactorLogic();
        AgentAuthResponse agentResponse = secondFactorLogic.doLogic();
        AgentContext agentContextFromThread = RadiusServer.getAgentContextThreadLocal().get();
        if (agentResponse == null) {
            log.info("PingID RADIUS PCV finished: username=" + username + ". return null");
            return null;
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.ASYNC_AUTH_WAIT) {
            AgentContext agentContext = this.initAsyncAgentContext(agentContextFromThread, serverParams, agentResponse, secondFactorLogic, null, true);
            AsyncPollingThreads.INSTANCE.poll(agentResponse, agentContext, this.config, true);
            return null;
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.MORE_INFO) {
            log.info("PingID RADIUS PCV finished: username=" + username + " return=ACCESS_CHALLENGE");
            throw PingIdPCV.makeChallengeEx(username, attemptNumber + 1, agentResponse.getSessionId(), agentResponse.getMessage(), agentResponse.getClientData(), secondFactorLogic, this.config);
        }
        if (agentResponse.getAgentAuthStatus() == AgentAuthStatus.SUCCESS) {
            log.info("PingID RADIUS PCV CHALLENGE finished: username=" + username + " return=ACCESS_ACCEPT");
            return PingIdPCV.handleAfterChallengeSuccess(agentResponse);
        }
        if (StringUtils.isNotEmpty(agentResponse.getMessage())) {
            log.info("PingId response message=" + agentResponse.getMessage());
        }
        log.info("PingID RADIUS PCV CHALLENGE finished: username=" + username + " return=invalid passcode");
        throw new PasswordCredentialValidatorAuthnException(false, "invalid passcode");
    }

    public static void sendResponseToClient(AgentContext agentContext, Config config) throws IOException, JRadiusException, NoSuchAlgorithmException, InvalidKeyException, RadiusException {
        if (config.isMsgAuthValidationRequired(agentContext.getClient().getAddress())) {
            log.debug("Sending response with Message-Authenticator attribute to RADIUS client=" + agentContext.getClient().getAddress().getHostAddress());
            PingIdPCV.sendMsgAuthenticatorResponseToClient(agentContext);
        } else {
            DatagramSocket s = agentContext.getSocket();
            log.info("send response: " + agentContext.getResponse());
            DatagramPacket packetOut = org.newtinyradius.util.RadiusServer.makeDatagramPacket(agentContext.getResponse(), agentContext.getClientSecret(), agentContext.getClient().getAddress(), agentContext.getClient().getPort(), agentContext.getRequest());
            s.send(packetOut);
        }
    }

    public static void sendMschapResponseToClient(AgentContext agentContext) throws IOException, JRadiusException, NoSuchAlgorithmException, InvalidKeyException, RadiusException {
        DatagramSocket s = agentContext.getSocket();
        JRadiusPacket packetOut = PacketFactory.parse(org.newtinyradius.util.RadiusServer.makeDatagramPacket(agentContext.getResponse(), agentContext.getClientSecret(), agentContext.getClient().getAddress(), agentContext.getClient().getPort(), agentContext.getRequest()), false);
        DatagramPacket mschapResponse = agentContext.getResponse().getPacketType() == 2 ? RADIUSUtils.generateAccessAccept(packetOut, agentContext.getProxyStateModel(), agentContext.getClientSecret()) : RADIUSUtils.generateAccessReject(packetOut, agentContext.getProxyStateModel(), agentContext.getClientSecret());
        RadiusPacket responsePacket = org.newtinyradius.util.RadiusServer.makeRadiusPacket(mschapResponse, agentContext.getClientSecret(), false);
        log.info("send response: " + responsePacket);
        s.send(mschapResponse);
    }

    private static void sendMsgAuthenticatorResponseToClient(AgentContext agentContext) throws IOException, JRadiusException, NoSuchAlgorithmException, InvalidKeyException, RadiusException {
        DatagramSocket s = agentContext.getSocket();
        JRadiusPacket packetOut = PacketFactory.parse(org.newtinyradius.util.RadiusServer.makeDatagramPacket(agentContext.getResponse(), agentContext.getClientSecret(), agentContext.getClient().getAddress(), agentContext.getClient().getPort(), agentContext.getRequest()), false);
        DatagramPacket response = RADIUSUtils.generateMessageAuthenticatorPapResponse(packetOut, agentContext.getClientSecret(), agentContext.getRequest(), agentContext.getClient());
        RadiusPacket responsePacket = org.newtinyradius.util.RadiusServer.makeRadiusPacket(response, agentContext.getClientSecret(), false);
        log.info("send response: " + responsePacket);
        s.send(response);
    }

    public static AttributeMap handleBeforeChallengeSuccess(AttributeMap attributeMap, String username) {
        if (MapUtils.isNotEmpty((Map)attributeMap)) {
            log.info("PingID RADIUS PCV finished: username=" + username + " return=" + attributeMap);
            return attributeMap;
        }
        attributeMap = new AttributeMap();
        attributeMap.put("username", username);
        log.info("PingID RADIUS PCV finished: username=" + username + " return=" + attributeMap);
        return attributeMap;
    }

    public static PasswordChallengeResult handleAfterChallengeSuccess(AgentAuthResponse agentResponse) {
        Map attributeMapping = null;
        String clientData = agentResponse.getClientData();
        if (clientData != null && clientData.contains("__PID_AGENT_CONTEXT:")) {
            String attributeMapStr = clientData.substring(clientData.indexOf("__PID_AGENT_CONTEXT:") + "__PID_AGENT_CONTEXT:".length());
            try {
                Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
                attributeMapping = (Map)new Gson().fromJson(attributeMapStr, type);
            }
            catch (JsonSyntaxException e) {
                log.error(e.getMessage() + ". Exception while parsing the JSON = " + agentResponse.getClientData());
            }
        }
        if (attributeMapping == null || attributeMapping.size() == 0) {
            return new PasswordChallengeResult();
        }
        PasswordChallengeResult passwordChallengeResult = new PasswordChallengeResult();
        passwordChallengeResult.addAttributes(attributeMapping);
        return passwordChallengeResult;
    }

    private AgentContext initAsyncAgentContext(AgentContext agentContextFromThread, ServerParams serverParams, AgentAuthResponse agentResponse, SecondFactorLogic secondFactorLogic, AttributeMap attributeMap, boolean isAfterChallenge) {
        AgentContext agentContext = agentContextFromThread;
        if (agentContextFromThread == null) {
            agentContext = new AgentContext();
        }
        serverParams.setSessionId(agentResponse.getSessionId());
        agentContext.setServerParams(serverParams);
        agentContext.setSecondFactorLogic(secondFactorLogic);
        agentContext.setAfterChallenge(isAfterChallenge);
        agentContext.setAttributeMap(attributeMap);
        agentContext.setAsyncAuth(true);
        return agentContext;
    }

    private void loadLocalFallbackUserAttributes(ServerParams serverParams, String userStateAttrVal) {
        try {
            String ldapIndex = this.config.getFieldsMap().get(VPNAgentConfigEnum.FIELD_LDAP_DATASOURCE.getName());
            if (ldapIndex != null && !"".equals(ldapIndex)) {
                PingIdPCVHelper.loadLocalFallbackUserAttributes(serverParams, userStateAttrVal);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage() + ". Failed to load local fallback information from directory for user=" + serverParams.getUsername());
        }
    }

    public AgentAuthResponse secondFactorNoChallenge(String userName, String pingIdUsername, RadiusPacket radiusPacket, String sessionId) {
        boolean isEAPFlow = radiusPacket.getPacketType() == 2 && radiusPacket.getAttribute(79) != null;
        ServerParams serverParams = new ServerParams.Builder().username(userName).ip(this.clientIpAddress.get()).isADValidate(true).config(this.config.getFieldsMap()).pingIDUsername(pingIdUsername).isEAP(isEAPFlow).challengeSupported(false).isMschapFlow(this.config.isProxy()).sessionId(sessionId).build();
        SecondFactorLogic secondFactorLogic = new SecondFactorLogicFactory(serverParams).getSecondFactorLogic();
        return secondFactorLogic.doLogic();
    }

    public AgentAuthResponse secondFactorSendOTP(String userName, String otp, String PingIDUsername, RadiusPacket radiusPacket) {
        boolean isEAPFlow = radiusPacket.getPacketType() == 2 && radiusPacket.getAttribute(79) != null;
        ServerParams serverParams = new ServerParams.Builder().username(userName).otp(otp).ip(this.clientIpAddress.get()).isADValidate(true).config(this.config.getFieldsMap()).pingIDUsername(PingIDUsername).isEAP(isEAPFlow).challengeSupported(false).isMschapFlow(this.config.isProxy()).build();
        SecondFactorLogic secondFactorLogic = new SecondFactorLogicFactory(serverParams).getSecondFactorLogic();
        return secondFactorLogic.doLogic();
    }

    public AgentAuthResponse secondFactorChallengeSupported(ServerParams serverParams) {
        SecondFactorLogic secondFactorLogic = new SecondFactorLogicFactory(serverParams).getSecondFactorLogic();
        return secondFactorLogic.doLogic();
    }

    public Map<String, String> loadLDAPUserAttributes(Config config, String username) throws NamingException {
        ServerParams serverParams = new ServerParams.Builder().username(username).config(config.getFieldsMap()).build();
        LdapRecord record = LdapAccess.getUserLdapAttributes(serverParams, null);
        Map<String, String> attributeValues = null;
        if (record != null) {
            attributeValues = record.getAttributes();
        }
        if (attributeValues == null) {
            attributeValues = new HashMap<String, String>();
        }
        return attributeValues;
    }

    public FirstFactorResult firstFactor(String username, String password) {
        boolean isMemberOf;
        boolean bl;
        boolean isMemberOfBypass;
        log.info("PingID RADIUS PCV started: username=" + username);
        String appName = this.config.getFieldsMap().get(VPNAgentConfigEnum.APPLICATION_NAME.getName());
        log.info("Application name=" + appName);
        boolean isADValidate = false;
        AttributeMap attributeMap = new AttributeMap();
        if (CollectionUtils.isNotEmpty(this.config.getDelegatePCV()) && this.config.getDelegatePCV().get(0).getPcvId().equals(VPNAgentConfigEnum.LDAP_FOR_ATTRIBUTES.getName())) {
            try {
                Map<String, String> ldapAttributeMap = this.loadLDAPUserAttributes(this.config, username);
                for (Map.Entry<String, String> entry : ldapAttributeMap.entrySet()) {
                    attributeMap.put(entry.getKey(), entry.getValue());
                }
            }
            catch (NamingException e) {
                log.error("Failed to load user attributes from LDAP");
                log.debug("Failed to load user attributes from LDAP", e);
            }
            isADValidate = true;
        } else {
            List<PCVContainer> delegatePCVs = this.config.getDelegatePCV();
            if (delegatePCVs == null || delegatePCVs.size() == 0) {
                log.info("No delegate PCV defined");
                isADValidate = true;
            } else {
                attributeMap = null;
                for (PCVContainer pcvContaner : delegatePCVs) {
                    try {
                        log.debug("Trying to use delegate PCV " + pcvContaner.getPcvId());
                        PasswordCredentialValidator delegatePCV = pcvContaner.getPcv();
                        AuditLoggerHelper.setThreadContext("delegatePcvId", pcvContaner.getPcvId());
                        attributeMap = delegatePCV.processPasswordCredential(username, password);
                        if (MapUtils.isNotEmpty((Map)attributeMap)) {
                            log.debug("success auth delegate PCV " + pcvContaner.getPcvId());
                            log.debug("attributeMap recieved from the delegate PCV = " + attributeMap);
                            break;
                        }
                        log.debug("failed auth delegate PCV " + pcvContaner.getPcvId());
                        if (this.config.isChallengeNotSupported()) continue;
                        AuditLoggerHelper.updateAuditLogDetails(AuditEvents.DELEGATION.getName(), AuditEvents.FAILURE.getName(), String.format(AuditMessages.DELEGATED_PCV_FAILURE.getMessage(), pcvContaner.getPcvId()), username, this.clientIpAddress.get(), null);
                    }
                    catch (PasswordValidationException e) {
                        log.debug("failed auth delegate PCV " + e.getMessage() + pcvContaner.getPcvId());
                        if (this.config.isChallengeNotSupported()) continue;
                        AuditLoggerHelper.updateAuditLogDetails(AuditEvents.DELEGATION.getName(), AuditEvents.FAILURE.getName(), String.format(AuditMessages.DELEGATED_PCV_FAILURE.getMessage(), pcvContaner.getPcvId()), username, this.clientIpAddress.get(), null);
                    }
                }
                isADValidate = MapUtils.isNotEmpty((Map)attributeMap);
            }
        }
        boolean continueToSecondFactor = true;
        boolean bl2 = false;
        AttributeMap returnedObject = null;
        if (this.isMemberOfBypassRelevant() && (isMemberOfBypass = this.helper.isMemberOfBypass(attributeMap, username))) {
            log.debug("User=" + username + " is member of Bypass group. Applying policy ACCEPT.");
            continueToSecondFactor = false;
            bl = true;
            AuditLoggerHelper.updateAuditLogDetails(AuditEvents.DELEGATION.getName(), AuditEvents.SUCCESS.getName(), AuditMessages.USER_IN_BYPASS_GROUPS.getMessage(), username, this.clientIpAddress.get(), null);
            returnedObject = attributeMap;
        }
        if (!bl && this.isMemberOfRelevant() && !(isMemberOf = this.helper.isMemberOf(attributeMap))) {
            continueToSecondFactor = false;
            if (this.config.getPolicyUserNoInGroup()) {
                log.debug("User " + username + " is not in the configured LDAP group applying policy REJECT");
                AuditLoggerHelper.updateAuditLogDetails(AuditEvents.BLOCKED.getName(), AuditEvents.FAILURE.getName(), AuditMessages.USER_NOT_IN_GROUPS.getMessage(), username, this.clientIpAddress.get(), null);
                returnedObject = null;
            } else {
                log.debug("User " + username + " is not in the configured LDAP group applying policy ACCEPT");
                AuditLoggerHelper.updateAuditLogDetails(AuditEvents.DELEGATION.getName(), AuditEvents.SUCCESS.getName(), AuditMessages.USER_NOT_IN_GROUPS_BYPASS.getMessage(), username, this.clientIpAddress.get(), null);
                returnedObject = attributeMap;
            }
        }
        return new FirstFactorResult(isADValidate, attributeMap, continueToSecondFactor, returnedObject);
    }

    static byte[] makeState(String username, int attemptNumber, String pingIdSessionId, String localFallbackRandom, SecondFactorLogic secondFactorLogic, Config config) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        IntDate exp = IntDate.now();
        exp.addSeconds(config.getStateLife());
        claims.put(EXPIRATION_CLAIM_NAME, exp.getValue());
        claims.put(ATTEMPTS_CLAIM_NAME, attemptNumber);
        if (secondFactorLogic.isLocalAuthentication()) {
            claims.put(LOCAL_FALLBACK_RANDOM_CLAIM_NAME, localFallbackRandom);
        } else {
            claims.put(PINGID_SESSION_ID_CLAIM_NAME, pingIdSessionId);
        }
        try {
            String hashedUsername = PingIdSecurityUtil.hashUsername(username);
            claims.put(USERNAME_CLAIM_NAME, hashedUsername);
            String json = JsonUtil.toJson(claims);
            String encryptedState = PingIdSecurityUtil.encryptJwe(json, config.getStateEncryptionKey(), "A128CBC-HS256");
            return encryptedState.getBytes();
        }
        catch (JoseException | NoSuchAlgorithmException e) {
            log.error("Error creating encrypted state attribute: " + e.getMessage());
            throw new PasswordValidationException("Unexpected problem creating challenge state.", (Throwable)e);
        }
    }

    StateHolder checkState(Object state, String username) throws PasswordCredentialValidatorAuthnException {
        Map<String, Object> claims;
        if (state == null) {
            throw new PasswordCredentialValidatorAuthnException(false, "State not provided .");
        }
        byte[] stateData = (byte[])state;
        try {
            String jsonPayload = PingIdSecurityUtil.decryptJwe(new String(stateData), this.config.getStateEncryptionKey());
            claims = JsonUtil.parseJson(jsonPayload);
        }
        catch (JoseException e) {
            log.error("Error decrypting state attribute: " + e.getMessage());
            throw new PasswordCredentialValidatorAuthnException(false, "Unable to process state.", (Throwable)e);
        }
        String sub = (String)claims.get(USERNAME_CLAIM_NAME);
        try {
            String hashedUsername = PingIdSecurityUtil.hashUsername(username);
            if (!hashedUsername.equals(sub)) {
                throw new PasswordCredentialValidatorAuthnException(false, "Username mismatch in state.");
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Unable to hash username: " + e.getMessage());
            throw new PasswordCredentialValidatorAuthnException(false, "Unable to verify state.", (Throwable)e);
        }
        Number expNumber = (Number)claims.get(EXPIRATION_CLAIM_NAME);
        IntDate exp = IntDate.fromSeconds(expNumber.longValue());
        IntDate now = IntDate.now();
        if (now.after(exp)) {
            throw new PasswordCredentialValidatorAuthnException(false, "State expired.");
        }
        String pingIdSessionId = (String)claims.get(PINGID_SESSION_ID_CLAIM_NAME);
        String random = (String)claims.get(LOCAL_FALLBACK_RANDOM_CLAIM_NAME);
        Number numberOfAttempts = (Number)claims.get(ATTEMPTS_CLAIM_NAME);
        return new StateHolder(numberOfAttempts.intValue(), pingIdSessionId, random);
    }

    public void configure(Configuration configuration) {
        this.config = new Config(configuration, this);
        this.config.getFieldsMap().put(VPNAgentConfigEnum.LOCAL_FALLBACK_DEVICES_CACHE.getName(), VPNAgentConfigEnum.LOCAL_FALLBACK_DEVICES_CACHE_ATTRIBUTE_NAME.getName());
        if (StringUtils.isEmpty(this.config.getFieldsMap().get(VPNAgentConfigEnum.APPLICATION_NAME.getName()))) {
            this.config.getFieldsMap().put(VPNAgentConfigEnum.APPLICATION_NAME.getName(), VPNAgentConfigEnum.DEFAULT_APP_NAME.getName());
        }
        Map<String, String> adjustedFields = this.adjustConfigurationDuringUpgrade(this.config.getFieldsMap());
        for (Map.Entry<String, String> entry : adjustedFields.entrySet()) {
            this.config.getFieldsMap().put(entry.getKey(), entry.getValue());
        }
        this.radiusServerCoordinator.onConfigure(this.config);
        VPNAgentConfig.get().initPingIdClient(this.config.getFieldsMap());
        this.initHelper();
        AsyncPollingThreads.INSTANCE.init(this.config.getServerThreads());
    }

    public void onInstanceRemoved() {
        log.debug("onInstanceRemoved " + this.config.getConfiguration().getId());
    }

    public void setIpAddress(String clientIpAddress) {
        this.clientIpAddress.set(clientIpAddress);
    }

    public void removeIpAddress() {
        this.clientIpAddress.remove();
    }

    private Map<String, String> adjustConfigurationDuringUpgrade(Map<String, String> oldConfiguration) {
        String uiBypassPingIdFieldValue;
        String OLD_FIELD_BYPASS_PINGID = "FAIL Login on PingID technical error";
        String NEW_FIELD_BYPASS_PINGID = VPNAgentConfigEnum.POLICY_OUTAGE_CONFIG.getName();
        String NEW_TIMEOUT = VPNAgentConfigEnum.PINGID_SERVICE_TIMEOUT.getName();
        HashMap<String, String> result = new HashMap<String, String>();
        String bypassPingId = null;
        if (!"".equals(oldConfiguration.get(OLD_FIELD_BYPASS_PINGID)) && oldConfiguration.get(OLD_FIELD_BYPASS_PINGID) != null) {
            log.debug("Configuration adjustment: Found legacy configuration: FAIL Login on PingID technical error=" + oldConfiguration.get(OLD_FIELD_BYPASS_PINGID));
            boolean legacyBlock = Boolean.parseBoolean(oldConfiguration.get(OLD_FIELD_BYPASS_PINGID));
            String string = bypassPingId = legacyBlock ? VPNAgentConfigEnum.POLICY_TECH_ERROR.getName() : VPNAgentConfigEnum.POLICY_TECH_ERROR_BYPASS.getName();
        }
        if ((uiBypassPingIdFieldValue = oldConfiguration.get(NEW_FIELD_BYPASS_PINGID)) != null && !uiBypassPingIdFieldValue.isEmpty()) {
            log.debug("Configuration adjustment: Block/Bypass configuration already set in UI to:" + uiBypassPingIdFieldValue + ". Using it.");
            bypassPingId = uiBypassPingIdFieldValue;
        }
        String timeoutConfig = Config.DEFAULT_TIMEOUT;
        String uiTimeoutFieldValue = oldConfiguration.get(NEW_TIMEOUT);
        if (uiTimeoutFieldValue != null && !uiTimeoutFieldValue.isEmpty()) {
            log.debug("Configuration adjustment: Timeout configuration already set in UI to:" + uiTimeoutFieldValue + ". Using it.");
            timeoutConfig = uiTimeoutFieldValue;
        }
        if (bypassPingId != null) {
            result.put(NEW_FIELD_BYPASS_PINGID, bypassPingId);
        }
        result.put(NEW_TIMEOUT, timeoutConfig);
        return result;
    }

    public PluginDescriptor getPluginDescriptor() {
        return Config.makePluginDescriptor();
    }

    public Config getConfig() {
        return this.config;
    }

    public ThreadLocal<String> getClientIpAddress() {
        return this.clientIpAddress;
    }

    public PingIdPCVHelper getHelper() {
        return this.helper;
    }

    protected void initHelper() {
        this.helper = new PingIdPCVHelper(this.config);
    }

    public class FirstFactorResult {
        private boolean isADValidate;
        private AttributeMap attributeMap;
        private boolean continueToSecondFactor;
        private AttributeMap returnObject;

        public FirstFactorResult(boolean isADValidate, AttributeMap attributeMap, boolean continueToSecondFactor, AttributeMap returnObject) {
            this.isADValidate = isADValidate;
            this.attributeMap = attributeMap;
            this.continueToSecondFactor = continueToSecondFactor;
            this.returnObject = returnObject;
        }

        public boolean isADValidate() {
            return this.isADValidate;
        }

        public void setADValidate(boolean isADValidate) {
            this.isADValidate = isADValidate;
        }

        public AttributeMap getAttributeMap() {
            return this.attributeMap;
        }

        public void setAttributeMap(AttributeMap attributeMap) {
            this.attributeMap = attributeMap;
        }

        public boolean isContinueToSecondFactor() {
            return this.continueToSecondFactor;
        }

        public void setContinueToSecondFactor(boolean continueToSecondFactor) {
            this.continueToSecondFactor = continueToSecondFactor;
        }

        public AttributeMap getReturnObject() {
            return this.returnObject;
        }

        public void setReturnObject(AttributeMap returnObject) {
            this.returnObject = returnObject;
        }
    }

    static class StateHolder {
        private final int attemptNumber;
        private final String pingIdSessionId;
        private final String localFallbackRandom;

        StateHolder(int attemptNumber, String pingIdSessionId, String localFallbackRandom) {
            this.attemptNumber = attemptNumber;
            this.pingIdSessionId = pingIdSessionId;
            this.localFallbackRandom = localFallbackRandom;
        }

        int getAttemptNumber() {
            return this.attemptNumber;
        }

        String getPingIdSessionId() {
            return this.pingIdSessionId;
        }

        String getLocalFallbackRandom() {
            return this.localFallbackRandom;
        }
    }
}

