/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid;

import com.pingidentity.plugins.pcvs.pingid.Config;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.newtinyradius.attribute.IntegerAttribute;
import org.newtinyradius.attribute.IpAttribute;
import org.newtinyradius.attribute.RadiusAttribute;
import org.newtinyradius.attribute.StringAttribute;
import org.newtinyradius.dictionary.AttributeType;
import org.newtinyradius.dictionary.MemoryDictionary;
import org.newtinyradius.dictionary.WritableDictionary;

public class RADIUSMappingHelper {
    public static WritableDictionary createTempDictionary(Config.VSADescription vsa, String vsaType) {
        MemoryDictionary d = new MemoryDictionary();
        int vendor = vsa.getVsaVendorID();
        String name = vsa.getVsaName();
        int code = vsa.getVsaNumber();
        String typeStr = vsaType;
        Class type = RADIUSMappingHelper.getAttributeTypeClass(typeStr);
        AttributeType at = new AttributeType(vendor, code, name, type);
        d.addAttributeType(at);
        return d;
    }

    public static byte[] encodeAttributeValueToByteArr(String ldapMultyValue, String typeStr) throws IllegalArgumentException {
        switch (typeStr.toLowerCase()) {
            case "integer": 
            case "date": {
                try {
                    int value = Integer.parseInt(ldapMultyValue);
                    byte[] dataInt = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
                    return dataInt;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(ldapMultyValue + " cannot be parsed to Integer type");
                }
            }
            case "ipaddr": {
                if (ldapMultyValue == null || ldapMultyValue.length() < 7 || ldapMultyValue.length() > 15) {
                    throw new IllegalArgumentException("bad IP number");
                }
                StringTokenizer tok = new StringTokenizer(ldapMultyValue, ".");
                if (tok.countTokens() != 4) {
                    throw new IllegalArgumentException("bad IP number: 4 numbers required");
                }
                byte[] dataIpAddr = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    int num = Integer.parseInt(tok.nextToken());
                    if (num < 0 || num > 255) {
                        throw new IllegalArgumentException("bad IP number: num out of bounds");
                    }
                    dataIpAddr[i] = (byte)num;
                }
                return dataIpAddr;
            }
        }
        try {
            return ldapMultyValue.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return ldapMultyValue.getBytes();
        }
    }

    private static Class getAttributeTypeClass(String typeStr) {
        Class<RadiusAttribute> type = RadiusAttribute.class;
        if (typeStr.equalsIgnoreCase("string")) {
            type = StringAttribute.class;
        } else if (typeStr.equalsIgnoreCase("octets")) {
            type = RadiusAttribute.class;
        } else if (typeStr.equalsIgnoreCase("integer") || typeStr.equalsIgnoreCase("date")) {
            type = IntegerAttribute.class;
        } else if (typeStr.equalsIgnoreCase("ipaddr")) {
            type = IpAttribute.class;
        }
        return type;
    }
}

