/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid;

import com.pingidentity.plugins.pcvs.pingid.RadiusServer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import net.newjradius.packet.AccessAccept;
import net.newjradius.packet.AccessChallenge;
import net.newjradius.packet.AccessReject;
import net.newjradius.packet.AccessResponse;
import net.newjradius.packet.JRadiusPacket;
import net.newjradius.packet.JRadiusResponse;
import net.newjradius.packet.PacketFactory;
import net.newjradius.packet.attribute.AttributeFactory;
import net.newjradius.packet.attribute.RadiusAttribute;
import net.newjradius.util.MessageAuthenticator;
import org.newtinyradius.packet.RadiusPacket;
import org.newtinyradius.util.ProxyStateModel;

public class RADIUSUtils {
    public static void copyAttributesWithoutPCVProxyState(JRadiusPacket packetIn, AccessResponse res) {
        for (RadiusAttribute attr : packetIn.getAttributes().getAttributeList()) {
            if (attr.getType() == 33L) {
                try {
                    String temp = new String((byte[])attr.getValue().getValueObject());
                    ProxyStateModel.fromJsonString(temp);
                }
                catch (Exception e) {
                    res.addAttribute(attr);
                }
                continue;
            }
            res.addAttribute(attr);
        }
    }

    public static DatagramPacket generateAccessAccept(JRadiusPacket packetIncome, ProxyStateModel proxyState, String secret) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        JRadiusPacket dummyPacket = PacketFactory.newPacket(2);
        dummyPacket.setAuthenticator(proxyState.getAuth());
        AccessAccept res = new AccessAccept();
        res.setIdentifier(packetIncome.getIdentifier());
        RADIUSUtils.copyAttributesWithoutPCVProxyState(packetIncome, res);
        MessageAuthenticator.generateResponseMessageAuthenticatorAsFirstAttribute(dummyPacket.getAuthenticator(), res, secret);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        res.generateAuthenticator(proxyState.getAuth(), secret);
        RadiusServer.format.packPacket(res, secret, buffer, true);
        return new DatagramPacket(buffer.array(), buffer.position(), InetAddress.getByName(proxyState.getHost()), proxyState.getPort());
    }

    public static DatagramPacket generateAccessReject(JRadiusPacket packetIncome, ProxyStateModel proxyState, String secret) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        AccessResponse res;
        JRadiusPacket dummyPacket = PacketFactory.newPacket(3);
        dummyPacket.setAuthenticator(proxyState.getAuth());
        if (packetIncome.findAttribute(79L) != null) {
            String str = "\u0001\u0002\u00009\u001a\u0004\u0001\u00004E=691 R=1 C=51A24A1549211D5260596AC4026B8FAD V=3";
            res = new AccessChallenge();
            res.setIdentifier(packetIncome.getIdentifier());
            RADIUSUtils.copyAttributesWithoutPCVProxyState(packetIncome, res);
            String reply = "PingID authentication failed";
            AttributeFactory.addToAttributeList(res.getAttributes(), 18L, reply.getBytes(), res.isRecyclable());
            RadiusAttribute a = res.findAttribute(79L);
            if (a != null) {
                res.removeAttribute(a);
            }
            AttributeFactory.addToAttributeList(res.getAttributes(), 79L, str.getBytes(), res.isRecyclable());
        } else {
            res = new AccessReject();
            res.setIdentifier(packetIncome.getIdentifier());
            RADIUSUtils.copyAttributesWithoutPCVProxyState(packetIncome, res);
            String reply = "PingID authentication failed";
            AttributeFactory.addToAttributeList(res.getAttributes(), 18L, reply.getBytes(), res.isRecyclable());
        }
        MessageAuthenticator.generateResponseMessageAuthenticatorAsFirstAttribute(dummyPacket.getAuthenticator(), res, secret);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        res.generateAuthenticator(proxyState.getAuth(), secret);
        RadiusServer.format.packPacket(res, secret, buffer, true);
        return new DatagramPacket(buffer.array(), buffer.position(), InetAddress.getByName(proxyState.getHost()), proxyState.getPort());
    }

    public static DatagramPacket generateMessageAuthenticatorPapResponse(JRadiusPacket packetOut, String clientSecret, RadiusPacket request, InetSocketAddress client) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        MessageAuthenticator.generateResponseMessageAuthenticatorAsFirstAttribute(request.getAuthenticator(), packetOut, clientSecret);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ((JRadiusResponse)packetOut).generateAuthenticator(request.getAuthenticator(), clientSecret);
        RadiusServer.format.packPacket(packetOut, clientSecret, buffer, true);
        return new DatagramPacket(buffer.array(), buffer.position(), InetAddress.getByName(client.getAddress().getHostAddress()), client.getPort());
    }

    public static boolean checkEAPMessageaccessState(RadiusPacket request) {
        return request.getPacketType() == 2 || request.getPacketType() == 11 && request.getAttribute(79) != null && request.getAttribute(79).getAttributeData()[5] == 3;
    }
}

