/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid;

import com.pingidentity.plugins.pcvs.pingid.Config;
import com.pingidentity.plugins.pcvs.pingid.PingIdPCV;
import com.pingidentity.plugins.pcvs.pingid.RadiusServer;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class RadiusServerCoordinator {
    private static final RadiusServerCoordinator radiusServerCoordinator = new RadiusServerCoordinator();
    private final Log log = LogFactory.getLog(this.getClass());
    private final boolean isConsoleOnly;
    Map<String, ServerHolder> servers = new HashMap<String, ServerHolder>();

    private RadiusServerCoordinator() {
        this.isConsoleOnly = StringUtils.equals(System.getProperty("pf.operational.mode"), "CLUSTERED_CONSOLE");
        if (!this.isConsoleOnly) {
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        RadiusServerCoordinator.this.checkForConfigChanges();
                    }
                    catch (Throwable e) {
                        RadiusServerCoordinator.this.log.warn("Unexpected problem in timer task that periodically checks for RADIUS related configuration changes to the " + PingIdPCV.class.getName() + " instances.", e);
                        timer.cancel();
                    }
                }
            }, 5000L, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForConfigChanges() {
        PasswordCredentialValidatorManager pcvMgr = MgmtFactory.getCredentialValidatorManager();
        Collection pcvInstances = pcvMgr.getInstances();
        HashSet<String> liveInstanceIds = new HashSet<String>();
        for (ConfigurablePluginInstance instance : pcvInstances) {
            PluginDescriptor descriptor = instance.getDescriptor();
            if (descriptor == null || !PingIdPCV.class.getName().equals(descriptor.getPluginClassName())) continue;
            String id = instance.getId();
            pcvMgr.getValidator(id);
            liveInstanceIds.add(id);
        }
        RadiusServerCoordinator radiusServerCoordinator = this;
        synchronized (radiusServerCoordinator) {
            Set<String> pingIdPcvInstancesToStop = this.getInstanceIds();
            pingIdPcvInstancesToStop.removeAll(liveInstanceIds);
            for (String id : pingIdPcvInstancesToStop) {
                this.log.debug("Cleaning up for PCV " + id + ", which no longer exists...");
                try {
                    this.stopServer(id);
                }
                catch (Exception e) {
                    this.log.warn("Unexpected problem stopping RADIUS server " + id, e);
                }
                try {
                    this.notifyRemoved(id);
                }
                catch (Exception e) {
                    this.log.warn("Unexpected problem on on instance removed callback " + id, e);
                }
            }
        }
    }

    private void notifyRemoved(String id) {
        ServerHolder serverHolder = this.servers.remove(id);
        if (serverHolder != null) {
            PingIdPCV pingIdPCV = serverHolder.getConfig().getPingIdPCV();
            pingIdPCV.onInstanceRemoved();
        }
    }

    public static RadiusServerCoordinator getInstance() {
        return radiusServerCoordinator;
    }

    private synchronized Set<String> getInstanceIds() {
        Set<String> keySet = this.servers.keySet();
        return new HashSet<String>(keySet);
    }

    private synchronized void stopServer(String id) {
        RadiusServer s = this.getRadiusServer(id);
        if (s != null) {
            this.log.debug("PCV:" + id + " stopping radius server on port " + s.getAuthPort());
            s.stop();
        }
    }

    private RadiusServer getRadiusServer(String id) {
        ServerHolder serverHolder = this.servers.get(id);
        return serverHolder == null ? null : serverHolder.getServer();
    }

    public synchronized void onConfigure(Config config) {
        String id = config.getConfiguration().getId();
        this.log.debug("PCV:" + id + " onConfigure(...)");
        RadiusServer s = this.getRadiusServer(id);
        if (this.needToStopOldServer(s, config)) {
            this.stopServer(id);
            this.servers.remove(id);
            s = null;
        }
        if (config.isRadiusServerEnabled() && !this.isConsoleOnly) {
            if (s == null) {
                int numberOfServerThreads = config.getServerThreads();
                ExecutorService executorService = numberOfServerThreads == 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(numberOfServerThreads);
                s = new RadiusServer(executorService);
                s.setConfig(config);
                s.setAuthPort(config.getRadiusServerPort());
                this.log.debug("PCV:" + id + " starting new radius server on port " + s.getAuthPort());
                s.start(true, false);
            } else {
                this.log.debug("PCV:" + id + " setting config on radius server port on " + s.getAuthPort());
                s.setConfig(config);
            }
        } else {
            this.log.debug("PCV:" + id + " radius server not enabled");
        }
        this.servers.put(id, new ServerHolder(config, s));
    }

    private boolean needToStopOldServer(RadiusServer s, Config newConfig) {
        boolean needToStop = false;
        if (s != null) {
            Config oldConfig = s.getConfig();
            needToStop = oldConfig.getRadiusServerPort() != newConfig.getRadiusServerPort();
            needToStop |= oldConfig.getServerThreads() != newConfig.getServerThreads();
            needToStop |= !newConfig.isRadiusServerEnabled();
            needToStop |= oldConfig.getServerThreads() != newConfig.getServerThreads();
        }
        return needToStop;
    }

    private static class ServerHolder {
        private Config config;
        private RadiusServer server;

        private ServerHolder(Config config, RadiusServer server) {
            this.config = config;
            this.server = server;
        }

        private Config getConfig() {
            return this.config;
        }

        private RadiusServer getServer() {
            return this.server;
        }
    }
}

