/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid.secondfactorlogic;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.pingidentity.plugins.pcvs.pingid.AuditLogger.AuditEvents;
import com.pingidentity.plugins.pcvs.pingid.AuditLogger.AuditLoggerHelper;
import com.pingidentity.plugins.pcvs.pingid.AuditLogger.AuditMessages;
import com.pingidentity.plugins.pcvs.pingid.PingIdPCVHelper;
import com.pingidentity.plugins.pcvs.pingid.ServerParams;
import com.pingidentity.plugins.pcvs.pingid.localfallback.LocalFallbackDevice;
import com.pingidentity.plugins.pcvs.pingid.localfallback.LocalFallbackDeviceList;
import com.pingidentity.plugins.pcvs.pingid.secondfactorlogic.SecondFactorAcceptLogic;
import com.pingidentity.plugins.pcvs.pingid.secondfactorlogic.SecondFactorDenyLogic;
import com.pingidentity.plugins.pcvs.pingid.secondfactorlogic.SecondFactorLogic;
import com.pingidentity.plugins.pcvs.pingid.secondfactorlogic.SecondFactorLogicFactory;
import com.pingidentity.plugins.pcvs.pingid.vpnagent.VPNAgentConfigEnum;
import com.pingidentity.plugins.pcvs.pingid.vpnagent.util.PingIdSecurityUtil;
import com.pingidentity.plugins.pcvs.pingid.vpnagent.util.PingIdUtils;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.shaded.v0_3_8.jose4j.lang.JoseException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.naming.NamingException;
import org.accells.api.model.agent.AgentAuthStatus;
import org.accells.api.model.response.body.AgentAuthResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalFallbackServerLogic
implements SecondFactorLogic {
    private static Log logger = LogFactory.getLog(LocalFallbackServerLogic.class);
    private static final int LOCAL_FALLBACK_RANDOM_LENGTH = 12;
    private static final int OTP_LENGTH = 6;
    private static final int MAX_ATTEMPT_NUMBER = 3;
    private static String BYPASS_STATE = "BYPASS";
    private static String BLOCK_STATE = "BLOCK";
    private ServerParams serverParams;

    public LocalFallbackServerLogic(ServerParams serverParams) {
        this.serverParams = serverParams;
    }

    @Override
    public AgentAuthResponse doLogic() {
        logger.debug("Starting Local Fallback Authentication for username=" + this.serverParams.getUsername());
        try {
            AgentAuthResponse response = this.authenticate();
            AgentAuthStatus agentAuthStatus = response.getAgentAuthStatus();
            if (!AuditLoggerHelper.isOldApi(response) && (agentAuthStatus.equals((Object)AgentAuthStatus.SUCCESS) || agentAuthStatus.equals((Object)AgentAuthStatus.REJECT))) {
                AuditLoggerHelper.updateAuditLogDetails(AuditEvents.AUTHENTICATION.getName(), agentAuthStatus.equals((Object)AgentAuthStatus.SUCCESS) ? AuditEvents.SUCCESS.getName() : AuditEvents.FAILURE.getName(), response.getPcvAuditDescription() != null ? response.getPcvAuditDescription() : response.getMessage(), this.serverParams.getUsername(), this.serverParams.getIp(), response.getUniqueMsgId());
            }
            return response;
        }
        catch (JsonSyntaxException | JoseException | NoSuchAlgorithmException | NamingException e) {
            logger.error(e.getMessage() + ". An error has occured during authentication of user=" + this.serverParams.getUsername());
            return null;
        }
    }

    public AgentAuthResponse authenticate() throws NoSuchAlgorithmException, JoseException, NamingException {
        AgentAuthResponse response = null;
        response = this.authUserState();
        if (response != null) {
            return response;
        }
        String username = this.serverParams.getUsername();
        String devices = null;
        if (this.serverParams.getAttemptNumber() == 0) {
            try {
                devices = PingIdPCVHelper.getDecryptDevices(this.serverParams);
            }
            catch (Throwable t) {
                logger.error(t.getMessage() + ". Unable to decrypt device list for user=" + this.serverParams.getUsername());
            }
            logger.debug("Local Fallback - First authentication request for username=" + username + " hasDevices=" + (devices != null));
            return this.authFirstRequest(devices, username);
        }
        devices = PingIdPCVHelper.getDecryptDevices(this.serverParams);
        logger.debug("Authenticating challenge response for username=" + username + ". hasDevices=" + (devices != null) + ". attemptNumber=" + this.serverParams.getAttemptNumber() + ". otp=" + this.serverParams.getChallengeData());
        response = new AgentAuthResponse();
        String localFallbackConfig = this.serverParams.getConfig().get(VPNAgentConfigEnum.POLICY_OUTAGE_CONFIG.getName());
        if (!AuditLoggerHelper.isOldApi(response) && localFallbackConfig != null && (localFallbackConfig.equals(VPNAgentConfigEnum.POLICY_LOCAL_FALLBACK_ENFORCED.getName()) || localFallbackConfig.equals(VPNAgentConfigEnum.POLICY_LOCAL_FALLBACK_PASSIVE.getName()))) {
            String description = localFallbackConfig.equals(VPNAgentConfigEnum.POLICY_LOCAL_FALLBACK_ENFORCED.getName()) ? AuditMessages.AUTH_ERRORS_ENFORCED_OFFLINE.getMessage() : AuditMessages.AUTH_ERRORS_PASSIVE_OFFLINE.getMessage();
            response.setPcvAuditDescription(description);
        }
        if (this.validateOtp(devices)) {
            logger.debug("Otp=" + this.serverParams.getChallengeData() + " validated for username=" + username + ". Returning SUCCESS.");
            response.setAgentAuthStatus(AgentAuthStatus.SUCCESS);
            if (!AuditLoggerHelper.isOldApi(response) && (response.getPcvAuditDescription() == null || response.getPcvAuditDescription().isEmpty())) {
                response.setPcvAuditDescription(response.getMessage());
            }
            return response;
        }
        if (this.serverParams.getAttemptNumber() == 3) {
            logger.debug("Reached maxRetries=3 for username=" + username);
            response.setAgentAuthStatus(AgentAuthStatus.REJECT);
            return response;
        }
        logger.debug("Otp=" + this.serverParams.getChallengeData() + " invalid. requesting retry for username=" + username);
        response.setClientData(this.serverParams.getLocalFallbackRandom());
        response.setMessage(String.format(SecondFactorLogicFactory.INVALID_OTP, this.serverParams.getLocalFallbackRandom()));
        response.setAgentAuthStatus(AgentAuthStatus.MORE_INFO);
        if (!AuditLoggerHelper.isOldApi(response)) {
            response.setPcvAuditDescription(response.getMessage());
        }
        return response;
    }

    public AgentAuthResponse authFirstRequest(String devices, String username) throws NoSuchAlgorithmException {
        try {
            if (devices == null) {
                return this.noDeviceLogic();
            }
            boolean hasMobileDevice = false;
            LocalFallbackDeviceList devicesObj = null;
            try {
                devicesObj = new Gson().fromJson(devices, LocalFallbackDeviceList.class);
            }
            catch (JsonSyntaxException e) {
                logger.error(e.getMessage() + ". The device list of username=" + username + " saved in the directory is in the wrong format.");
            }
            if (devicesObj != null) {
                for (LocalFallbackDevice device : devicesObj.getDevices()) {
                    if (device.getSid() == null || device.getPublicKey() == null) continue;
                    logger.debug("Found mobile device in LDAP for username=" + username);
                    hasMobileDevice = true;
                    break;
                }
            }
            if (!hasMobileDevice) {
                logger.debug("No mobile devices in LDAP for username=" + username);
                return this.noDeviceLogic();
            }
        }
        catch (PasswordCredentialValidatorAuthnException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error(t.getMessage() + ". An error has occured during authentication of user=" + this.serverParams.getUsername());
            return new SecondFactorDenyLogic().doLogic();
        }
        AgentAuthResponse response = new AgentAuthResponse();
        String localFallbackRandom = PingIdUtils.generateLocalFallbackRandom(12);
        response.setClientData(localFallbackRandom);
        response.setMessage(String.format("You need to manually authenticate at this time. Open the PingID app on your mobile device, tap the settings gear and select \"Manual Auth\". Click on \"Enter Key\", type in: %s then type the auth code presented on your mobile device here.", localFallbackRandom));
        response.setAgentAuthStatus(AgentAuthStatus.MORE_INFO);
        return response;
    }

    public AgentAuthResponse noDeviceLogic() {
        String noDeviceBehavior = this.serverParams.getConfig().get(VPNAgentConfigEnum.USER_NO_DEVICE.getName());
        if (noDeviceBehavior.equalsIgnoreCase(VPNAgentConfigEnum.USER_NO_DEVICE_BYPASS.getName())) {
            logger.info("user=" + this.serverParams.getUsername() + " is not paired to a mobile device. '" + VPNAgentConfigEnum.USER_NO_DEVICE.getName() + "' configuration is set to '" + VPNAgentConfigEnum.USER_NO_DEVICE_BYPASS.getName() + "'. Accepting authentication.");
            AuditLoggerHelper.updateAuditLogDetails(AuditEvents.AUTHENTICATION.getName(), AuditEvents.SUCCESS.getName(), AuditMessages.NO_OFFLINE_DEVICE_BYPASS.getMessage(), this.serverParams.getUsername(), this.serverParams.getIp(), null, false);
            return new SecondFactorAcceptLogic().doLogic();
        }
        logger.info("user=" + this.serverParams.getUsername() + " is not paired to a mobile device. '" + VPNAgentConfigEnum.USER_NO_DEVICE.getName() + "' configuration is set to '" + VPNAgentConfigEnum.USER_NO_DEVICE_BLOCK.getName() + "'. Failing authentication.");
        AuditLoggerHelper.updateAuditLogDetails(AuditEvents.AUTHENTICATION.getName(), AuditEvents.FAILURE.getName(), AuditMessages.NO_OFFLINE_DEVICE_BLOCK.getMessage(), this.serverParams.getUsername(), this.serverParams.getIp(), null);
        return new SecondFactorDenyLogic(SecondFactorLogicFactory.MESSAGE_FAIL_NO_DEVICES).doLogic();
    }

    private boolean validateOtp(String devices) throws JoseException {
        LocalFallbackDeviceList devicesObj = new Gson().fromJson(devices, LocalFallbackDeviceList.class);
        Long localFallbackRandom = Long.valueOf(this.serverParams.getLocalFallbackRandom());
        String sid = null;
        for (LocalFallbackDevice device : devicesObj.getDevices()) {
            sid = device.getSid();
            if (sid == null) continue;
            String currentDeviceOtp = PingIdSecurityUtil.generateOTP(sid.getBytes(), localFallbackRandom, 6);
            logger.info("Validating input otp=" + this.serverParams.getChallengeData() + " with device=" + device.getDeviceUuid() + " for username=" + this.serverParams.getUsername());
            if (!this.serverParams.getChallengeData().equals(currentDeviceOtp)) continue;
            logger.debug("Otp=" + this.serverParams.getChallengeData() + " validated for username=" + this.serverParams.getUsername() + ". device=" + device.getDeviceUuid());
            return true;
        }
        return false;
    }

    public AgentAuthResponse authUserState() {
        String localFallbackStateAttribute = this.serverParams.getConfig().get(VPNAgentConfigEnum.LOCAL_FALLBACK_BYPASS_DENY_USER.getName());
        if (localFallbackStateAttribute == null || "".equals(localFallbackStateAttribute)) {
            return null;
        }
        Map<String, String> localFallbackLdapAttributes = this.serverParams.getLocalFallbackLdapAttributes();
        if (localFallbackLdapAttributes == null || localFallbackLdapAttributes.size() == 0) {
            return null;
        }
        String userStateFromLdap = localFallbackLdapAttributes.get(localFallbackStateAttribute);
        if (userStateFromLdap == null || "".equals(userStateFromLdap)) {
            return null;
        }
        if (BYPASS_STATE.equalsIgnoreCase(userStateFromLdap)) {
            logger.info("user=" + this.serverParams.getUsername() + " is configured to '" + userStateFromLdap + "' in the datastore attribute '" + localFallbackStateAttribute + "'. Accepting authentication.");
            return new SecondFactorAcceptLogic().doLogic();
        }
        if (BLOCK_STATE.equalsIgnoreCase(userStateFromLdap)) {
            logger.info("user=" + this.serverParams.getUsername() + " is configured to '" + userStateFromLdap + "' in the datastore attribute '" + localFallbackStateAttribute + "'. Failing authentication.");
            return new SecondFactorDenyLogic(SecondFactorLogicFactory.MESSAGE_DENY_STATE_BLOCK).doLogic();
        }
        logger.debug("user=" + this.serverParams.getUsername() + " has no configuration in the datastore attribute '" + localFallbackStateAttribute + "'.");
        return null;
    }

    @Override
    public boolean isLocalAuthentication() {
        return true;
    }
}

