/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid.vpnagent.util;

import java.util.HashMap;
import java.util.Map;

public class AccellsConstants {
    private AccellsConstants() {
    }

    public static final class HTTP_PARAMS {
        public static final String SESSION_ID = "sessionId";

        public static final class RESPONSE {
            public static final String STATUS = "status";
            public static final String OTP_SESSION_DUR = "otpSessionDur";
            public static final String VPN_REFRESH_PARAMS = "refreshParams";
            public static final String VPN_HEARTBEAT_INTERVAL = "heartbeatInterval";
        }

        public static final class REQUEST {
            public static final String REQUEST = "request";
            public static final String USER_ID = "userId";
            public static final String SP_ID = "spId";
            public static final String ORG_NAME = "orgName";
            public static final String TOKEN = "token";
            public static final String OTP_PASSCODE = "otpPasscode";
            public static final String VPN_GET_PARAMS = "getParams";
            public static final String VPN_AGENT_VERSION = "vpnVersion";
            public static final String LOCAL_FALLBACK_PARAMS = "localFallbackParams";
            public static final String HASH = "hash";
        }
    }

    public static final class VPN_VENDOR {
        public static final String CITRIX_ACCESS_GATEWAY = "CAG";
    }

    public static final class GENERAL {
        public static final String INPUT_TOKEN = ",";
        public static final String USERNAME_TOKEN = ":";
        public static final String BASE64_KEY = "use_base64_key";
    }

    public static enum RESPONSE_STATUS {
        OK(0, "ok"),
        FAIL(1, "fail"),
        REJECT(2, "reject"),
        FALLBACK(3, "fallback"),
        TIMEOUT(4, "timeout");

        private Integer value;
        private String description;

        private RESPONSE_STATUS(Integer value, String description) {
            this.value = value;
            this.description = description;
        }

        public Integer getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public static RESPONSE_STATUS toResponseStatus(String value) {
            Integer val = Integer.parseInt(value);
            for (RESPONSE_STATUS status : RESPONSE_STATUS.values()) {
                if (status.getValue() != val) continue;
                return status;
            }
            return FAIL;
        }
    }

    public static enum REQUEST_TYPE {
        CONFIRM(1, "auth_online"),
        VALIDATE_OTP(2, "auth_offline"),
        HEARTBEAT(3, "heartbeat"),
        GETPARAMS(4, "getParams");

        private int val;
        private String desc;

        private REQUEST_TYPE(int val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static REQUEST_TYPE toRequestType(String desc) {
            for (REQUEST_TYPE rt : REQUEST_TYPE.values()) {
                if (!desc.equals(rt.getDescription())) continue;
                return rt;
            }
            return null;
        }

        public String getDescription() {
            return this.desc;
        }

        public int getValue() {
            return this.val;
        }
    }

    public static enum RADIUS_MSG {
        ACCESS_REQUEST(1, "Access-Request"),
        ACCESS_ACCEPT(2, "Access-Accept"),
        ACCESS_REJECT(3, "Access-Reject"),
        ACCESS_CHALLENGE(11, "Access-Challenge");

        private int val;
        private String desc;

        private RADIUS_MSG(int val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static final RADIUS_MSG toRadiusAnswer(int val) {
            for (RADIUS_MSG msg : RADIUS_MSG.values()) {
                if (val != msg.val) continue;
                return msg;
            }
            return null;
        }

        public final Integer getValue() {
            return this.val;
        }

        public final String getDescription() {
            return this.desc;
        }
    }

    public static enum AuthStatus {
        OK(0, ""),
        FAIL_UNKNOWN(-1, "Error logging in"),
        TIMEOUT(-2, "Login timed out"),
        WRONG_PASS(-3, "wrong password. Please try again"),
        EXCEED_PASS_RETRY(-4, "The username or password is incorrect"),
        DB_ERR(-5, ""),
        DENY(-6, "Login attempt denied by the user"),
        INVALID_SESSION(-7, ""),
        EMAIL_EXPIRED(-8, ""),
        SP_NOT_EXIST(-9, ""),
        USERNAME_NOT_EXIST(-10, "The username may be incorrect, or login restricted by the service provider"),
        DEVICE_CLAIM_TIMEOUT(-11, "Your mobile device is unreachable for login authentication. Please use accells application to generate a one-time passcode"),
        DEVICE_TIMEOUT(-12, "Login timed out"),
        USER_IN_PROCESS(-13, "User in process"),
        USER_LOCKED(-14, "The user is locked"),
        USER_NOT_LOGGED_IN(-15, "The user is not logged in"),
        DEVICE_CLAIM_TIMEOUT_USER_LOCKED(-16, "Your account has been locked.Too many login attempts using a wrong accells ID or password or passcode.You can retry in 1 minute."),
        WRONG_DEVICE_STATUS(-17, ""),
        SECURITY_ALERT(-18, ""),
        ORG_NOT_EXIST(-19, "Invalid organization name"),
        INVALID_VPN_HEADER(-20, ""),
        ORG_NOT_SUPPORT_SP(-21, "This service is not supported"),
        INVALID_OTP_PASSCODE(-22, "Login failed. Please generate a new passcode using accells mobile application."),
        USER_PERMISSION_DENIED(-23, "User %s has no administration rights."),
        INVALID_SECURITY_HEADER(-24, "Invalid login. Please contact your IT admin for futher assistance."),
        DEVICE_NOT_REGISTERED(-25, "The user's mobile application is not installed. Please contact your IT admin for further assistance."),
        INNER_SERVER_ERROR(-26, "Login failed. Please contact your IT admin for further assistance."),
        ORGANIZATIONAL_ACCOUNT_IS_SUSPENDED(-27, "Organizational account is suspended. Please contact your administrator for further assistance."),
        EXTENDED_SESSION_TIMEOUT(-28, "Your mobile device did not responed within the timeout period login authentication. Please use accells application to generate a one-time passcode"),
        HTTP_CONNECTION_UNAVAILABLE(-100, "Server connection unavailable");

        private static Map<Integer, AuthStatus> statuses;
        private int authCode;
        private String authDescription;

        private AuthStatus(int errorCode, String errorReason) {
            this.authCode = errorCode;
            this.authDescription = errorReason;
        }

        public int getValue() {
            return this.authCode;
        }

        public String getDescription() {
            return this.authDescription;
        }

        public static AuthStatus toAuthStatus(int authCode) {
            return statuses.get(authCode);
        }

        static {
            statuses = new HashMap<Integer, AuthStatus>();
            for (AuthStatus status : AuthStatus.values()) {
                statuses.put(status.getValue(), status);
            }
        }
    }
}

