/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid.vpnagent.util;

import com.pingidentity.shaded.v0_3_8.jose4j.jwe.JsonWebEncryption;
import com.pingidentity.shaded.v0_3_8.jose4j.lang.JoseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingIdSecurityUtil {
    private static Log logger = LogFactory.getLog(PingIdSecurityUtil.class);
    private static final long[] DIGITS_POWER = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L};
    private static int IV_SIZE_BYTES = 16;

    public static String decryptJwe(String encryptedDeviceList, String keyStr) throws JoseException {
        JsonWebEncryption jwe = new JsonWebEncryption();
        SecretKeySpec key = new SecretKeySpec(Base64.decodeBase64(keyStr), "AES");
        jwe.setCompactSerialization(encryptedDeviceList);
        jwe.setKey(key);
        return jwe.getPlaintextString();
    }

    public static String decryptJwe(String encryptionText, Key key) throws JoseException {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setCompactSerialization(encryptionText);
        jwe.setKey(key);
        return jwe.getPlaintextString();
    }

    public static String encryptJwe(String encryptionCandidate, String keyStr) throws JoseException {
        JsonWebEncryption jwe = new JsonWebEncryption();
        SecretKeySpec key = new SecretKeySpec(Base64.decodeBase64(keyStr), "AES");
        jwe.setPlaintext(encryptionCandidate);
        jwe.setAlgorithmHeaderValue("dir");
        jwe.setEncryptionMethodHeaderParameter("A256GCM");
        jwe.setKey(key);
        return jwe.getCompactSerialization();
    }

    public static String encryptJwe(String encryptionCandidate, Key key, String algorithm) throws JoseException {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setPlaintext(encryptionCandidate);
        jwe.setAlgorithmHeaderValue("dir");
        jwe.setEncryptionMethodHeaderParameter(algorithm);
        jwe.setKey(key);
        return jwe.getCompactSerialization();
    }

    public static String reencryptJwe(String candidate, String oldKeyStr, String newKeyStr) throws JoseException {
        String plaintext = PingIdSecurityUtil.decryptJwe(candidate, oldKeyStr);
        if (newKeyStr == null || newKeyStr.equals("")) {
            return plaintext;
        }
        return PingIdSecurityUtil.encryptJwe(plaintext, newKeyStr);
    }

    public static byte[] encryptWithIv(String candidate, SecretKey secretKey, SecureRandom random, String algorithm) throws InvalidKeyException, InvalidAlgorithmParameterException, IOException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        logger.debug("encryptWithIv: secretKey=" + secretKey + "; random=" + random + "; algorithm=" + algorithm);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] iv = new byte[IV_SIZE_BYTES];
        random.nextBytes(iv);
        os.write(iv);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
        byte[] ciphertext = cipher.doFinal(candidate.getBytes());
        os.write(ciphertext);
        return os.toByteArray();
    }

    public static String decryptWithIv(byte[] candidate, SecretKey secretKey, String algorithm) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        logger.debug("decryptWithIv: secretKey=" + secretKey + "; algorithm=" + algorithm);
        ByteArrayInputStream is = new ByteArrayInputStream(candidate);
        Cipher cipher = Cipher.getInstance(algorithm);
        byte[] iv = new byte[IV_SIZE_BYTES];
        is.read(iv, 0, IV_SIZE_BYTES);
        int ciphertextSize = is.available();
        byte[] ciphertext = new byte[ciphertextSize];
        is.read(ciphertext, 0, ciphertextSize);
        cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
        byte[] plaintext = cipher.doFinal(ciphertext);
        return new String(plaintext);
    }

    public static String generateOTP(byte[] secret, long movingFactor, int codeDigits) {
        return PingIdSecurityUtil.generateOTP(secret, movingFactor, codeDigits, -1);
    }

    private static String generateOTP(byte[] secret, long movingFactor, int codeDigits, int truncationOffset) {
        String result = null;
        try {
            int digits = codeDigits;
            byte[] text = new byte[8];
            for (int i = text.length - 1; i >= 0; --i) {
                text[i] = (byte)(movingFactor & 0xFFL);
                movingFactor >>= 8;
            }
            byte[] hash = PingIdSecurityUtil.hmacSha1(secret, text);
            int offset = hash[hash.length - 1] & 0xF;
            if (0 <= truncationOffset && truncationOffset < hash.length - 4) {
                offset = truncationOffset;
            }
            int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
            long otpLong = (long)binary % DIGITS_POWER[codeDigits];
            int otp = (int)(otpLong & 0xFFFFFFFFFFFFFFFFL);
            result = Integer.toString(otp);
            while (result.length() < digits) {
                result = "0" + result;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage() + ". Can't generate OTP value");
        }
        return result;
    }

    private static byte[] hmacSha1(byte[] keyBytes, byte[] text) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmacSha1;
        try {
            hmacSha1 = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            hmacSha1 = Mac.getInstance("HMAC-SHA-1");
        }
        SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
        hmacSha1.init(macKey);
        return hmacSha1.doFinal(text);
    }

    public static String hashUsername(String username) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] messageDigest = md.digest(username.getBytes());
        BigInteger no = new BigInteger(1, messageDigest);
        String hashtext = no.toString(16);
        while (hashtext.length() < 24) {
            hashtext = hashtext + "0";
        }
        return hashtext.substring(0, 24);
    }
}

