/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.pingid.vpnagent.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PingIdUtils {
    public static final long MAX_OTP_COUNTER = 0xFFFFFFFFFFFFFFL;
    private static final String SHA1PRNG = "SHA1PRNG";

    public static String generateLocalFallbackRandom(int randomLength) throws NoSuchAlgorithmException {
        long randomNumber = PingIdUtils.generateRandomNumber();
        String tmpCodeStr = Long.toString(randomNumber);
        while (tmpCodeStr.length() < randomLength - 1) {
            tmpCodeStr = '0' + tmpCodeStr;
        }
        String randBeforeCheckSum = tmpCodeStr.substring(0, randomLength - 1);
        return randBeforeCheckSum + PingIdUtils.calcCheckSum(randBeforeCheckSum);
    }

    private static String calcCheckSum(String randBeforeCheckSum) {
        int sum = 0;
        for (int i = 0; i < randBeforeCheckSum.length(); ++i) {
            int current = Integer.valueOf(String.valueOf(randBeforeCheckSum.charAt(i))) * (i % 2 + 1);
            sum += current >= 10 ? current - 9 : current;
        }
        Integer ceil = (int)(Math.ceil((double)sum / 10.0) * 10.0);
        Integer numToAppend = ceil - sum;
        return numToAppend.toString();
    }

    private static long generateRandomNumber() throws NoSuchAlgorithmException {
        long nextLong = 0L;
        SecureRandom secureRandom = SecureRandom.getInstance(SHA1PRNG);
        long randomLong = secureRandom.nextLong();
        nextLong = randomLong & 0xFFFFFFFFFFFFFFL;
        return nextLong;
    }
}

