/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.shaded.v0_3_8.jose4j.keys.resolvers;

import com.pingidentity.shaded.v0_3_8.jose4j.jwe.JsonWebEncryption;
import com.pingidentity.shaded.v0_3_8.jose4j.jwk.DecryptionJwkSelector;
import com.pingidentity.shaded.v0_3_8.jose4j.jwk.JsonWebKey;
import com.pingidentity.shaded.v0_3_8.jose4j.jwk.PublicJsonWebKey;
import com.pingidentity.shaded.v0_3_8.jose4j.jwx.JsonWebStructure;
import com.pingidentity.shaded.v0_3_8.jose4j.keys.resolvers.DecryptionKeyResolver;
import com.pingidentity.shaded.v0_3_8.jose4j.lang.JoseException;
import com.pingidentity.shaded.v0_3_8.jose4j.lang.UnresolvableKeyException;
import java.security.Key;
import java.util.List;

public class JwksDecryptionKeyResolver
implements DecryptionKeyResolver {
    private List<JsonWebKey> jsonWebKeys;
    private DecryptionJwkSelector selector = new DecryptionJwkSelector();

    public JwksDecryptionKeyResolver(List<JsonWebKey> jsonWebKeys) {
        this.jsonWebKeys = jsonWebKeys;
    }

    @Override
    public Key resolveKey(JsonWebEncryption jwe, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        JsonWebKey selected;
        try {
            selected = this.selector.select(jwe, this.jsonWebKeys);
        }
        catch (JoseException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
            sb.append(" due to an unexpected exception (").append(e).append(") selecting from keys: ").append(this.jsonWebKeys);
            throw new UnresolvableKeyException(sb.toString(), e);
        }
        if (selected == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
            sb.append(" from JWKs ").append(this.jsonWebKeys);
            throw new UnresolvableKeyException(sb.toString());
        }
        try {
            PublicJsonWebKey publicJsonWebKey = (PublicJsonWebKey)selected;
            return publicJsonWebKey.getPrivateKey();
        }
        catch (ClassCastException e) {
            return selected.getKey();
        }
    }
}

