/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.client;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.newjradius.client.RadiusClientTransport;
import net.newjradius.client.UDPClientTransport;
import net.newjradius.client.auth.CHAPAuthenticator;
import net.newjradius.client.auth.EAPMD5Authenticator;
import net.newjradius.client.auth.EAPMSCHAPv2Authenticator;
import net.newjradius.client.auth.MSCHAPv1Authenticator;
import net.newjradius.client.auth.MSCHAPv2Authenticator;
import net.newjradius.client.auth.PAPAuthenticator;
import net.newjradius.client.auth.RadiusAuthenticator;
import net.newjradius.exception.JRadiusException;
import net.newjradius.exception.UnknownAttributeExceptionJ;
import net.newjradius.packet.AccessChallenge;
import net.newjradius.packet.AccessRequest;
import net.newjradius.packet.AccountingRequest;
import net.newjradius.packet.AccountingResponse;
import net.newjradius.packet.CoARequest;
import net.newjradius.packet.CoAResponse;
import net.newjradius.packet.DisconnectRequest;
import net.newjradius.packet.DisconnectResponse;
import net.newjradius.packet.JRadiusRequest;
import net.newjradius.packet.JRadiusResponse;
import net.newjradius.session.JRadiusSession;

public class RadiusClient {
    protected RadiusClientTransport transport;
    protected static final LinkedHashMap<String, Class<?>> authenticators = new LinkedHashMap();
    protected JRadiusSession session;

    public RadiusClient() throws IOException {
        this.transport = new UDPClientTransport();
        this.transport.setRadiusClient(this);
    }

    public RadiusClient(DatagramSocket socket) {
        this.transport = new UDPClientTransport(socket);
        this.transport.setRadiusClient(this);
    }

    public RadiusClient(RadiusClientTransport transport) {
        this.transport = transport;
        this.transport.setRadiusClient(this);
    }

    public RadiusClient(InetAddress address, String secret) throws IOException {
        this.transport = new UDPClientTransport();
        this.transport.setRadiusClient(this);
        this.setRemoteInetAddress(address);
        this.setSharedSecret(secret);
    }

    public RadiusClient(DatagramSocket socket, InetAddress address, String secret) {
        this(socket);
        this.setRemoteInetAddress(address);
        this.setSharedSecret(secret);
    }

    public RadiusClient(InetAddress address, String secret, int authPort, int acctPort, int timeout) throws IOException {
        this.transport = new UDPClientTransport();
        this.transport.setRadiusClient(this);
        this.setRemoteInetAddress(address);
        this.setSharedSecret(secret);
        this.setAuthPort(authPort);
        this.setAcctPort(acctPort);
        this.setSocketTimeout(timeout);
    }

    public RadiusClient(DatagramSocket socket, InetAddress address, String secret, int authPort, int acctPort, int timeout) throws SocketException {
        this(socket);
        this.setRemoteInetAddress(address);
        this.setSharedSecret(secret);
        this.setAuthPort(authPort);
        this.setAcctPort(acctPort);
        this.setSocketTimeout(timeout);
    }

    public void close() {
        if (this.transport != null) {
            this.transport.close();
        }
    }

    public static void registerAuthenticator(String name, Class<?> c) {
        authenticators.put(name, c);
    }

    public static void registerAuthenticator(String name, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        authenticators.put(name, c);
    }

    public static RadiusAuthenticator getAuthProtocol(String protocolName) {
        Class<?> c;
        RadiusAuthenticator auth = null;
        String[] args = null;
        int i = protocolName.indexOf(58);
        if (i > 0) {
            if (i < protocolName.length()) {
                args = protocolName.substring(i + 1).split(":");
            }
            protocolName = protocolName.substring(0, i);
        }
        if ((c = authenticators.get(protocolName = protocolName.toLowerCase())) == null) {
            return null;
        }
        try {
            auth = (RadiusAuthenticator)c.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        if (args != null) {
            HashMap<String, PropertyDescriptor> elements = new HashMap<String, PropertyDescriptor>();
            Class<?> clazz = auth.getClass();
            PropertyDescriptor[] props = null;
            try {
                props = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            }
            catch (Exception e) {
                return auth;
            }
            for (int p = 0; p < props.length; ++p) {
                PropertyDescriptor pd = props[p];
                Method m = pd.getWriteMethod();
                if (m == null) continue;
                elements.put(pd.getName(), pd);
            }
            for (int a = 0; a < args.length; ++a) {
                int eq = args[a].indexOf("=");
                if (eq <= 0) continue;
                String name = args[a].substring(0, eq);
                String value = args[a].substring(eq + 1);
                PropertyDescriptor pd = (PropertyDescriptor)elements.get(name);
                Method m = pd.getWriteMethod();
                if (m == null) continue;
                Object valueObject = value;
                Class<?> cType = pd.getPropertyType();
                if (cType == Boolean.class) {
                    valueObject = new Boolean(value);
                } else if (cType == Integer.class) {
                    valueObject = new Integer(value);
                }
                try {
                    m.invoke((Object)auth, valueObject);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return auth;
    }

    public JRadiusResponse sendReceive(JRadiusRequest p, int retries) throws JRadiusException {
        return this.transport.sendReceive(p, retries);
    }

    public void send(JRadiusRequest p) throws Exception {
        this.transport.send(p, 0);
    }

    public JRadiusResponse authenticate(AccessRequest p, RadiusAuthenticator auth, int retries) throws JRadiusException, UnknownAttributeExceptionJ, NoSuchAlgorithmException {
        JRadiusResponse reply;
        if (auth == null) {
            auth = new PAPAuthenticator();
        }
        auth.setupRequest(this, p);
        auth.processRequest(p);
        while ((reply = this.transport.sendReceive(p, retries)) instanceof AccessChallenge) {
            auth.processChallenge(p, reply);
        }
        return reply;
    }

    public AccountingResponse accounting(AccountingRequest p, int retries) throws JRadiusException {
        JRadiusResponse response = this.transport.sendReceive(p, retries);
        if (!(response instanceof AccountingResponse)) {
            throw new JRadiusException("Received something other than AccountingResponse to a AccountingRequest");
        }
        return (AccountingResponse)response;
    }

    public DisconnectResponse disconnect(DisconnectRequest p, int retries) throws JRadiusException {
        JRadiusResponse response = this.transport.sendReceive(p, retries);
        if (!(response instanceof DisconnectResponse)) {
            throw new JRadiusException("Received something other than DisconnectResponse to a DisconnectRequest");
        }
        return (DisconnectResponse)response;
    }

    public CoAResponse changeOfAuth(CoARequest p, int retries) throws JRadiusException {
        JRadiusResponse response = this.transport.sendReceive(p, retries);
        if (!(response instanceof CoAResponse)) {
            throw new JRadiusException("Received something other than CoAResponse to a CoARequest");
        }
        return (CoAResponse)response;
    }

    public int getAcctPort() {
        return this.transport.getAcctPort();
    }

    public void setAcctPort(int acctPort) {
        this.transport.setAcctPort(acctPort);
    }

    public int getAuthPort() {
        return this.transport.getAuthPort();
    }

    public void setAuthPort(int authPort) {
        this.transport.setAuthPort(authPort);
    }

    public int getSocketTimeout() {
        return this.transport.getSocketTimeout();
    }

    public void setSocketTimeout(int socketTimeout) {
        this.transport.setSocketTimeout(socketTimeout);
    }

    public InetAddress getRemoteInetAddress() {
        return this.transport.getRemoteInetAddress();
    }

    public void setRemoteInetAddress(InetAddress remoteInetAddress) {
        this.transport.setRemoteInetAddress(remoteInetAddress);
    }

    public InetAddress getLocalInetAddress() {
        return this.transport.getLocalInetAddress();
    }

    public void setLocalInetAddress(InetAddress localInetAddress) {
    }

    public String getSharedSecret() {
        return this.transport.getSharedSecret();
    }

    public void setSharedSecret(String sharedSecret) {
        this.transport.setSharedSecret(sharedSecret);
    }

    static {
        RadiusClient.registerAuthenticator("pap", PAPAuthenticator.class);
        RadiusClient.registerAuthenticator("chap", CHAPAuthenticator.class);
        RadiusClient.registerAuthenticator("mschapv1", MSCHAPv1Authenticator.class);
        RadiusClient.registerAuthenticator("mschapv2", MSCHAPv2Authenticator.class);
        RadiusClient.registerAuthenticator("mschap", MSCHAPv2Authenticator.class);
        RadiusClient.registerAuthenticator("eap-md5", EAPMD5Authenticator.class);
        RadiusClient.registerAuthenticator("eap-mschapv2", EAPMSCHAPv2Authenticator.class);
        try {
            RadiusClient.registerAuthenticator("eap-tls", "net.newjradius.client.auth.EAPTLSAuthenticator");
            RadiusClient.registerAuthenticator("eap-ttls", "net.newjradius.client.auth.EAPTTLSAuthenticator");
            RadiusClient.registerAuthenticator("peap", "net.newjradius.client.auth.PEAPAuthenticator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

