/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import net.newjradius.client.RadiusClientTransport;
import net.newjradius.exception.JRadiusException;
import net.newjradius.packet.AccountingRequest;
import net.newjradius.packet.JRadiusPacket;
import net.newjradius.packet.JRadiusRequest;
import net.newjradius.packet.JRadiusResponse;
import net.newjradius.packet.PacketFactory;
import net.newjradius.packet.RadiusFormat;

public class UDPClientTransport
extends RadiusClientTransport {
    private static final RadiusFormat format = RadiusFormat.getInstance();
    public static final int defaultAuthPort = 1812;
    public static final int defaultAcctPort = 1813;
    protected DatagramChannel channel;
    protected DatagramSocket socket;

    public UDPClientTransport(DatagramSocket socket) {
        this.socket = socket;
        this.remoteInetAddress = socket.getInetAddress();
    }

    public UDPClientTransport() throws IOException {
        this.channel = DatagramChannel.open();
        this.socket = this.channel.socket();
        this.remoteInetAddress = this.socket.getInetAddress();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void send(JRadiusRequest req, int attempt) throws Exception {
        int port;
        int n = port = req instanceof AccountingRequest ? this.acctPort : this.authPort;
        if (this.statusListener != null) {
            this.statusListener.onBeforeSend(this, req);
        }
        if (attempt > 1) {
            // empty if block
        }
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        format.packPacket(req, this.sharedSecret, buffer, true);
        DatagramPacket request = new DatagramPacket(buffer.array(), buffer.position(), this.getRemoteInetAddress(), port);
        this.socket.send(request);
        if (this.statusListener != null) {
            this.statusListener.onAfterSend(this);
        }
    }

    @Override
    protected JRadiusResponse receive(JRadiusRequest req) throws Exception {
        if (this.statusListener != null) {
            this.statusListener.onBeforeReceive(this);
        }
        byte[] replyBytes = new byte[4096];
        DatagramPacket reply = new DatagramPacket(replyBytes, replyBytes.length);
        this.socket.receive(reply);
        JRadiusPacket replyPacket = PacketFactory.parse(reply, req.isRecyclable());
        if (!(replyPacket instanceof JRadiusResponse)) {
            throw new JRadiusException("Received something other than a RADIUS Response to a Request");
        }
        if (this.statusListener != null) {
            this.statusListener.onAfterReceive(this, replyPacket);
        }
        return (JRadiusResponse)replyPacket;
    }

    @Override
    public void setSocketTimeout(int timeout) {
        super.setSocketTimeout(timeout);
        try {
            this.socket.setSoTimeout(this.socketTimeout);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }
}

