/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.client.auth;

import java.security.NoSuchAlgorithmException;
import net.newjradius.client.auth.EAPAuthenticator;
import net.newjradius.util.MSCHAP;

public class EAPMSCHAPv2Authenticator
extends EAPAuthenticator {
    public static final String NAME = "eap-mschapv2";
    protected static final byte EAP_MSCHAPV2_ACK = 0;
    protected static final byte EAP_MSCHAPV2_CHALLENGE = 1;
    protected static final byte EAP_MSCHAPV2_RESPONSE = 2;
    protected static final byte EAP_MSCHAPV2_SUCCESS = 3;
    protected static final byte EAP_MSCHAPV2_FAILURE = 4;

    public EAPMSCHAPv2Authenticator() {
        this.setEAPType(26);
    }

    public EAPMSCHAPv2Authenticator(boolean peap) {
        this.setEAPType(26);
        this.peap = peap;
    }

    @Override
    public String getAuthName() {
        return NAME;
    }

    @Override
    public byte[] doEAPType(byte id, byte[] data) throws NoSuchAlgorithmException {
        byte opCode = data[0];
        switch (opCode) {
            case 1: {
                byte[] challenge = new byte[16];
                System.arraycopy(data, 5, challenge, 0, 16);
                int length = 54 + this.getUsername().length;
                byte[] response = new byte[length];
                response[0] = 2;
                response[1] = data[1];
                response[2] = (byte)(length << 8 & 0xFF);
                response[3] = (byte)(length & 0xFF);
                response[4] = 49;
                System.arraycopy(MSCHAP.doMSCHAPv2(this.getUsername(), this.getPassword(), challenge), 2, response, 5, 48);
                response[53] = 0;
                System.arraycopy(this.getUsername(), 0, response, 54, this.getUsername().length);
                return response;
            }
            case 3: {
                this.setState(1);
                byte[] response = new byte[]{3};
                return response;
            }
        }
        this.setState(4);
        byte[] response = new byte[]{4};
        return response;
    }
}

