/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.freeradius;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.newjradius.packet.JRadiusPacket;
import net.newjradius.packet.attribute.AttributeList;
import net.newjradius.server.JRadiusRequest;
import org.apache.commons.pool.ObjectPool;

public class FreeRadiusRequest
extends JRadiusRequest {
    private static final long serialVersionUID = 1L;
    protected int type;
    protected JRadiusPacket[] packets;
    protected AttributeList configItems;
    protected int returnValue = 8;
    protected ObjectPool borrowedFromPool;
    protected final ByteBuffer buffer_in = ByteBuffer.allocate(25000);
    protected final ByteBuffer buffer_out;

    public FreeRadiusRequest() {
        this.buffer_in.order(ByteOrder.BIG_ENDIAN);
        this.buffer_out = ByteBuffer.allocate(25000);
        this.buffer_out.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public AttributeList getConfigItems() {
        return this.configItems;
    }

    @Override
    public JRadiusPacket[] getPackets() {
        return this.packets;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getReturnValue() {
        return this.returnValue;
    }

    @Override
    public void setConfigItems(AttributeList configItems) {
        this.configItems = configItems;
    }

    @Override
    public void setPackets(JRadiusPacket[] packets) {
        this.packets = packets;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public void setReturnValue(int returnValue) {
        this.returnValue = returnValue;
    }

    @Override
    public String getTypeString() {
        switch (this.getType()) {
            case 1: {
                return "authenticate";
            }
            case 2: {
                return "authorize";
            }
            case 3: {
                return "preacct";
            }
            case 4: {
                return "accounting";
            }
            case 5: {
                return "checksimul";
            }
            case 6: {
                return "pre_proxy";
            }
            case 7: {
                return "post_proxy";
            }
            case 8: {
                return "post_auth";
            }
        }
        return "UNKNOWN";
    }

    public ObjectPool getBorrowedFromPool() {
        return this.borrowedFromPool;
    }

    public void setBorrowedFromPool(ObjectPool borrowedFromPool) {
        this.borrowedFromPool = borrowedFromPool;
    }
}

