/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.packet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.newjradius.packet.attribute.AttributeFactory;
import net.newjradius.packet.attribute.AttributeList;
import net.newjradius.packet.attribute.RadiusAttribute;
import net.newjradius.packet.attribute.VSAttribute;

public abstract class Format {
    public abstract void packAttribute(ByteBuffer var1, RadiusAttribute var2);

    public void packAttributes(ByteBuffer buffer, List<VSAttribute> list) {
        for (VSAttribute a : list) {
            this.packAttribute(buffer, a);
        }
    }

    public abstract void unpackAttributeHeader(ByteBuffer var1, AttributeParseContext var2) throws IOException;

    public void packAttributeList(AttributeList attrs, ByteBuffer buffer, boolean onWire) {
        Iterator<RadiusAttribute> iterator = attrs.getAttributeList().iterator();
        while (iterator.hasNext()) {
            VSAttribute vsa;
            RadiusAttribute attr = iterator.next();
            if (attr instanceof VSAttribute && (vsa = (VSAttribute)attr).isGrouped()) {
                LinkedList<VSAttribute> group = new LinkedList<VSAttribute>();
                group.add(vsa);
                RadiusAttribute radiusAttribute = attr = iterator.hasNext() ? iterator.next() : null;
                while (attr != null && attr.getFormattedType() == vsa.getFormattedType()) {
                    group.add((VSAttribute)attr);
                    attr = iterator.hasNext() ? iterator.next() : null;
                }
                this.packAttributes(buffer, group);
                if (attr == null) break;
            }
            if (onWire && attr.getType() > 1024L || attr.isOverflow()) continue;
            int currentPosition = buffer.position();
            try {
                this.packAttribute(buffer, attr);
            }
            catch (Throwable e) {
                RadiusAttribute a = attrs.get(89L);
                buffer.position(currentPosition);
                attr.setOverflow(true);
            }
        }
    }

    public void unpackAttributes(AttributeList attrs, ByteBuffer buffer, int length, boolean pool) {
        AttributeParseContext ctx = new AttributeParseContext();
        int pos = 0;
        while (pos < length) {
            boolean hasMore;
            try {
                this.unpackAttributeHeader(buffer, ctx);
            }
            catch (Exception e) {
                return;
            }
            boolean seenOne = false;
            long len = ctx.attributeLength - (long)ctx.headerLength;
            do {
                hasMore = false;
                RadiusAttribute attribute = AttributeFactory.newAttribute(ctx.vendorNumber, ctx.attributeType, len, (int)ctx.attributeOp, buffer, pool);
                if (attribute != null) {
                    attrs._add(attribute, false);
                }
                long vlen = attribute.getValue().getLength();
                if (vlen < len) {
                    if (!(attribute instanceof VSAttribute)) break;
                    ctx.vendorNumber = (int)((VSAttribute)attribute).getVendorId();
                    ctx.attributeType = -1L;
                    if (!seenOne) {
                        vlen += 4L;
                    }
                    seenOne = true;
                    boolean bl = hasMore = (len -= (vlen += 2L)) > 0L;
                }
                if (!seenOne) continue;
                ((VSAttribute)attribute).setGrouped(true);
            } while (hasMore);
            if (ctx.padding > 0) {
                pos += ctx.padding;
                while (ctx.padding-- > 0) {
                    Format.getUnsignedByte(buffer);
                }
            }
            pos = (int)((long)pos + ctx.attributeLength);
        }
    }

    public static long readUnsignedInt(InputStream in) throws IOException {
        byte[] b = new byte[4];
        in.read(b);
        long value = b[3] & 0xFF;
        value |= (long)((b[2] & 0xFF) << 8);
        value |= (long)((b[1] & 0xFF) << 16);
        return value |= (long)((b[0] & 0xFF) << 24);
    }

    public static int readUnsignedShort(InputStream in) throws IOException {
        byte[] b = new byte[2];
        in.read(b);
        int value = b[1] & 0xFF;
        return value |= (b[0] & 0xFF) << 8;
    }

    public static int readUnsignedByte(InputStream in) throws IOException {
        return in.read() & 0xFF;
    }

    public static void writeUnsignedByte(OutputStream out, int b) throws IOException {
        out.write(b);
    }

    public static void writeUnsignedShort(OutputStream out, int s) throws IOException {
        out.write(s >> 8 & 0xFF);
        out.write(s & 0xFF);
    }

    public static void writeUnsignedInt(OutputStream out, long i) throws IOException {
        Format.writeUnsignedShort(out, (int)(i >> 16) & 0xFFFF);
        Format.writeUnsignedShort(out, (int)i & 0xFFFF);
    }

    public static short getUnsignedByte(ByteBuffer bb) {
        return (short)(bb.get() & 0xFF);
    }

    public static void putUnsignedByte(ByteBuffer bb, int value) {
        bb.put((byte)(value & 0xFF));
    }

    public static short getUnsignedByte(ByteBuffer bb, int position) {
        return (short)(bb.get(position) & 0xFF);
    }

    public static void putUnsignedByte(ByteBuffer bb, int position, int value) {
        bb.put(position, (byte)(value & 0xFF));
    }

    public static int getUnsignedShort(ByteBuffer bb) {
        return bb.getShort() & 0xFFFF;
    }

    public static void putUnsignedShort(ByteBuffer bb, int value) {
        bb.putShort((short)(value & 0xFFFF));
    }

    public static int getUnsignedShort(ByteBuffer bb, int position) {
        return bb.getShort(position) & 0xFFFF;
    }

    public static void putUnsignedShort(ByteBuffer bb, int position, int value) {
        bb.putShort(position, (short)(value & 0xFFFF));
    }

    public static long getUnsignedInt(ByteBuffer bb) {
        return (long)bb.getInt() & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer bb, long value) {
        bb.putInt((int)(value & 0xFFFFFFFFL));
    }

    public static long getUnsignedInt(ByteBuffer bb, int position) {
        return (long)bb.getInt(position) & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer bb, int position, long value) {
        bb.putInt(position, (int)(value & 0xFFFFFFFFL));
    }

    protected class AttributeParseContext {
        public long attributeType = 0L;
        public long attributeLength = 0L;
        public long attributeOp = 11L;
        public long attributeValueLength = 0L;
        public byte[] attributeValue = null;
        public int headerLength = 0;
        public int vendorNumber = -1;
        public int padding = 0;
        public long lengthRemaining = 0L;

        protected AttributeParseContext() {
        }
    }
}

