/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.packet.attribute.value;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import net.newjradius.packet.attribute.value.AttributeValue;
import net.newjradius.packet.attribute.value.IntegerValue;

public class DateValue
extends IntegerValue {
    private static final long serialVersionUID = 0L;
    private Date dateValue;

    public DateValue() {
    }

    public DateValue(Date d) {
        this.dateValue = d;
    }

    @Override
    public void copy(AttributeValue value) {
        DateValue dValue = (DateValue)value;
        this.integerValue = dValue.integerValue;
        this.length = dValue.length;
        this.dateValue = dValue.dateValue;
    }

    @Override
    public void getBytes(OutputStream out) throws IOException {
        this.integerValue = new Long(this.dateValue.getTime() / 1000L);
        super.getBytes(out);
    }

    @Override
    public void setValue(byte[] b, int off, int len) {
        super.setValue(b, off, len);
        this.dateValue = new Date(this.integerValue * 1000L);
    }

    @Override
    public void setValue(byte[] b) {
        super.setValue(b);
        this.dateValue = new Date(this.integerValue * 1000L);
    }

    public void setValue(int i) {
        super.setValue(i);
        this.dateValue = new Date(this.integerValue * 1000L);
    }

    @Override
    public void setValue(long l) {
        super.setValue(l);
        this.dateValue = new Date(this.integerValue * 1000L);
    }

    @Override
    public void setValue(String v) {
        super.setValue(v);
        this.dateValue = new Date(this.integerValue * 1000L);
    }

    @Override
    public void setLong(Long l) {
        super.setLong(l);
        this.dateValue = new Date(this.integerValue * 1000L);
    }

    @Override
    public void getBytes(ByteBuffer buffer) {
        this.integerValue = new Long(this.dateValue.getTime() / 1000L);
        super.getBytes(buffer);
    }

    @Override
    public String toString() {
        if (this.dateValue != null) {
            return this.dateValue.toString();
        }
        return "[Bad Date Value]";
    }

    @Override
    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<time>");
        if (this.dateValue != null) {
            sb.append(this.dateValue.getTime());
        }
        sb.append("</time>");
        return sb.toString();
    }

    public void setDate(Date newDate) {
        this.dateValue = newDate;
        this.integerValue = new Long(this.dateValue.getTime() / 1000L);
    }

    @Override
    public Serializable getValueObject() {
        return this.dateValue;
    }

    @Override
    public void setValueObject(Serializable o) {
        if (o instanceof Date) {
            this.setDate((Date)o);
        } else if (o instanceof Number) {
            this.setDate(new Date(((Number)o).longValue() * 1000L));
        } else {
            this.setDate(new Date(Long.parseLong(o.toString()) * 1000L));
        }
    }
}

