/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.packet.attribute.value;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.newjradius.packet.Format;
import net.newjradius.packet.attribute.value.AttributeValue;

public class IntegerValue
extends AttributeValue {
    private static final long serialVersionUID = 0L;
    protected int length = 4;
    protected Long integerValue;

    public IntegerValue() {
    }

    public IntegerValue(Long l) {
        this.integerValue = l;
    }

    public IntegerValue(Integer i) {
        this.setValue(i.longValue());
    }

    public IntegerValue(int i) {
        this.setValue(i);
    }

    public IntegerValue(long l) {
        this.setValue(l);
    }

    @Override
    public void copy(AttributeValue value) {
        IntegerValue iValue = (IntegerValue)value;
        this.integerValue = iValue.integerValue;
        this.length = iValue.length;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void getBytes(OutputStream out) throws IOException {
        if (this.integerValue != null) {
            long longValue = this.integerValue;
            if (this.length == 4) {
                out.write((int)(longValue >> 24 & 0xFFL));
                out.write((int)(longValue >> 16 & 0xFFL));
            }
            if (this.length >= 2) {
                out.write((int)(longValue >> 8 & 0xFFL));
            }
            out.write((int)(longValue & 0xFFL));
        }
    }

    @Override
    public void getBytes(ByteBuffer buffer) {
        if (this.integerValue != null) {
            long longValue = this.integerValue;
            if (this.length == 4) {
                Format.putUnsignedByte(buffer, (int)(longValue >> 24 & 0xFFL));
                Format.putUnsignedByte(buffer, (int)(longValue >> 16 & 0xFFL));
            }
            if (this.length >= 2) {
                Format.putUnsignedByte(buffer, (int)(longValue >> 8 & 0xFFL));
            }
            Format.putUnsignedByte(buffer, (int)(longValue & 0xFFL));
        }
    }

    @Override
    public void setValue(byte[] b) {
        if (b == null) {
            return;
        }
        this.setValue(b, 0, b.length);
    }

    @Override
    public void setValue(byte[] b, int off, int len) {
        if (b == null) {
            return;
        }
        try {
            switch (len) {
                case 1: {
                    this.length = 1;
                    this.integerValue = new Long(b[off] & 0xFF);
                    break;
                }
                case 2: {
                    this.length = 2;
                    long longValue = (long)(b[off] & 0xFF) << 8 | (long)(b[off + 1] & 0xFF);
                    this.integerValue = new Long(longValue);
                    break;
                }
                case 4: {
                    long longValue = (long)(b[off] & 0xFF) << 24 | (long)(b[off + 1] & 0xFF) << 16 | (long)(b[off + 2] & 0xFF) << 8 | (long)(b[off + 3] & 0xFF);
                    this.integerValue = new Long(longValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setValue(String v) {
        this.setValue(Long.parseLong(v));
    }

    public Long getValue() {
        return this.integerValue;
    }

    @Override
    public String toString() {
        if (this.integerValue != null) {
            return this.integerValue.toString();
        }
        return "[Bad Integer Value]";
    }

    @Override
    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<int>");
        if (this.integerValue != null) {
            sb.append(this.integerValue);
        }
        sb.append("</int>");
        return sb.toString();
    }

    public void setLong(Long l) {
        this.integerValue = l;
    }

    @Override
    public Serializable getValueObject() {
        return this.integerValue;
    }

    @Override
    public void setValueObject(Serializable o) {
        if (o instanceof Long) {
            this.setLong((Long)o);
        } else if (o instanceof Number) {
            this.setLong(new Long(((Number)o).longValue()));
        } else {
            this.setLong(new Long(Long.parseLong(o.toString())));
        }
    }

    public void setValue(long l) throws NumberFormatException {
        if (!IntegerValue.isValid(l)) {
            throw new NumberFormatException("[bad unsigned integer value: " + String.valueOf(l) + "]");
        }
        this.integerValue = new Long(l);
    }

    public static boolean isValid(long l) {
        return l >= 0L && l <= 0xFFFFFFFFL;
    }
}

