/*
 * Decompiled with CFR 0.152.
 */
package net.newjradius.packet.attribute.value;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.newjradius.packet.attribute.value.AttributeValue;
import net.newjradius.util.Hex;

public class OctetsValue
extends AttributeValue {
    private static final long serialVersionUID = 0L;
    protected byte[] byteValue;
    protected int byteValueOffset;
    protected int byteValueLength;

    public OctetsValue() {
    }

    public OctetsValue(byte[] b) {
        this.byteValue = b;
    }

    @Override
    public void copy(AttributeValue value) {
        OctetsValue cValue = (OctetsValue)value;
        this.byteValue = new byte[cValue.byteValueLength];
        this.byteValueLength = cValue.byteValueLength;
        this.byteValueOffset = 0;
        if (this.byteValueLength > 0) {
            System.arraycopy(cValue.byteValue, cValue.byteValueOffset, this.byteValue, 0, this.byteValueLength);
        }
    }

    @Override
    public void getBytes(OutputStream out) throws IOException {
        if (this.byteValue != null) {
            out.write(this.byteValue, this.byteValueOffset, this.byteValueLength);
        }
    }

    @Override
    public void getBytes(ByteBuffer buffer) {
        if (this.byteValue != null) {
            buffer.put(this.byteValue, this.byteValueOffset, this.byteValueLength);
        }
    }

    @Override
    public void getBytes(ByteBuffer buffer, int off, int len) {
        if (this.byteValue != null) {
            buffer.put(this.byteValue, this.byteValueOffset + off, len);
        }
    }

    @Override
    public int getLength() {
        return this.byteValueLength;
    }

    @Override
    public void setValue(byte[] b) {
        this.byteValue = b;
        this.byteValueOffset = 0;
        this.byteValueLength = b == null ? 0 : b.length;
    }

    @Override
    public void setValue(byte[] b, int off, int len) {
        this.byteValue = b;
        this.byteValueOffset = off;
        this.byteValueLength = len;
    }

    @Override
    public String toDebugString() {
        return "[Binary Data: " + (this.byteValue == null ? "null" : "0x" + Hex.byteArrayToHexString(this.byteValue)) + "]";
    }

    @Override
    public String toString() {
        return "[Binary Data (length=" + (this.byteValue == null ? 0 : this.byteValueLength) + ")]";
    }

    @Override
    public Serializable getValueObject() {
        if (this.byteValueLength == 0) {
            return Integer.valueOf(0);
        }
        byte[] ret = new byte[this.byteValueLength];
        System.arraycopy(this.byteValue, this.byteValueOffset, ret, 0, this.byteValueLength);
        return ret;
    }

    @Override
    public void setValueObject(Serializable o) {
        if (o instanceof byte[]) {
            this.setValue((byte[])o);
        } else {
            this.setValue(o.toString().getBytes());
        }
    }
}

